/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.threed;

import fi.csc.microarray.client.visualisation.methods.threed.DataPoint;
import fi.csc.microarray.client.visualisation.methods.threed.Drawable;
import fi.csc.microarray.client.visualisation.methods.threed.Line;
import fi.csc.microarray.client.visualisation.methods.threed.Text;
import fi.csc.microarray.util.ScaleUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class DataModel {
    private static final Logger logger = Logger.getLogger(DataModel.class);
    private Color lineColor = Color.DARK_GRAY;
    public static Color[] qualitatativeColorScheme = new Color[]{new Color(31, 120, 180), new Color(227, 26, 28), new Color(51, 160, 44), new Color(255, 127, 0), new Color(106, 61, 154), new Color(166, 206, 227), new Color(178, 223, 138), new Color(251, 154, 153), new Color(253, 191, 111), new Color(202, 178, 214), new Color(255, 255, 153), Color.lightGray, Color.darkGray};
    public static Color[] sequentialColorScheme = new Color[]{new Color(255, 255, 204), new Color(255, 237, 160), new Color(254, 217, 118), new Color(254, 178, 76), new Color(253, 141, 60), new Color(252, 78, 42), new Color(227, 26, 28), new Color(189, 0, 38), new Color(128, 0, 38)};
    private Drawable[] points;
    private static final int LINE_COUNT = 4;
    private float[] cScale;
    private Float[] cValues;
    private Color[] colorScheme;

    public Color getColorFor(float value) {
        Color c = Color.gray;
        for (int i = 0; i < this.cScale.length - 1; ++i) {
            if (!(value >= this.cScale[i])) continue;
            c = this.getColorScheme()[i];
        }
        return c;
    }

    public DataModel() {
        this(sequentialColorScheme);
    }

    public DataModel(Color[] colorScheme) {
        this.colorScheme = colorScheme;
    }

    public void setData(Iterable<String> identifiers, Iterable<Float> xValues, Iterable<Float> yValues, Iterable<Float> zValues, Iterable<Float> cValuesIterable) {
        ArrayList<Drawable> points = new ArrayList<Drawable>();
        Iterator<String> identIter = identifiers.iterator();
        Iterator<Float> xIter = xValues.iterator();
        Iterator<Float> yIter = yValues.iterator();
        Iterator<Float> zIter = zValues.iterator();
        Iterator<Float> cIter = cValuesIterable.iterator();
        long time = 0L;
        logger.debug((Object)((System.currentTimeMillis() - time) / 1000L));
        time = System.currentTimeMillis();
        float[] minMaxX = this.findMinMaxValues(xIter);
        float[] minMaxY = this.findMinMaxValues(yIter);
        float[] minMaxZ = this.findMinMaxValues(zIter);
        float[] minMaxC = this.findMinMaxValues(cIter);
        logger.debug((Object)((System.currentTimeMillis() - time) / 1000L));
        time = System.currentTimeMillis();
        float[] xScale = ScaleUtil.generateScaleValues(minMaxX[0], minMaxX[1]);
        float[] yScale = ScaleUtil.generateScaleValues(minMaxY[0], minMaxY[1]);
        float[] zScale = ScaleUtil.generateScaleValues(minMaxZ[0], minMaxZ[1]);
        this.cScale = this.generateColorScaleValues(minMaxC[0], minMaxC[1]);
        points.addAll(this.generateScaleLines(xScale, yScale, zScale));
        xIter = xValues.iterator();
        yIter = yValues.iterator();
        zIter = zValues.iterator();
        cIter = cValuesIterable.iterator();
        logger.debug((Object)((System.currentTimeMillis() - time) / 1000L));
        time = System.currentTimeMillis();
        xIter = xValues.iterator();
        yIter = yValues.iterator();
        zIter = zValues.iterator();
        cIter = cValuesIterable.iterator();
        LinkedList<Float> cList = new LinkedList<Float>();
        int i = 0;
        while (identIter.hasNext() && xIter.hasNext() && yIter.hasNext() && zIter.hasNext() && cIter.hasNext()) {
            String identifier = identIter.next();
            float x = xIter.next().floatValue();
            float y = yIter.next().floatValue();
            float z = zIter.next().floatValue();
            float c = cIter.next().floatValue();
            float[] scaled = this.convertToScaled(xScale, yScale, zScale, this.cScale, new float[]{x, y, z, c});
            cList.add(Float.valueOf(c));
            Color color = this.getColorFor(scaled[3]);
            points.add(new DataPoint((double)scaled[0], (double)scaled[1], (double)scaled[2], color, 0.015, identifier, i));
            ++i;
        }
        this.cValues = cList.toArray(new Float[0]);
        logger.debug((Object)((System.currentTimeMillis() - time) / 1000L));
        time = System.currentTimeMillis();
        this.points = new Drawable[points.size()];
        for (i = 0; i < points.size(); ++i) {
            this.points[i] = (Drawable)points.get(i);
        }
        logger.debug((Object)((System.currentTimeMillis() - time) / 1000L));
        time = System.currentTimeMillis();
    }

    private float[] findMinMaxValues(Iterator<Float> iter) {
        float min = Float.MAX_VALUE;
        float max = Float.NEGATIVE_INFINITY;
        while (iter.hasNext()) {
            float x = iter.next().floatValue();
            if (x > max) {
                max = x;
            }
            if (!(x < min)) continue;
            min = x;
        }
        return new float[]{min, max};
    }

    public Drawable[] getDataArray() {
        return this.points;
    }

    private float[] convertToScaled(float[] xScale, float[] yScale, float[] zScale, float[] cScale, float[] original) {
        return new float[]{(original[0] - xScale[0]) / (xScale[3] - xScale[0]), (original[1] - yScale[0]) / (yScale[3] - yScale[0]), (original[2] - zScale[0]) / (zScale[3] - zScale[0]), original[3]};
    }

    protected float convertToScaled(float[] scale, float value) {
        return (value - scale[0]) / (scale[3] - scale[0]);
    }

    private String coordToString(float x, float y, float z) {
        return "(x " + ScaleUtil.format(x) + ", y " + ScaleUtil.format(y) + ", z " + ScaleUtil.format(z) + ")";
    }

    private List<Drawable> generateScaleLines(float[] xValues, float[] yValues, float[] zValues) {
        Color xColor = Color.gray;
        Color yColor = Color.gray;
        Color zColor = Color.gray;
        Color gray = Color.gray;
        ArrayList<Drawable> drawables = new ArrayList<Drawable>();
        drawables.add(new Line(0.0, 0.0, 0.0, 1.0, 0.0, 0.0, this.lineColor, 3));
        drawables.add(new Line(0.0, 0.0, 0.0, 0.0, 1.0, 0.0, this.lineColor, 3));
        drawables.add(new Line(0.0, 0.0, 0.0, 0.0, 0.0, 1.0, this.lineColor, 3));
        drawables.add(new Line(1.0, 0.0, 0.0, 0.99, 0.005, -0.01, this.lineColor, 3));
        drawables.add(new Line(1.0, 0.0, 0.0, 0.99, -0.01, 0.005, this.lineColor, 3));
        drawables.add(new Line(0.0, 1.0, 0.0, 0.005, 0.99, -0.01, this.lineColor, 3));
        drawables.add(new Line(0.0, 1.0, 0.0, -0.01, 0.99, 0.005, this.lineColor, 3));
        drawables.add(new Line(0.0, 0.0, 1.0, -0.01, 0.005, 0.99, this.lineColor, 3));
        drawables.add(new Line(0.0, 0.0, 1.0, 0.005, -0.01, 0.99, this.lineColor, 3));
        drawables.add(new Text(1.03f, 0.0f, 0.0f, "X", gray, true));
        drawables.add(new Text(0.0f, 1.03f, 0.0f, "Y", gray, true));
        drawables.add(new Text(0.0f, 0.0f, 1.03f, "Z", gray, true));
        float TEXT_0 = 0.0f;
        float TEXT_1 = 1.1f;
        int L = 3;
        drawables.add(new Text(0.0f, 0.0f, 0.0f, this.coordToString(xValues[0], yValues[0], zValues[0]), gray));
        drawables.add(new Text(1.1f, 0.0f, 0.0f, this.coordToString(xValues[L], yValues[0], zValues[0]), gray));
        drawables.add(new Text(1.1f, 0.0f, 1.1f, this.coordToString(xValues[L], yValues[0], zValues[L]), gray));
        drawables.add(new Text(0.0f, 0.0f, 1.1f, this.coordToString(xValues[0], yValues[0], zValues[L]), gray));
        drawables.add(new Text(0.0f, 1.1f, 0.0f, this.coordToString(xValues[0], yValues[L], zValues[L]), gray));
        drawables.add(new Text(1.1f, 1.1f, 0.0f, this.coordToString(xValues[L], yValues[L], zValues[0]), gray));
        drawables.add(new Text(0.0f, 1.1f, 1.1f, this.coordToString(xValues[0], yValues[L], zValues[L]), gray));
        for (int i = 1; i < 4; ++i) {
            String zText;
            String yText;
            String xText;
            float pos = (float)i / 3.0f;
            if (i != 3) {
                xText = "x " + ScaleUtil.format(xValues[i]);
                yText = "y " + ScaleUtil.format(yValues[i]);
                zText = "z " + ScaleUtil.format(zValues[i]);
            } else {
                xText = null;
                yText = null;
                zText = null;
            }
            drawables.add(new Line(pos, 0.0, 0.0, pos, 1.0, 0.0, this.lineColor));
            drawables.add(new Line(pos, 0.0, 0.0, pos, 0.0, 1.0, this.lineColor));
            drawables.add(new Text(pos, 1.1f, 0.0f, xText, xColor));
            drawables.add(new Text(pos, 0.0f, 1.1f, xText, xColor));
            drawables.add(new Line(0.0, pos, 0.0, 0.0, pos, 1.0, this.lineColor));
            drawables.add(new Line(0.0, pos, 0.0, 1.0, pos, 0.0, this.lineColor));
            drawables.add(new Text(0.0f, pos, 1.1f, yText, yColor));
            drawables.add(new Text(1.1f, pos, 0.0f, yText, yColor));
            drawables.add(new Line(0.0, 0.0, pos, 1.0, 0.0, pos, this.lineColor));
            drawables.add(new Line(0.0, 0.0, pos, 0.0, 1.0, pos, this.lineColor));
            drawables.add(new Text(1.1f, 0.0f, pos, zText, zColor));
            drawables.add(new Text(0.0f, 1.1f, pos, zText, zColor));
        }
        return drawables;
    }

    private float[] generateColorScaleValues(float min, float max) {
        int colorCount = this.getColorScheme().length + 1;
        float[] values = new float[colorCount];
        for (int i = 0; i < colorCount; ++i) {
            values[i] = min + (max - min) / (float)(colorCount - 1) * (float)i;
        }
        return values;
    }

    public float[] getColorScaleValues() {
        return this.cScale;
    }

    public Float[] getColorValues() {
        return this.cValues;
    }

    public Color[] getColorScheme() {
        return this.colorScheme;
    }
}

