/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.comp;

import fi.csc.microarray.comp.ToolTestResult;
import fi.csc.microarray.comp.ToolTestSummary;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class ToolTestHtmlFile {
    private static final String CSS = "<style type=\"text/css\">th {text-align: left; border-bottom-width: 1; border-bottom-style: solid}td {padding-right: 1em}h3 {margin-top: 2em}a {text-decoration: none}</style>";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(ToolTestSummary summary, File webDir) throws IOException {
        File htmlFile = new File(webDir, "index.html");
        File sessionsDir = new File(webDir, "sessions");
        File screenOutputsDir = new File(webDir, "screen-outputs");
        try (FileWriter writer = new FileWriter(htmlFile);){
            writer.write("<html>");
            writer.write("<head><style type=\"text/css\">th {text-align: left; border-bottom-width: 1; border-bottom-style: solid}td {padding-right: 1em}h3 {margin-top: 2em}a {text-decoration: none}</style></head>");
            writer.write("<body>");
            String titleStatus = "<span style=\"color: green\">everything ok!</span>";
            if (summary.getFailedJobs().size() > 0 || summary.getSessionsWithErrors().size() > 0 || summary.getSessionsWithMissingTools().size() > 0) {
                titleStatus = "<span style=\"color: red\">" + summary.getFailCounts().keySet().size() + " tool(s) failed in " + summary.getFailedJobs().size() + " test(s), " + summary.getSessionsWithErrors().size() + " session(s) with errors, " + summary.getSessionsWithMissingTools().size() + " sessions(s) with missing tools</span>";
            }
            writer.write("<h2>Tool tests &ndash; " + titleStatus + "</h2>");
            writer.write("<h3>Summary</h3>");
            String timesHtml = "";
            if (summary.getDuration() > 0L) {
                long duration = summary.getDuration() / 1000L;
                timesHtml = timesHtml + "<tr><td>Total time</td><td>" + String.format("%02dm %02ds", duration / 60L, duration % 60L) + "</td></tr>";
            }
            if (summary.getStartTime() != null) {
                timesHtml = timesHtml + "<tr><td>Start time</td><td>" + summary.getStartTime() + "</td></tr>";
            }
            writer.write("<table><tr><td>Results summary</td><td>" + summary.getSuccessfulJobs().size() + " <span" + (summary.getSuccessfulJobs().isEmpty() ? "" : " style=\"color: green\"") + ">ok</span>, " + summary.getFailedJobs().size() + " <span" + (summary.getFailedJobs().isEmpty() ? "" : " style=\"color: red\"") + ">failed</span>, " + summary.getToolTestResults().size() + " total</td</tr><tr><td>Tool coverage</td><td>" + summary.getUniqueTools().size() + "/" + summary.getAllTools().size() + "</td></tr><tr><td>Sessions</td><td>" + summary.getUniqueSessions().size() + " total, " + summary.getSessionsWithErrors().size() + " <span" + (summary.getSessionsWithErrors().isEmpty() ? "" : " style=\"color: red\"") + ">with errors</span>, " + summary.getSessionsWithMissingTools().size() + " <span" + (summary.getSessionsWithMissingTools().isEmpty() ? "" : " style=\"color: red\"") + ">with missing tools</span> </td></tr>" + timesHtml + "</table>");
            if (summary.getSessionsWithErrors().size() > 0) {
                writer.write("<h3>Sessions with errors</h3>");
                writer.write("<table><tr><th>Session</th><th>Exception</th></tr>");
                for (File f : summary.getSessionsWithErrors().keySet()) {
                    writer.write("<tr><td>" + f.getName() + "</td><td><a href=\"" + "stacktraces" + "/" + summary.getSessionsWithErrors().get(f) + "\">exception</a></td></tr>");
                }
                writer.write("</table>");
            }
            if (summary.getSessionsWithMissingTools().size() > 0) {
                writer.write("<h3>Sessions with missing tools</h3>");
                writer.write("<table><tr><th>Session</th><th>Tool</th></tr>");
                for (File f : summary.getSessionsWithMissingTools().keySet()) {
                    writer.write("<tr><td>" + f.getName() + "</td><td>" + summary.getSessionsWithMissingTools().get(f) + "</td></tr>");
                }
                writer.write("</table>");
            }
            writer.write("<h3>Tool test results</h3>");
            writer.write("<table><tr><th>Tool</th><th>Tool id</th><th>Result</th><th>Session</th><th>Task state</th><th>Test error message</th><th>Task error message</th><th>Task screen output</th><th>Duration</th><th>Outputs with mismatching sizes</th><th>Outputs with mismatching contents</th></tr>");
            for (ToolTestResult toolTestResult : summary.getFailedJobs()) {
                writer.write("<tr><td>" + toolTestResult.getToolFullName() + "</nobr></td><td><nobr>" + toolTestResult.getToolId() + "</nobr></td><td style=\"color: red\">" + (Object)((Object)toolTestResult.getTestResult()) + "</td><td>" + ToolTestHtmlFile.createSessionLink(toolTestResult.getSession(), sessionsDir) + "</td><td>" + toolTestResult.getTaskState() + "</td><td>" + ToolTestHtmlFile.nullToEmpty(toolTestResult.getTestErrorMessage()) + "</td><td>" + ToolTestHtmlFile.nullToEmpty(toolTestResult.getTaskErrorMessage()) + "</td><td>" + ToolTestHtmlFile.createScreenOutputLink(toolTestResult.getTaskId(), screenOutputsDir) + "</td><td><nobr>" + ToolTestHtmlFile.getDurationString(toolTestResult.getTaskDuration()) + "</nobr></td><td>" + ToolTestHtmlFile.getOutputsWithMisMatchingSizes(toolTestResult) + "</td><td>" + ToolTestHtmlFile.getOutputsWithMisMatchingContents(toolTestResult) + "</td></tr>");
            }
            for (ToolTestResult toolTestResult : summary.getSuccessfulJobs()) {
                writer.write("<tr><td><nobr>" + toolTestResult.getToolFullName() + "</nobr></td><td><nobr>" + toolTestResult.getToolId() + "</nobr></td><td>" + (Object)((Object)toolTestResult.getTestResult()) + "</td><td>" + ToolTestHtmlFile.createSessionLink(toolTestResult.getSession(), sessionsDir) + "</td><td>" + toolTestResult.getTaskState() + "</td><td>" + ToolTestHtmlFile.nullToEmpty(toolTestResult.getTestErrorMessage()) + "</td><td>" + ToolTestHtmlFile.nullToEmpty(toolTestResult.getTaskErrorMessage()) + "</td><td>" + ToolTestHtmlFile.createScreenOutputLink(toolTestResult.getTaskId(), screenOutputsDir) + "</td><td><nobr>" + ToolTestHtmlFile.getDurationString(toolTestResult.getTaskDuration()) + "</nobr></td><td>" + ToolTestHtmlFile.getOutputsWithMisMatchingSizes(toolTestResult) + "</td><td>" + ToolTestHtmlFile.getOutputsWithMisMatchingContents(toolTestResult) + "</td></tr>");
            }
            writer.write("</table>");
            writer.write("<h3>Coverage</h3>");
            writer.write("<table><tr><th>Tool </th><th>Tool id</th><th>Count</th><th>Sessions</th></tr>");
            for (String toolID : summary.getToolsSortedbyTestCount()) {
                String sessionsString = "";
                for (File session : summary.getToolToSessionsMap().get(toolID)) {
                    sessionsString = sessionsString + session.getName() + " ";
                }
                sessionsString.trim();
                writer.write("<tr><td>" + summary.getAllTools().get(toolID) + "</td><td>" + toolID + "</td><td>" + summary.getUniqueTools().get(toolID) + "</td><td>" + sessionsString + "</td></tr>");
            }
            for (String toolId : summary.getAllTools().keySet()) {
                if (summary.getUniqueTools().containsKey(toolId)) continue;
                writer.write("<tr><td>" + summary.getAllTools().get(toolId) + "</td><td>" + toolId + "</td><td>" + 0 + "</td><td></td></tr>");
            }
            writer.write("</table>");
            writer.write("</body></html>");
            writer.flush();
        }
    }

    private static String nullToEmpty(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    private static String createSessionLink(File sessionFile, File sessionsDir) {
        return sessionFile.getName();
    }

    private static String createScreenOutputLink(String taskId, File screenOutputsDir) {
        return "<a href=\"" + screenOutputsDir.getName() + "/" + taskId + "-output.txt" + "\">output</a>";
    }

    private static String getDurationString(long duration) {
        long d = duration / 1000L;
        return String.format("%02dm %02ds", d / 60L, d % 60L);
    }

    private static String getOutputsWithMisMatchingSizes(ToolTestResult toolTestResult) {
        String s = "";
        for (String output : toolTestResult.getOutputsWithMisMatchingSizes()) {
            s = s + output + ", ";
        }
        if (s.endsWith(", ")) {
            s = s.substring(0, s.length() - ", ".length());
        }
        return s;
    }

    private static String getOutputsWithMisMatchingContents(ToolTestResult toolTestResult) {
        String s = "";
        for (String output : toolTestResult.getOutputsWithMisMatchingContents()) {
            s = s + output + ", ";
        }
        if (s.endsWith(", ")) {
            s = s.substring(0, s.length() - ", ".length());
        }
        return s;
    }
}

