/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.databeans;

import fi.csc.microarray.ClientContextUtil;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.session.SessionManager;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataManager;
import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DataManagerTest {
    private DataManager manager;
    private SessionManager sessionManager;

    @Before
    public void init() throws Exception {
        ClientContextUtil.setupClientContext();
        this.manager = Session.getSession().getDataManager();
        this.sessionManager = new SessionManager(this.manager, null, Session.getSession().getServiceAccessor().getFileBrokerClient(), null);
    }

    @Test
    public void testDataTypes() throws IOException {
        File file = File.createTempFile("test", ".png");
        Assert.assertEquals((Object)this.manager.guessContentType(file).getType(), (Object)"image/png");
    }

    @Test
    public void testRemoteSessions() throws Exception {
        File content = File.createTempFile("content", ".tsv");
        DataBean data = this.manager.createDataBean("test-content", content);
        ClientContextUtil.setupDatabean(data);
        this.manager.connectChild(data, this.manager.getRootFolder());
        File session = File.createTempFile("test-remote-session", ".zip");
        this.sessionManager.saveLightweightSession(session);
        this.manager.deleteAllDataItems();
        this.sessionManager.loadLocalSession(session, true);
        Assert.assertEquals((long)this.manager.getRootFolder().getChildCount(), (long)1L);
        Assert.assertEquals((Object)this.manager.getRootFolder().getChildren().iterator().next().getName(), (Object)"test-content");
        this.manager.deleteAllDataItems();
    }
}

