/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.databeans.handlers;

import fi.csc.microarray.databeans.DataManager;
import fi.csc.microarray.databeans.handlers.ContentHandler;
import fi.csc.microarray.util.KeyAndTrustManager;
import fi.csc.microarray.util.UrlTransferUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;

public class RemoteContentHandler
implements ContentHandler {
    private static int BLACKLIST_LIFETIME_MILLISECONDS = 30 * UrlTransferUtil.HTTP_TIMEOUT_MILLISECONDS;
    private LinkedList<BlacklistEntry> hostBlacklist = new LinkedList();

    @Override
    public InputStream getInputStream(DataManager.ContentLocation location) throws IOException {
        this.checkCompatibility(location);
        HttpURLConnection connection = (HttpURLConnection)location.getUrl().openConnection();
        KeyAndTrustManager.configureForCACertificates(connection);
        return connection.getInputStream();
    }

    @Override
    public OutputStream getOutputStream(DataManager.ContentLocation location) throws IOException {
        throw new UnsupportedOperationException("remote content handler does not support output");
    }

    @Override
    public Long getContentLength(DataManager.ContentLocation location) throws IOException {
        this.checkCompatibility(location);
        return UrlTransferUtil.getContentLength(location.getUrl(), false);
    }

    @Override
    public void markDeletable(DataManager.ContentLocation location) {
    }

    @Override
    public void checkCompatibility(DataManager.ContentLocation location) throws IllegalArgumentException {
        URL url = location.getUrl();
        if (url == null) {
            throw new IllegalArgumentException("url is null.");
        }
        if (!"http".equals(url.getProtocol()) && !"https".equals(url.getProtocol())) {
            throw new IllegalArgumentException("Protocol of " + url.toString() + " is not HTTP compatible.");
        }
        if (url.getPath() == null || url.getPath().length() == 0) {
            throw new IllegalArgumentException("Illegal path: " + url.toString());
        }
    }

    @Override
    public boolean isAccessible(DataManager.ContentLocation location) {
        this.checkCompatibility(location);
        URL url = location.getUrl();
        try {
            if (this.isBlacklisted(url.getHost(), url.getPort())) {
                return false;
            }
            return UrlTransferUtil.isAccessible(url, false);
        }
        catch (IOException e) {
            this.blacklist(url.getHost(), url.getPort());
            return false;
        }
    }

    private boolean isBlacklisted(String host, int port) {
        Calendar c = Calendar.getInstance();
        c.add(14, -BLACKLIST_LIFETIME_MILLISECONDS);
        Date lastValid = c.getTime();
        LinkedList<BlacklistEntry> outdated = new LinkedList<BlacklistEntry>();
        for (BlacklistEntry entry : this.hostBlacklist) {
            if (!entry.created.before(lastValid)) continue;
            outdated.add(entry);
        }
        this.hostBlacklist.removeAll(outdated);
        return this.hostBlacklist.contains(new BlacklistEntry(host, port));
    }

    private void blacklist(String host, int port) {
        this.hostBlacklist.add(new BlacklistEntry(host, port));
    }

    private static class BlacklistEntry {
        public String host;
        public int port;
        public Date created = new Date();

        public BlacklistEntry(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public boolean equals(Object other) {
            if (other instanceof BlacklistEntry) {
                BlacklistEntry otherEntry = (BlacklistEntry)other;
                return this.host.equals(otherEntry.host) && this.port == otherEntry.port;
            }
            return false;
        }
    }
}

