/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.description;

import fi.csc.microarray.description.GenericInputTypes;
import fi.csc.microarray.description.SADLDescription;
import fi.csc.microarray.description.SADLSyntax;
import fi.csc.microarray.description.SADLTokeniser;
import fi.csc.microarray.exception.MicroarrayException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class SADLParser {
    private static final Logger logger = Logger.getLogger(SADLParser.class);
    private String unitName;
    private HashMap<String, SADLSyntax.InputType> inputTypeMap = new HashMap();

    public static String generateOperationIdentifier(String category, String name) {
        return "\"" + category + "\"/\"" + name + "\"";
    }

    public SADLParser() {
        this(null);
    }

    public SADLParser(String filename) {
        this.unitName = filename;
        this.addInputType(GenericInputTypes.GENERIC);
    }

    public SADLDescription parse(String sadlString) throws ParseException {
        SADLTokeniser tokens = new SADLTokeniser(sadlString, this.unitName);
        return this.parseTool(tokens);
    }

    public List<SADLDescription> parseMultiple(String sadlString) throws ParseException {
        LinkedList<SADLDescription> descriptions = new LinkedList<SADLDescription>();
        SADLTokeniser tokens = new SADLTokeniser(sadlString, this.unitName);
        boolean parsingPreviousSuccessful = true;
        while (tokens.hasNext()) {
            try {
                descriptions.add(this.parseTool(tokens));
                parsingPreviousSuccessful = true;
            }
            catch (ParseException pe) {
                pe.printStackTrace();
                if (parsingPreviousSuccessful) {
                    descriptions.removeLast();
                    logger.error((Object)"Could not parse description. ", (Throwable)pe);
                }
                parsingPreviousSuccessful = false;
            }
        }
        return descriptions;
    }

    public void addInputType(SADLSyntax.InputType type) {
        this.inputTypeMap.put(type.getName(), type);
    }

    private SADLDescription parseTool(SADLTokeniser tokens) throws ParseException {
        this.skip(tokens, "TOOL");
        SADLDescription.Name name = this.parseName(tokens);
        SADLDescription description = new SADLDescription(name);
        if (tokens.peekType() == SADLTokeniser.TokenType.DESCRIPTION) {
            description.setDescription(tokens.next());
        }
        while (this.nextTokenIs(tokens, "INPUT")) {
            this.skip(tokens, "INPUT");
            SADLDescription.Input input = this.parseInput(tokens, description);
            description.addInput(input);
        }
        while (this.nextTokenIs(tokens, "OUTPUT")) {
            this.skip(tokens, "OUTPUT");
            description.addOutput(this.parseOutput(tokens));
        }
        while (this.nextTokenIs(tokens, "PARAMETER")) {
            this.skip(tokens, "PARAMETER");
            SADLDescription.Parameter parameter = this.parseParameter(tokens);
            description.addParameter(parameter);
        }
        while (this.nextTokenIs(tokens, "RUNTIME")) {
            this.skip(tokens, "RUNTIME");
            String runtime = this.parseRuntime(tokens);
            description.setRuntime(runtime);
        }
        while (this.nextTokenIs(tokens, "SLOTS")) {
            this.skip(tokens, "SLOTS");
            int slotCount = this.parseInt(tokens);
            description.setSlotCount(slotCount);
        }
        if (tokens.hasNext() && !this.nextTokenIs(tokens, "TOOL")) {
            throw new ParseException("unexpected content: " + tokens.next(), this.unitName);
        }
        return description;
    }

    private void skip(SADLTokeniser tokens, String token) throws ParseException {
        String next = tokens.next();
        if (!token.equals(next)) {
            throw new ParseException("expected " + token + ", not " + next, this.unitName);
        }
    }

    private boolean nextTokenIs(SADLTokeniser tokens, String token) {
        return tokens.hasNext() && token.equals(tokens.peek());
    }

    private SADLDescription.Name parseName(SADLTokeniser tokens) throws ParseException {
        SADLDescription.Name name = SADLDescription.Name.createEmptyName();
        String rawName = tokens.next();
        if (rawName.contains("{...}")) {
            name.setPrefix(rawName.substring(0, rawName.indexOf("{...}")));
            name.setPostfix(rawName.substring(rawName.indexOf("{...}") + "{...}".length()));
        } else {
            name.setID(rawName);
        }
        if (tokens.hasNext() && ":".equals(tokens.peek())) {
            this.skip(tokens, ":");
            name.setDisplayName(tokens.next());
        }
        if (name.getID() == null && name.getPrefix() == null && name.getPostfix() == null) {
            throw new ParseException("id, prefix and postfix are all null");
        }
        return name;
    }

    private String parseRuntime(SADLTokeniser tokens) throws ParseException {
        return tokens.next();
    }

    private int parseInt(SADLTokeniser tokens) throws ParseException {
        String nextToken = tokens.next();
        try {
            return Integer.parseInt(nextToken);
        }
        catch (NumberFormatException e) {
            throw new ParseException("slot count is not integer: " + nextToken);
        }
    }

    private SADLDescription.Output parseOutput(SADLTokeniser tokens) throws ParseException {
        SADLDescription.Output output = new SADLDescription.Output();
        boolean isMeta = this.parseMetaIfExists(tokens);
        output.setMeta(isMeta);
        boolean isOptional = this.parseOptionalIfExists(tokens);
        output.setOptional(isOptional);
        output.setName(this.parseName(tokens));
        if (tokens.peekType() == SADLTokeniser.TokenType.DESCRIPTION) {
            output.setDescription(tokens.next());
        }
        return output;
    }

    private SADLDescription.Input parseInput(SADLTokeniser tokens, SADLDescription description) throws ParseException {
        SADLDescription.Input input = new SADLDescription.Input();
        boolean isMeta = this.parseMetaIfExists(tokens);
        input.setMeta(isMeta);
        boolean isOptional = this.parseOptionalIfExists(tokens);
        input.setOptional(isOptional);
        input.setName(this.parseName(tokens));
        this.skip(tokens, "TYPE");
        String inputTypeName = tokens.next();
        SADLSyntax.InputType inputType = this.inputTypeMap.get(inputTypeName);
        if (inputType == null) {
            throw new ParseException("Invalid input type: " + inputTypeName, description.getName().getID());
        }
        input.setType(inputType);
        if (tokens.peekType() == SADLTokeniser.TokenType.DESCRIPTION) {
            input.setDescription(tokens.next());
        }
        return input;
    }

    private boolean parseMetaIfExists(SADLTokeniser tokens) throws ParseException {
        if (this.nextTokenIs(tokens, "META")) {
            this.skip(tokens, "META");
            return true;
        }
        return false;
    }

    private boolean parseOptionalIfExists(SADLTokeniser tokens) throws ParseException {
        if (this.nextTokenIs(tokens, "OPTIONAL")) {
            this.skip(tokens, "OPTIONAL");
            return true;
        }
        return false;
    }

    private SADLDescription.Parameter parseParameter(SADLTokeniser tokens) throws ParseException {
        boolean isOptional = this.parseOptionalIfExists(tokens);
        SADLDescription.Name name = this.parseName(tokens);
        this.skip(tokens, "TYPE");
        SADLSyntax.ParameterType type = null;
        SADLDescription.Name[] options = null;
        if (this.nextTokenIs(tokens, "[")) {
            options = this.parseEnumType(tokens);
            type = SADLSyntax.ParameterType.ENUM;
        } else {
            type = SADLSyntax.ParameterType.valueOf(tokens.next());
        }
        String from = null;
        String to = null;
        String[] defaultValues = new String[]{};
        if (this.nextTokenIs(tokens, "FROM")) {
            this.skip(tokens, "FROM");
            from = tokens.next();
        }
        if (this.nextTokenIs(tokens, "TO")) {
            this.skip(tokens, "TO");
            to = tokens.next();
        }
        if (this.nextTokenIs(tokens, "DEFAULT")) {
            this.skip(tokens, "DEFAULT");
            defaultValues = this.parseDefaultValues(tokens);
        }
        SADLDescription.Parameter parameter = new SADLDescription.Parameter(name, type, options, from, to, defaultValues);
        parameter.setOptional(isOptional);
        if (tokens.peekType() == SADLTokeniser.TokenType.DESCRIPTION) {
            parameter.setDescription(tokens.next());
        }
        return parameter;
    }

    private String[] parseDefaultValues(SADLTokeniser tokens) throws ParseException {
        LinkedList<String> list = new LinkedList<String>();
        while (true) {
            list.add(tokens.next());
            if (!this.nextTokenIs(tokens, ",")) break;
            this.skip(tokens, ",");
        }
        return list.toArray(new String[0]);
    }

    private SADLDescription.Name[] parseEnumType(SADLTokeniser tokens) throws ParseException {
        this.skip(tokens, "[");
        LinkedList<SADLDescription.Name> list = new LinkedList<SADLDescription.Name>();
        while (true) {
            list.add(this.parseName(tokens));
            if (this.nextTokenIs(tokens, "]")) break;
            this.skip(tokens, ",");
        }
        this.skip(tokens, "]");
        return list.toArray(new SADLDescription.Name[0]);
    }

    public static class ParseException
    extends MicroarrayException {
        public ParseException(String msg) {
            super(msg);
        }

        public ParseException(String msg, String filename) {
            super(msg + (filename != null ? " (in " + filename + ")" : ""));
        }
    }
}

