/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.filebroker;

import fi.csc.microarray.filebroker.FileBrokerClient;
import fi.csc.microarray.security.CryptoKey;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public class AuthorisedUrlRepository {
    private static Logger logger = Logger.getLogger(AuthorisedUrlRepository.class);
    private static final int URL_LIFETIME_MINUTES = 10;
    private static final String COMPRESSION_SUFFIX = ".compressed";
    private HashMap<URL, Authorisation> repository = new HashMap();
    private Lock repositoryLock = new ReentrantLock();
    private String host;
    private int port;
    private String cachePath;
    private String storagePath;

    public AuthorisedUrlRepository(String host, int port, String cachePath, String storagePath) {
        this.host = host;
        this.port = port;
        this.cachePath = cachePath;
        this.storagePath = storagePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL createAuthorisedUrl(String fileId, boolean useCompression, FileBrokerClient.FileBrokerArea area, long bytes) throws Exception {
        URL newUrl;
        String compressionSuffix = "";
        if (useCompression) {
            compressionSuffix = COMPRESSION_SUFFIX;
        }
        this.repositoryLock.lock();
        try {
            newUrl = area == FileBrokerClient.FileBrokerArea.STORAGE ? this.constructStorageURL(fileId, compressionSuffix) : this.constructCacheURL(fileId, compressionSuffix);
            if (this.repository.containsKey(newUrl)) {
                logger.debug((Object)"repository contains the url already, timestamp is renewed");
            }
            this.repository.put(newUrl, new Authorisation(bytes));
        }
        finally {
            this.repositoryLock.unlock();
        }
        return newUrl;
    }

    public URL constructStorageURL(String filename, String compressionSuffix) throws MalformedURLException {
        return new URL(this.host + ":" + this.port + "/" + this.storagePath + "/" + filename + compressionSuffix);
    }

    public URL constructCacheURL(String filename, String compressionSuffix) throws MalformedURLException {
        return new URL(this.host + ":" + this.port + "/" + this.cachePath + "/" + filename + compressionSuffix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Authorisation getAuthorisation(URL url) {
        Authorisation authorisation = null;
        this.repositoryLock.lock();
        try {
            Iterator<URL> keyIterator = this.repository.keySet().iterator();
            while (keyIterator.hasNext()) {
                URL key = keyIterator.next();
                if (this.isDateValid(this.repository.get(key).getCreated())) continue;
                keyIterator.remove();
            }
            authorisation = this.repository.get(url);
        }
        finally {
            this.repositoryLock.unlock();
        }
        if (authorisation != null) {
            return new Authorisation(authorisation);
        }
        return null;
    }

    public static String stripCompressionSuffix(String filename) {
        if (filename.endsWith(COMPRESSION_SUFFIX)) {
            return filename.substring(0, filename.length() - COMPRESSION_SUFFIX.length());
        }
        return filename;
    }

    public static boolean checkFilenameSyntax(String filename) {
        String fileNameToCheck = AuthorisedUrlRepository.stripCompressionSuffix(filename);
        return CryptoKey.validateKeySyntax(fileNameToCheck);
    }

    private boolean isDateValid(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        ((Calendar)cal).add(12, -10);
        return cal.getTime().before(date);
    }

    public String getRootUrl() {
        return this.host + ":" + this.port;
    }

    public static class Authorisation {
        private Date created;
        private long fileSize;

        public Authorisation(Date created, long fileSize) {
            this.created = created;
            this.fileSize = fileSize;
        }

        public Authorisation(long fileSize) {
            this(new Date(), fileSize);
        }

        public Authorisation(Authorisation o) {
            this(o.created, o.fileSize);
        }

        public Date getCreated() {
            return this.created;
        }

        public void setCreated(Date created) {
            this.created = created;
        }

        public long getFileSize() {
            return this.fileSize;
        }

        public void setFileSize(long fileSize) {
            this.fileSize = fileSize;
        }
    }
}

