/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.jobmanager;

import com.google.gson.Gson;
import fi.csc.microarray.config.Configuration;
import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.constants.ApplicationConstants;
import fi.csc.microarray.jobmanager.model.Job;
import fi.csc.microarray.jobmanager.model.JobManagerDB;
import fi.csc.microarray.messaging.JMSMessagingEndpoint;
import fi.csc.microarray.messaging.JobState;
import fi.csc.microarray.messaging.MessagingEndpoint;
import fi.csc.microarray.messaging.MessagingListener;
import fi.csc.microarray.messaging.MessagingTopic;
import fi.csc.microarray.messaging.MonitoredNodeBase;
import fi.csc.microarray.messaging.Topics;
import fi.csc.microarray.messaging.message.ChipsterMessage;
import fi.csc.microarray.messaging.message.CommandMessage;
import fi.csc.microarray.messaging.message.JobLogMessage;
import fi.csc.microarray.messaging.message.JobMessage;
import fi.csc.microarray.messaging.message.JsonMessage;
import fi.csc.microarray.messaging.message.ResultMessage;
import fi.csc.microarray.messaging.message.ServerStatusMessage;
import fi.csc.microarray.service.KeepAliveShutdownHandler;
import fi.csc.microarray.service.ShutdownCallback;
import fi.csc.microarray.util.Exceptions;
import fi.csc.microarray.util.SystemMonitorUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.jms.Destination;
import javax.jms.JMSException;
import org.apache.log4j.Logger;

public class JobManager
extends MonitoredNodeBase
implements MessagingListener,
ShutdownCallback {
    private int jobMaxWaitTime;
    private static Logger logger;
    private MessagingEndpoint endpoint;
    MessagingTopic fromClientTopic;
    MessagingTopic jobManagerAdminTopic;
    MessagingTopic jobManagerTopic;
    MessagingTopic compTopic;
    private JobManagerDB jobsDb;

    public JobManager(String configURL) throws Exception {
        DirectoryLayout.initialiseServerLayout(Arrays.asList("jobmanager"), configURL);
        Configuration configuration = DirectoryLayout.getInstance().getConfiguration();
        logger = Logger.getLogger(JobManager.class);
        logger.info((Object)"starting jobmanager service...");
        this.jobMaxWaitTime = configuration.getInt("jobmanager", "job-max-wait-time");
        this.jobsDb = new JobManagerDB(configuration);
        this.endpoint = new JMSMessagingEndpoint(this);
        this.fromClientTopic = this.endpoint.createTopic(Topics.Name.AUTHORISED_REQUEST_TOPIC, MessagingTopic.AccessMode.READ);
        this.fromClientTopic.setListener(new ClientMessageListener());
        this.jobManagerAdminTopic = this.endpoint.createTopic(Topics.Name.JOBMANAGER_ADMIN_TOPIC, MessagingTopic.AccessMode.READ);
        this.jobManagerAdminTopic.setListener(this);
        this.jobManagerTopic = this.endpoint.createTopic(Topics.Name.JOBMANAGER_TOPIC, MessagingTopic.AccessMode.READ);
        this.jobManagerTopic.setListener(new CompMessageListener());
        this.compTopic = this.endpoint.createTopic(Topics.Name.AUTHORIZED_MANAGED_REQUEST_TOPIC, MessagingTopic.AccessMode.WRITE);
        KeepAliveShutdownHandler.init(this);
        logger.info((Object)("jobmanager is up and running [" + ApplicationConstants.VERSION + "]"));
        logger.info((Object)("[mem: " + SystemMonitorUtil.getMemInfo() + "]"));
    }

    private void scheduleWaitingJobs() {
        List<Job> waitingJobs = this.jobsDb.getWaitingJobs();
        if (waitingJobs.size() > 0) {
            logger.info((Object)("rescheduling " + waitingJobs.size() + " waiting jobs"));
        }
        LinkedList<String> jobsToBeExpired = new LinkedList<String>();
        for (Job job : waitingJobs) {
            try {
                if (this.rescheduleJob(job.getJobId())) continue;
                jobsToBeExpired.add(job.getJobId());
            }
            catch (Exception e) {
                logger.warn((Object)("could not reschedule job " + job.getJobId()), (Throwable)e);
            }
        }
        for (String jobId : jobsToBeExpired) {
            try {
                this.jobsDb.updateJobMaxWaitTimeReached(jobId);
                Job job = this.jobsDb.getJob(jobId);
                if (job == null) continue;
                logger.warn((Object)("sending job wait expired for job " + jobId));
                ResultMessage msg = new ResultMessage();
                msg.setJobId(jobId);
                msg.setState(JobState.FAILED);
                msg.setErrorMessage("There was no computing server available to run this job, please try again later on");
                try {
                    this.endpoint.sendMessageToClientReplyChannel(job.getReplyTo(), msg);
                }
                catch (Exception exception) {
                }
            }
            catch (Exception e) {
                logger.error((Object)Exceptions.getStackTrace(e));
            }
        }
    }

    private boolean rescheduleJob(String jobId) {
        Job job = this.jobsDb.getJob(jobId);
        if (job == null) {
            logger.warn((Object)("trying to reschedule non existing job " + jobId));
            return false;
        }
        if (job.getSecondsSinceCreated() > (long)this.jobMaxWaitTime) {
            logger.warn((Object)("max wait time reached for job " + jobId));
            return false;
        }
        try {
            JobMessage jobMessage = job.getJobMessage();
            jobMessage.setReplyTo((Destination)this.jobManagerTopic.getJMSTopic());
            this.compTopic.sendMessage(jobMessage);
        }
        catch (JMSException e) {
            logger.error((Object)("send message failed when reschedulig job " + jobId));
            return true;
        }
        return true;
    }

    @Override
    public void onChipsterMessage(ChipsterMessage msg) {
        try {
            if (msg instanceof ServerStatusMessage) {
                logger.warn((Object)"got ServerStatusMessage");
            } else if (msg instanceof CommandMessage) {
                CommandMessage commandMessage = (CommandMessage)msg;
                if ("get-running-jobs".equals(commandMessage.getCommand())) {
                    logger.info((Object)"got list running jobs");
                    this.handleListRunningJobs(commandMessage);
                } else if ("cancel".equals(commandMessage.getCommand())) {
                    String jobId = commandMessage.getNamedParameter("job-id");
                    logger.info((Object)String.format("cancel request from admin web for job %s", jobId));
                    Job job = this.jobsDb.getJob(jobId);
                    if (this.jobsDb.updateJobCancelled(job)) {
                        this.compTopic.sendMessage(commandMessage);
                        logger.info((Object)String.format("sending cancel for job %s to comps", jobId));
                        ResultMessage cancelMessage = new ResultMessage(job.getJobId(), JobState.CANCELLED, "cancelled by admin", null, null, null);
                        this.endpoint.sendMessageToClientReplyChannel(job.getReplyTo(), cancelMessage);
                    }
                } else if ("purge-old-jobs".equals(commandMessage.getCommand())) {
                    this.jobsDb.purgeOldJobs();
                } else if ("get-status-report".equals(commandMessage.getCommand())) {
                    CommandMessage reply = new CommandMessage();
                    String sysStats = SystemMonitorUtil.getMemInfo();
                    String report = "";
                    report = report + "JOBS\n\nwaiting: " + this.jobsDb.getWaitingJobs().size() + "\nrunning: " + this.jobsDb.getRunningJobs().size() + "\nall: " + this.jobsDb.getJobCount() + "\n\n";
                    report = report + "MEMORY\n\n";
                    report = report + sysStats + "\n";
                    reply.addNamedParameter("status-report", report);
                    this.endpoint.replyToMessage(commandMessage, reply);
                } else {
                    logger.warn((Object)("got unexpected command message: " + commandMessage.getCommand()));
                }
            } else {
                logger.warn((Object)("unexpected message: " + msg.toString()));
            }
        }
        catch (Exception e) {
            logger.error((Object)Exceptions.getStackTrace(e));
        }
    }

    private void handleListRunningJobs(CommandMessage commandMessage) throws JMSException {
        ArrayList<HashMap<String, Object>> jobs = new ArrayList<HashMap<String, Object>>();
        List<Job> runningJobs = this.jobsDb.getRunningJobs();
        for (Job job : runningJobs) {
            JobMessage jobMessage = job.getJobMessage();
            String host = job.getCompHost();
            if (host == null || "".equals(host)) {
                host = job.getCompId();
            }
            JobLogMessage jobLogMessage = new JobLogMessage(jobMessage.getToolId(), job.getState(), null, job.getJobId(), job.getCreated(), job.getFinished(), null, null, jobMessage.getUsername(), host);
            jobs.add(jobLogMessage.toMap());
        }
        String json = new Gson().toJson(jobs);
        JsonMessage reply = new JsonMessage(json);
        this.endpoint.replyToMessage(commandMessage, reply);
    }

    @Override
    public String getName() {
        return "jobmanager";
    }

    @Override
    public void shutdown() {
        logger.info((Object)"shutdown requested");
        try {
            this.endpoint.close();
        }
        catch (JMSException e) {
            logger.error((Object)"closing messaging endpoint failed", (Throwable)e);
        }
        logger.info((Object)"shutting down");
    }

    private class CompMessageListener
    implements MessagingListener {
        private CompMessageListener() {
        }

        @Override
        public void onChipsterMessage(ChipsterMessage msg) {
            try {
                if (msg instanceof ResultMessage) {
                    this.handleResultMessage((ResultMessage)msg);
                } else if (msg instanceof JobLogMessage) {
                    this.handleJobLogMessage((JobLogMessage)msg);
                } else if (msg instanceof CommandMessage) {
                    this.handleCompCommandMessage((CommandMessage)msg);
                } else {
                    logger.warn((Object)("got unexcepted message from comp: " + msg.toString()));
                }
            }
            catch (Exception e) {
                logger.error((Object)Exceptions.getStackTrace(e));
            }
        }

        private void handleCompCommandMessage(CommandMessage msg) throws JMSException {
            if ("offer".equals(msg.getCommand())) {
                String jobId = msg.getNamedParameter("job-id");
                String compId = msg.getNamedParameter("as-id");
                String compHost = msg.getNamedParameter("host");
                if (jobId == null || jobId.isEmpty() || compId == null || compId.isEmpty()) {
                    logger.warn((Object)String.format("invalid offer, jobId: %s, compId: %s", jobId, compId));
                    return;
                }
                Job job = JobManager.this.jobsDb.getJob(jobId);
                if (job == null) {
                    logger.warn((Object)("offer for non-existent job " + jobId));
                    return;
                }
                boolean scheduleJob = false;
                if (job.getState() == JobState.WAITING) {
                    scheduleJob = true;
                }
                if (scheduleJob) {
                    logger.info((Object)("scheduling job " + jobId));
                    CommandMessage acceptMessage = new CommandMessage("choose");
                    acceptMessage.addNamedParameter("job-id", jobId);
                    acceptMessage.addNamedParameter("as-id", compId);
                    acceptMessage.setUsername(job.getJobMessage().getUsername());
                    acceptMessage.setReplyTo((Destination)JobManager.this.jobManagerTopic.getJMSTopic());
                    JobManager.this.compTopic.sendMessage(acceptMessage);
                    JobManager.this.jobsDb.updateJobScheduled(job, compId, compHost);
                }
            } else if ("comp-available".equals(msg.getCommand())) {
                JobManager.this.scheduleWaitingJobs();
            } else {
                try {
                    String jobId = msg.getNamedParameter("job-id");
                    Destination destination = JobManager.this.jobsDb.getJob(jobId).getReplyTo();
                    logger.warn((Object)("sending command message to original replyTo: " + destination));
                    JobManager.this.endpoint.sendMessageToClientReplyChannel(destination, msg);
                }
                catch (Exception e) {
                    logger.warn((Object)("failed to forward command message to client " + msg.getCommand()));
                }
            }
        }

        private void handleJobLogMessage(JobLogMessage msg) {
            JobManager.this.jobsDb.updateJobRunning(JobManager.this.jobsDb.getJob(msg.getJobId()));
        }

        private void handleResultMessage(ResultMessage msg) throws JMSException {
            String jobId = msg.getJobId();
            Job job = JobManager.this.jobsDb.getJob(jobId);
            if (job == null) {
                logger.warn((Object)("no job found for result message with job id: " + jobId));
                return;
            }
            if (job.getFinished() != null) {
                logger.warn((Object)String.format("result message for already finished job %s, job state in jobmanager is %s, result message state is %s, comp id is ", new Object[]{jobId, job.getState(), msg.getState(), msg.getNamedParameter("as-id")}));
                return;
            }
            JobState jobStateFromComp = msg.getState();
            if (jobStateFromComp == JobState.COMPLETED || jobStateFromComp == JobState.FAILED || jobStateFromComp == JobState.FAILED_USER_ERROR || jobStateFromComp == JobState.ERROR || jobStateFromComp == JobState.TIMEOUT || jobStateFromComp == JobState.CANCELLED) {
                logger.info((Object)("job " + jobId + " finished with end state: " + (Object)((Object)jobStateFromComp)));
                if (!JobManager.this.jobsDb.updateJobFinished(job, jobStateFromComp, msg)) {
                    return;
                }
            } else if (jobStateFromComp == JobState.RUNNING) {
                if (!JobManager.this.jobsDb.updateJobRunning(job)) {
                    return;
                }
            } else {
                if (jobStateFromComp == JobState.NEW) {
                    return;
                }
                if (jobStateFromComp == JobState.COMP_BUSY) {
                    return;
                }
                logger.warn((Object)("job " + jobId + " in state " + (Object)((Object)jobStateFromComp) + ", sending result message to " + job.getReplyTo()));
            }
            JobManager.this.endpoint.sendMessageToClientReplyChannel(job.getReplyTo(), msg);
        }
    }

    private class ClientMessageListener
    implements MessagingListener {
        private ClientMessageListener() {
        }

        @Override
        public void onChipsterMessage(ChipsterMessage msg) {
            try {
                if (msg instanceof JobMessage) {
                    this.handleClientJobMessage((JobMessage)msg);
                } else if (msg instanceof CommandMessage) {
                    this.handleClientCommandMessage((CommandMessage)msg);
                } else {
                    logger.warn((Object)("sending " + msg.getClass() + " directly to comps, replyTo is unchanged"));
                    JobManager.this.compTopic.sendMessage(msg);
                }
            }
            catch (Exception e) {
                logger.error((Object)Exceptions.getStackTrace(e));
            }
        }

        private void handleClientJobMessage(JobMessage msg) throws JMSException {
            Destination clientReplyTo = msg.getReplyTo();
            if (JobManager.this.jobsDb.addJob(msg)) {
                msg.setReplyTo((Destination)JobManager.this.jobManagerTopic.getJMSTopic());
                if (JobManager.this.jobsDb.getWaitingJobs().size() <= 1) {
                    JobManager.this.compTopic.sendMessage(msg);
                }
            } else {
                ResultMessage resultMessage = new ResultMessage();
                resultMessage.setJobId(msg.getJobId());
                resultMessage.setState(JobState.ERROR);
                resultMessage.setErrorMessage("Could not submit job");
                JobManager.this.endpoint.sendMessageToClientReplyChannel(clientReplyTo, resultMessage);
            }
        }

        private void handleClientCommandMessage(CommandMessage msg) throws JMSException {
            if ("get-job".equals(msg.getCommand())) {
                Destination newClientReplyTo = msg.getReplyTo();
                String jobId = msg.getNamedParameter("job-id");
                Job job = JobManager.this.jobsDb.updateJobReplyTo(jobId, newClientReplyTo);
                ResultMessage resultMessage = null;
                if (job != null) {
                    if (job.getFinished() != null && job.getResults() != null) {
                        resultMessage = job.getResults();
                    } else if (job.getFinished() != null && job.getResults() == null) {
                        resultMessage = new ResultMessage();
                        resultMessage.setJobId(jobId);
                        resultMessage.setState(job.getState());
                    } else {
                        resultMessage = new ResultMessage();
                        resultMessage.setJobId(jobId);
                        resultMessage.setState(JobState.RUNNING);
                        resultMessage.setHeartbeat(false);
                    }
                } else {
                    resultMessage = new ResultMessage();
                    resultMessage.setJobId(jobId);
                    resultMessage.setState(JobState.ERROR);
                    resultMessage.setErrorMessage("job not found");
                    logger.warn((Object)("get job for non-existent job " + jobId));
                }
                JobManager.this.endpoint.sendMessageToClientReplyChannel(newClientReplyTo, resultMessage);
            } else if ("cancel".equals(msg.getCommand())) {
                String jobId = msg.getNamedParameter("job-id");
                if (JobManager.this.jobsDb.updateJobCancelled(JobManager.this.jobsDb.getJob(jobId))) {
                    JobManager.this.compTopic.sendMessage(msg);
                }
            } else {
                JobManager.this.compTopic.sendMessage(msg);
            }
        }
    }
}

