/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.util;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedHashMap;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class SocketFactoryCache {
    private static final int CACHE_SIZE = 100;
    private TrustManager[] trustManagers;
    private LinkedHashMap<Long, SSLSocketFactory> cache = new LinkedHashMap();
    private String protocol;

    public SocketFactoryCache(TrustManager[] trustManagers, String protocol) {
        this.trustManagers = trustManagers;
        this.protocol = protocol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSLSocketFactory getSocketFactoryForThisThread() throws NoSuchAlgorithmException, KeyManagementException {
        SocketFactoryCache socketFactoryCache = this;
        synchronized (socketFactoryCache) {
            Long thread = Thread.currentThread().getId();
            if (!this.cache.containsKey(thread)) {
                while (this.cache.size() > 99) {
                    this.removeLast(this.cache);
                }
                SSLContext ctx = SSLContext.getInstance(this.protocol);
                ctx.init(null, this.trustManagers, null);
                this.cache.put(thread, ctx.getSocketFactory());
            }
            return this.cache.get(thread);
        }
    }

    private void removeLast(LinkedHashMap<?, ?> map) {
        map.remove(map.keySet().toArray()[map.size() - 1]);
    }
}

