/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.auth;

import fi.csc.chipster.auth.model.Token;
import fi.csc.chipster.rest.CredentialsProvider;
import fi.csc.chipster.rest.DynamicCredentials;
import fi.csc.chipster.rest.exception.LocalDateTimeContextResolver;
import fi.csc.chipster.servicelocator.ServiceLocatorClient;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.hibernate.service.spi.ServiceException;

public class AuthenticationClient {
    private static Logger logger = LogManager.getLogger();
    private ServiceLocatorClient serviceLocator;
    private Token token;
    private String username;
    private String password;
    private List<String> authenticationServiceUris;
    private Timer tokenRefreshTimer;
    private Duration TOKEN_REFRESH_INTERVAL = Duration.of(1L, ChronoUnit.HOURS);
    private DynamicCredentials dynamicCredentials = new DynamicCredentials();

    public AuthenticationClient(ServiceLocatorClient serviceLocator, String username, String password) {
        this.serviceLocator = serviceLocator;
        this.construct(username, password);
    }

    public AuthenticationClient(String authUri, String username, String password) {
        this.authenticationServiceUris = Arrays.asList(authUri);
        this.construct(username, password);
    }

    public AuthenticationClient(List<String> auths, String username, String password) {
        this.authenticationServiceUris = auths;
        this.construct(username, password);
    }

    private void construct(String username, String password) {
        this.username = username;
        this.password = password;
        this.setToken(this.getTokenFromAuth());
        this.tokenRefreshTimer = new Timer("auth-client-token-refresh-timer", true);
        this.tokenRefreshTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    AuthenticationClient.this.refreshToken();
                }
                catch (Exception e) {
                    logger.warn("refresh token failed", (Throwable)e);
                }
            }
        }, this.TOKEN_REFRESH_INTERVAL.toMillis(), this.TOKEN_REFRESH_INTERVAL.toMillis());
    }

    private Token getTokenFromAuth() {
        List<String> auths = this.getAuths();
        if (auths.size() == 0) {
            throw new InternalServerErrorException("no auths registered to service locator");
        }
        Iterator<String> iterator = auths.iterator();
        if (iterator.hasNext()) {
            String authUri = iterator.next();
            Client authClient = AuthenticationClient.getClient(this.username, this.password, true);
            WebTarget authTarget = authClient.target(authUri);
            logger.info("get token from " + authUri);
            Token serverToken = (Token)authTarget.path("tokens").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)""), Token.class);
            return serverToken;
        }
        throw new RuntimeException("get token from auth failed");
    }

    private List<String> getAuths() {
        if (this.serviceLocator != null) {
            return this.serviceLocator.get("auth");
        }
        return this.authenticationServiceUris;
    }

    public static Client getClient(String username, String password, boolean enableAuth) {
        Client c = ClientBuilder.newClient();
        if (enableAuth) {
            HttpAuthenticationFeature feature = HttpAuthenticationFeature.basic((String)username, (String)password);
            c.register((Object)feature);
        }
        c.register(LocalDateTimeContextResolver.class);
        return c;
    }

    public static Client getClient() {
        return AuthenticationClient.getClient(null, null, false);
    }

    public Client getAuthenticatedClient() {
        return AuthenticationClient.getClient("token", this.token.getTokenKey().toString(), true);
    }

    public Token getDbToken(String tokenKey) {
        List<String> auths = this.getAuths();
        for (String authUri : auths) {
            try {
                Token dbToken = (Token)this.getAuthenticatedClient().target(authUri).path("tokens").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("chipster-token", (Object)tokenKey).get(Token.class);
                if (dbToken == null) continue;
                return dbToken;
            }
            catch (ServiceException e) {
                logger.warn("auth not available", (Throwable)e);
            }
            catch (NotFoundException e) {
                return null;
            }
        }
        return null;
    }

    public UUID getTokenKey() {
        return this.token.getTokenKey();
    }

    private void refreshToken() {
        for (String authUri : this.getAuths()) {
            try {
                Token serverToken = (Token)this.getAuthenticatedClient().target(authUri).path("tokens").path("refresh").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)""), Token.class);
                if (serverToken != null) {
                    this.setToken(serverToken);
                    if (serverToken.getValid().isBefore(LocalDateTime.now().plus(this.TOKEN_REFRESH_INTERVAL.multipliedBy(2L)))) {
                        logger.info("refreshed token expiring soon, getting a new one");
                        try {
                            this.setToken(this.getTokenFromAuth());
                        }
                        catch (Exception e) {
                            logger.warn("getting new token to replace soon expiring token failed", (Throwable)e);
                        }
                    }
                    return;
                }
                logger.warn("got null as response to refresh token");
            }
            catch (ForbiddenException fe) {
                logger.info("got forbidden when refreshing token, getting new one");
                try {
                    this.setToken(this.getTokenFromAuth());
                    return;
                }
                catch (Exception e) {
                    logger.warn("getting new token after forbidden failed", (Throwable)e);
                }
            }
            catch (ServiceException e) {
                logger.warn("auth not available", (Throwable)e);
            }
            catch (Exception e) {
                logger.warn("refresh token failed", (Throwable)e);
            }
        }
        logger.warn("refresh token failing");
    }

    private void setToken(Token token) {
        this.token = token;
        this.dynamicCredentials.setCredentials("token", this.token.getTokenKey().toString());
    }

    public CredentialsProvider getCredentials() {
        return this.dynamicCredentials;
    }
}

