/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.cli;

import fi.csc.chipster.auth.AuthenticationClient;
import fi.csc.chipster.filebroker.RestFileBrokerClient;
import fi.csc.chipster.rest.CredentialsProvider;
import fi.csc.chipster.rest.RestUtils;
import fi.csc.chipster.servicelocator.resource.Service;
import fi.csc.chipster.sessiondb.RestException;
import fi.csc.chipster.sessiondb.SessionDbClient;
import fi.csc.chipster.sessiondb.model.Dataset;
import fi.csc.chipster.sessiondb.model.Input;
import fi.csc.chipster.sessiondb.model.Job;
import fi.csc.chipster.sessiondb.model.Parameter;
import fi.csc.chipster.sessiondb.model.Session;
import fi.csc.chipster.toolbox.ToolboxClientRest;
import fi.csc.chipster.toolbox.ToolboxTool;
import fi.csc.microarray.description.SADLDescription;
import fi.csc.microarray.messaging.JobState;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.UUID;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;

public class RestCliClient {
    private static final String ARG_DIR = "DIR";
    private static final String ARG_FILE = "FILE";
    private static final String ARG_FILTER = "FILTER";
    private static final String ARG_VALUE = "VALUE";
    private static final String ARG_DETAIL = "DETAIL";
    private static final String ARG_SESSION = "SESSION";
    private static final String ARG_DATASET = "DATASET";
    private static final String ARG_TOOL = "TOOL";
    private static final String ARG_HOST = "HOST";
    private static final String OPT_QUIET = "quiet";
    private static final String OPT_VERBOSE = "verbose";
    private static final String OPT_PASSWORD = "password";
    private static final String OPT_USERNAME = "username";
    private static final String CMD_RUN = "run";
    private static final String CMD_IMPORT = "import";
    private static final String CMD_EXPORT = "export";
    private static final String CMD_PARAMETER = "parameter";
    private static final String CMD_NOTES = "notes";
    private static final String CMD_NAME = "name";
    private static final String CMD_DOWNLOAD = "download";
    private static final String CMD_DETAILS = "details";
    private static final String CMD_PRINT = "print";
    private static final String CMD_SET = "set";
    private static final String CMD_UPLOAD = "upload";
    private static final String CMD_DELETE = "delete";
    private static final String CMD_LIST = "list";
    private static final String CMD_CREATE = "create";
    private static final String CMD_DATASET = "dataset";
    private static final String CMD_JOB = "job";
    private static final String CMD_TOOL = "tool";
    private static final String SESSION = "session";
    private static final String SUBSUBCOMMAND = "subsubcommand";
    private static final String SUBCOMMAND = "subcommand";
    private static Long t;
    private CredentialsProvider credentials;
    private Boolean verbose = false;
    private Boolean quiet = false;
    private SessionDbClient sessionDbClient;
    private ToolboxClientRest toolboxClient;
    private RestFileBrokerClient fileBrokerClient;
    private HashMap<String, Service> services;

    public static void main(String[] args) throws IOException {
        RestCliClient.time("");
        new RestCliClient(args);
    }

    private static void time(String string) {
        if (t != null) {
            // empty if block
        }
        t = System.currentTimeMillis();
    }

    public RestCliClient(String[] args) throws IOException {
        ArgumentParser parser = this.getArgumentParser();
        try {
            Namespace namespace = parser.parseArgs(args);
            RestCliClient.time("parse");
            this.execute(namespace);
        }
        catch (ArgumentParserException e) {
            parser.handleError(e);
            if (this.verbose.booleanValue()) {
                e.printStackTrace();
            }
            System.exit(1);
        }
        catch (RestException | IllegalArgumentException | WebApplicationException e) {
            System.err.println("Request failed: " + e.getMessage());
            if (this.verbose.booleanValue()) {
                e.printStackTrace();
            }
            System.exit(1);
        }
        catch (FileNotFoundException e) {
            System.err.println("File not found: " + e.getMessage());
            if (this.verbose.booleanValue()) {
                e.printStackTrace();
            }
            System.exit(1);
        }
    }

    private ArgumentParser getArgumentParser() {
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)"chipster-cli");
        parser.addArgument(new String[]{ARG_HOST}).help("hostname or IP address of the Chipster server and [:PORT]");
        parser.addArgument(new String[]{"-u", "--username"}).action((ArgumentAction)Arguments.store()).help(OPT_USERNAME);
        parser.addArgument(new String[]{"-p", "--password"}).action((ArgumentAction)Arguments.store()).help(OPT_PASSWORD);
        parser.addArgument(new String[]{"-s", "--session"}).action((ArgumentAction)Arguments.store()).help("session name or ID to work on");
        parser.addArgument(new String[]{"-v", "--verbose"}).action((ArgumentAction)Arguments.storeTrue()).help("more verbose output");
        parser.addArgument(new String[]{"-q", "--quiet"}).action((ArgumentAction)Arguments.storeTrue()).help("quieter output");
        Subparsers subparsers = parser.addSubparsers().title("subcommands").metavar("COMMAND").dest(SUBCOMMAND);
        Subparsers sessionSubparsers = subparsers.addParser(SESSION).help("manage sessions").addSubparsers().title("session subcommands").metavar("COMMAND").dest(SUBSUBCOMMAND);
        Subparsers toolSubparsers = subparsers.addParser(CMD_TOOL).help("get information about tools").addSubparsers().title("tool subcommands").metavar("COMMAND").dest(SUBSUBCOMMAND);
        Subparsers jobSubparsers = subparsers.addParser(CMD_JOB).help("run and follow jobs").addSubparsers().title("job subcommands").metavar("COMMAND").dest(SUBSUBCOMMAND);
        Subparsers datasetSubparsers = subparsers.addParser(CMD_DATASET).help("manage datasets").addSubparsers().title("dataset subcommands").metavar("COMMAND").dest(SUBSUBCOMMAND);
        Subparser sessionCreateParser = sessionSubparsers.addParser(CMD_CREATE).help("create new session");
        sessionCreateParser.addArgument(new String[]{ARG_SESSION}).help("name of the session to be created");
        sessionSubparsers.addParser(CMD_LIST).help("list sessions");
        sessionSubparsers.addParser(CMD_DETAILS).help("view session details");
        sessionSubparsers.addParser(CMD_DELETE).help("delete session");
        Subparser sessionExportParser = sessionSubparsers.addParser(CMD_EXPORT).help("copy the whole session to a local directory");
        sessionExportParser.addArgument(new String[]{ARG_DIR});
        Subparser sessionImportParser = sessionSubparsers.addParser(CMD_IMPORT).help("import a session from the local directory");
        sessionImportParser.addArgument(new String[]{ARG_DIR});
        sessionImportParser.addArgument(new String[]{CMD_NAME}).nargs("?").help("rename the imported session");
        datasetSubparsers.addParser(CMD_LIST).help("list all datasets in the session");
        Subparser datasetUploadParser = datasetSubparsers.addParser(CMD_UPLOAD).help("upload a dataset");
        datasetUploadParser.addArgument(new String[]{ARG_FILE}).help("file to upload or - to read from the standard in");
        datasetUploadParser.addArgument(new String[]{CMD_NAME}).nargs("?").help("name for the uploaded dataset");
        Subparser datasetDownlaodParser = datasetSubparsers.addParser(CMD_DOWNLOAD).help("download a dataset");
        datasetDownlaodParser.addArgument(new String[]{ARG_DATASET}).help("dataset to download");
        datasetDownlaodParser.addArgument(new String[]{ARG_FILE}).nargs("?").help("destination file (dataset name by default)");
        Subparser datasetSetParser = datasetSubparsers.addParser(CMD_SET).help("edit dataset details");
        datasetSetParser.addArgument(new String[]{ARG_DATASET});
        datasetSetParser.addArgument(new String[]{ARG_DETAIL}).choices((Object[])new String[]{CMD_NAME, CMD_NOTES});
        datasetSetParser.addArgument(new String[]{ARG_VALUE});
        Subparser datasetPrintParser = datasetSubparsers.addParser(CMD_PRINT).help("print the dataset contents to the standard output");
        datasetPrintParser.addArgument(new String[]{ARG_DATASET});
        Subparser datasetDetailsParser = datasetSubparsers.addParser(CMD_DETAILS).help("view dataset details");
        datasetDetailsParser.addArgument(new String[]{ARG_DATASET});
        datasetSubparsers.addParser(CMD_DELETE).help("delete dataset");
        Subparser toolListParser = toolSubparsers.addParser(CMD_LIST).help("list tools");
        toolListParser.addArgument(new String[]{ARG_FILTER}).nargs("?").help("list only tools that have this string in its name");
        Subparser toolDetailsParser = toolSubparsers.addParser(CMD_DETAILS).help("view tool details");
        toolDetailsParser.addArgument(new String[]{ARG_TOOL});
        jobSubparsers.addParser(CMD_LIST).help("list jobs");
        Subparser jobDetailsParser = jobSubparsers.addParser(CMD_DETAILS).help("view job details");
        jobDetailsParser.addArgument(new String[]{CMD_JOB}).help("view job details");
        Subparser jobRunParser = jobSubparsers.addParser(CMD_RUN).help("start new job");
        jobRunParser.addArgument(new String[]{ARG_TOOL}).help("tool to run");
        jobRunParser.addArgument(new String[]{"-D", "--dataset"}).nargs("*").action((ArgumentAction)Arguments.append()).help("input datasets");
        jobRunParser.addArgument(new String[]{"-P", "--parameter"}).nargs(2).metavar(new String[]{"PARAMETER", ARG_VALUE}).action((ArgumentAction)Arguments.append()).help("parameter name and value");
        return parser;
    }

    private void execute(Namespace namespace) throws RestException, IOException {
        String subcommand;
        this.verbose = namespace.getBoolean(OPT_VERBOSE);
        this.quiet = namespace.getBoolean(OPT_QUIET);
        String webUri = "http://" + namespace.getString(ARG_HOST);
        String serviceLocatorUri = this.getServiceLocatorUri(webUri);
        this.services = this.getServices(serviceLocatorUri);
        String username = namespace.getString(OPT_USERNAME);
        String password = namespace.getString(OPT_PASSWORD);
        if (username != null || password != null) {
            String authURI = this.getAuthUri();
            this.verbose("authenticating to " + authURI);
            this.credentials = new AuthenticationClient(authURI, username, password).getCredentials();
            RestCliClient.time("authenticate");
        }
        switch (subcommand = namespace.getString(SUBCOMMAND)) {
            case "session": {
                this.executeSessionSubcommand(namespace);
                break;
            }
            case "tool": {
                this.executeToolSubcommand(namespace);
                break;
            }
            case "job": {
                this.executeJobSubcommand(namespace);
                break;
            }
            case "dataset": {
                this.executeDatasetSubcommand(namespace);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown subcommand: " + subcommand);
            }
        }
    }

    private HashMap<String, Service> getServices(String serviceLocatorUri) {
        WebTarget serviceTarget = ClientBuilder.newClient().target(serviceLocatorUri).path("services");
        String serviceJson = (String)serviceTarget.request(new String[]{"application/json"}).get(String.class);
        List serviceList = RestUtils.parseJson(List.class, Service.class, serviceJson);
        HashMap<String, Service> services = new HashMap<String, Service>();
        for (Service service : serviceList) {
            services.put(service.getRole(), service);
        }
        return services;
    }

    private String getServiceLocatorUri(String webUri) {
        WebTarget configTarget = ClientBuilder.newClient().target(webUri).path("js/json/config.json");
        String configJson = (String)configTarget.request(new String[]{"application/json"}).get(String.class);
        HashMap configMap = RestUtils.parseJson(HashMap.class, configJson);
        return (String)configMap.get("serviceLocator");
    }

    private String getAuthUri() {
        return this.services.get("authentication-service").getPublicUri();
    }

    private String getSessionDbUri() {
        return this.services.get("session-db").getPublicUri();
    }

    private String getSessionDbEventsUri() {
        return this.services.get("session-db-events").getPublicUri();
    }

    private String getToolboxUri() {
        return this.services.get("toolbox").getPublicUri();
    }

    private String getFileBrokerUri() {
        return this.services.get("file-broker").getPublicUri();
    }

    private void verbose(String msg) {
        if (this.verbose.booleanValue()) {
            System.out.println(msg);
        }
    }

    private void executeDatasetSubcommand(Namespace namespace) throws RestException, IOException {
        String subcommand;
        switch (subcommand = namespace.getString(SUBSUBCOMMAND)) {
            case "list": {
                this.datasetList(namespace);
                break;
            }
            case "upload": {
                this.datasetUpload(namespace);
                break;
            }
            case "set": {
                this.datasetSet(namespace);
                break;
            }
            case "details": {
                this.datasetDetails(namespace);
                break;
            }
            case "print": {
                this.datasetPrint(namespace);
                break;
            }
            case "delete": {
                this.datasetDelete(namespace);
                break;
            }
            case "download": {
                this.datasetDownload(namespace);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown subcommand: " + subcommand);
            }
        }
    }

    private void executeJobSubcommand(Namespace namespace) throws RestException {
        String subcommand;
        switch (subcommand = namespace.getString(SUBSUBCOMMAND)) {
            case "list": {
                this.jobList(namespace);
                break;
            }
            case "details": {
                this.jobDetais(namespace);
                break;
            }
            case "run": {
                this.jobRun(namespace);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown subcommand: " + subcommand);
            }
        }
    }

    private void executeToolSubcommand(Namespace namespace) {
        String subcommand;
        switch (subcommand = namespace.getString(SUBSUBCOMMAND)) {
            case "list": {
                this.toolList(namespace);
                break;
            }
            case "details": {
                this.toolDetails(namespace);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown subcommand: " + subcommand);
            }
        }
    }

    private void executeSessionSubcommand(Namespace namespace) throws RestException, IOException {
        String subcommand;
        switch (subcommand = namespace.getString(SUBSUBCOMMAND)) {
            case "create": {
                this.sessionCreate(namespace);
                break;
            }
            case "list": {
                this.sessionList(namespace);
                break;
            }
            case "details": {
                this.sessionDetails(namespace);
                break;
            }
            case "delete": {
                this.sessionDelete(namespace);
                break;
            }
            case "export": {
                this.sessionExport(namespace);
                break;
            }
            case "import": {
                this.sessionImport(namespace);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown subcommand: " + subcommand);
            }
        }
    }

    private void datasetDownload(Namespace namespace) throws RestException, IOException {
        Dataset dataset = this.getDataset(namespace);
        String filePath = namespace.getString(ARG_FILE);
        if (filePath == null) {
            filePath = dataset.getName();
        }
        File destFile = new File(filePath);
        this.getFileBrokerClient().download(this.getSessionId(namespace), dataset.getDatasetId(), destFile);
    }

    private void datasetDelete(Namespace namespace) throws RestException {
        Dataset dataset = this.getDataset(namespace);
        this.getSessionDbClient().deleteDataset(this.getSessionId(namespace), dataset.getDatasetId());
    }

    private void datasetPrint(Namespace namespace) throws IOException, RestException {
        Dataset dataset = this.getDataset(namespace);
        try (InputStream inStream = this.getFileBrokerClient().download(this.getSessionId(namespace), dataset.getDatasetId());){
            IOUtils.copy((InputStream)inStream, (OutputStream)System.out);
        }
    }

    private void datasetDetails(Namespace namespace) throws RestException {
        Dataset dataset = this.getDataset(namespace);
        this.printKeyValue(CMD_NAME, dataset.getName());
        this.printKeyValue(CMD_NOTES, dataset.getNotes());
        this.printKeyValue("dataset ID", dataset.getDatasetId());
        if (dataset.getFile() != null) {
            this.printKeyValue("size", dataset.getFile().getSize());
            this.printKeyValue("checksum", dataset.getFile().getChecksum());
        }
        if (dataset.getSourceJob() != null) {
            Job job = this.getSessionDbClient().getJob(this.getSessionId(namespace), dataset.getSourceJob());
            this.printKeyValue("source tool", job.getToolId());
            this.printKeyValue("source job ID", job.getJobId().toString());
        }
    }

    private void datasetSet(Namespace namespace) throws RestException {
        Dataset dataset = this.getDataset(namespace);
        String value = namespace.getString(ARG_VALUE);
        switch (namespace.getString(ARG_DETAIL)) {
            case "name": {
                dataset.setName(value);
                break;
            }
            case "notes": {
                dataset.setNotes(value);
            }
        }
        this.getSessionDbClient().updateDataset(this.getSessionId(namespace), dataset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void datasetUpload(Namespace namespace) throws RestException, FileNotFoundException {
        String filePath = namespace.getString(ARG_FILE);
        String name = namespace.getString(CMD_NAME);
        if (name == null) {
            name = "-".equals(filePath) ? CMD_UPLOAD : filePath;
        }
        InputStream inStream = "-".equals(filePath) ? System.in : new FileInputStream(filePath);
        try {
            Dataset dataset = new Dataset();
            dataset.setName(name);
            this.getSessionDbClient().createDataset(this.getSessionId(namespace), dataset);
            this.getFileBrokerClient().upload(this.getSessionId(namespace), dataset.getDatasetId(), inStream);
        }
        finally {
            IOUtils.closeQuietly((Closeable)inStream);
        }
    }

    private void datasetList(Namespace namespace) throws RestException {
        HashMap<UUID, Dataset> datasets = this.getSessionDbClient().getDatasets(this.getSessionId(namespace));
        RestCliClient.time("list datasets");
        for (Dataset dataset : datasets.values()) {
            this.printFixed(dataset.getDatasetId().toString(), 36);
            this.printFixed(dataset.getName(), 40);
            System.out.println();
        }
    }

    private void jobRun(Namespace namespace) throws RestException {
        Dataset dataset;
        Input jobInput;
        ToolboxTool tool = this.getToolboxClient().getTool(namespace.getString(ARG_TOOL));
        ArrayList<Dataset> datasets = new ArrayList<Dataset>();
        HashMap parameters = new HashMap();
        if (namespace.getList(CMD_DATASET) != null) {
            for (Object innerList : namespace.getList(CMD_DATASET)) {
                for (Object dataset2 : (List)innerList) {
                    datasets.add(this.getDataset("" + dataset2, namespace));
                }
            }
        }
        if (namespace.getList(CMD_PARAMETER) != null) {
            for (Iterator paramObj : namespace.getList(CMD_PARAMETER)) {
                List paramList = (List)((Object)paramObj);
                parameters.put(paramList.get(0), paramList.get(1));
            }
        }
        LinkedHashSet<Input> jobInputs = new LinkedHashSet<Input>();
        for (Object toolInput : tool.getSadlDescription().getInputs()) {
            if (toolInput.isOptional()) continue;
            if (datasets.isEmpty()) {
                throw new IllegalArgumentException("not enough input datasets for input " + toolInput.getName().getID());
            }
            jobInput = new Input();
            dataset = (Dataset)datasets.remove(0);
            jobInput.setDatasetId(dataset.getDatasetId().toString());
            jobInput.setInputId(toolInput.getName().getID());
            jobInput.setDisplayName(dataset.getName());
            jobInputs.add(jobInput);
        }
        for (Object toolInput : tool.getSadlDescription().getInputs()) {
            if (!toolInput.isOptional()) continue;
            if (datasets.isEmpty()) break;
            jobInput = new Input();
            dataset = (Dataset)datasets.remove(0);
            jobInput.setDatasetId(dataset.getDatasetId().toString());
            jobInput.setInputId(toolInput.getName().getID());
            jobInput.setDisplayName(dataset.getName());
            jobInputs.add(jobInput);
        }
        LinkedHashSet<Parameter> jobParameters = new LinkedHashSet<Parameter>();
        for (SADLDescription.Parameter toolParameter : tool.getSadlDescription().getParameters()) {
            Parameter jobParameter = new Parameter();
            String id = toolParameter.getName().getID();
            jobParameter.setParameterId(id);
            if (parameters.containsKey(id)) {
                jobParameter.setValue((String)parameters.get(id));
            } else {
                jobParameter.setValue(toolParameter.getDefaultValue());
            }
            jobParameters.add(jobParameter);
        }
        Job job = new Job();
        job.setParameters(jobParameters);
        job.setInputs(jobInputs);
        job.setToolId(tool.getSadlDescription().getName().getID());
        job.setState(JobState.NEW);
        job.setToolName(tool.getSadlDescription().getName().getDisplayName());
        this.getSessionDbClient().createJob(this.getSessionId(namespace), job);
    }

    private void jobDetais(Namespace namespace) throws RestException {
        Job job = this.getJob(namespace.getString(CMD_JOB), namespace);
        this.printKeyValue("module", job.getModule());
        this.printKeyValue("category", job.getToolCategory());
        this.printKeyValue("tool ID", job.getToolId());
        this.printKeyValue("tool name", job.getToolName());
        this.printKeyValue("description", job.getToolDescription());
        this.printKeyValue("state", job.getState());
        this.printKeyValue("state detail", job.getStateDetail());
        this.printKeyValue("start time", job.getStartTime());
        this.printKeyValue("end time", job.getEndTime());
        this.printKeyValue("job ID", job.getJobId());
        if (this.verbose.booleanValue()) {
            if (job.getScreenOutput() != null) {
                this.printKeyValue("screen output", "");
                System.out.println(job.getScreenOutput());
            } else {
                this.printKeyValue("source code", "");
                System.out.println(job.getSourceCode());
            }
        }
        this.printKeyValue("parameters", "");
        for (Parameter param : job.getParameters()) {
            this.printKeyValue("  " + param.getParameterId(), param.getValue());
            if (!this.verbose.booleanValue()) continue;
            this.printKeyValue("", param.getDescription());
        }
        this.printKeyValue("input datasets", "");
        for (Input input : job.getInputs()) {
            if (input.getDatasetId() != null) {
                Dataset dataset = this.getSessionDbClient().getDataset(this.getSessionId(namespace), UUID.fromString(input.getDatasetId()));
                this.printKeyValue("  " + input.getInputId(), dataset.getName());
            } else {
                this.printKeyValue("  " + input.getInputId(), "");
            }
            if (!this.verbose.booleanValue() || input.getDescription() == null) continue;
            this.printKeyValue("", input.getDescription());
        }
    }

    private void jobList(Namespace namespace) throws RestException {
        HashMap<UUID, Job> jobs = this.getSessionDbClient().getJobs(this.getSessionId(namespace));
        for (Job job : jobs.values()) {
            if (!this.verbose.booleanValue() && (job.getState() == JobState.COMPLETED || job.getState() == JobState.CANCELLED || job.getState() == JobState.ERROR || job.getState() == JobState.FAILED || job.getState() == JobState.FAILED_USER_ERROR)) continue;
            this.printFixed("" + job.getJobId(), 36);
            this.printFixed("" + job.getToolId(), 30);
            this.printFixed("" + job.getState(), 24);
            this.printFixed("" + job.getStateDetail(), 24);
            System.out.println();
        }
    }

    private UUID getSessionId(Namespace namespace) throws RestException {
        return this.getSession(namespace).getSessionId();
    }

    private void toolDetails(Namespace namespace) {
        ToolboxTool tool = this.getToolboxClient().getTool(namespace.getString(ARG_TOOL));
        this.printKeyValue("module", tool.getModule());
        this.printKeyValue("tool ID", tool.getSadlDescription().getName().getID());
        this.printKeyValue(CMD_NAME, tool.getSadlDescription().getName().getDisplayName());
        this.printKeyValue("description", tool.getSadlDescription().getDescription());
        this.printKeyValue("parameters", "");
        for (SADLDescription.Parameter param : tool.getSadlDescription().getParameters()) {
            this.printKeyValue("  parameter ID", param.getName().getID());
            this.printKeyValue("  name", param.getName().getDisplayName());
            this.printKeyValue("  description", param.getDescription());
            this.printKeyValue("  type", param.getType());
            this.printKeyValue("  default value", param.getDefaultValue());
            if (param.getSelectionOptions() != null) {
                this.printKeyValue("  options", "");
                for (SADLDescription.Name option : param.getSelectionOptions()) {
                    this.printFixed("    " + option.getID(), 40);
                    this.printFixed(option.getDisplayName(), 30);
                    System.out.println();
                }
            }
            if (param.getFrom() != null) {
                this.printKeyValue("  min", param.getFrom());
            }
            if (param.getTo() != null) {
                this.printKeyValue("  max", param.getTo());
            }
            System.out.println();
        }
        this.printKeyValue("input datasets", "");
        for (SADLDescription.Input input : tool.getSadlDescription().getInputs()) {
            this.printFixed("  " + input.getName().getID(), 30);
            this.printFixed(input.getName().getDisplayName(), 30);
            this.printFixed(input.getType().getName(), 10);
            this.printFixed(input.isOptional() ? "optional" : "", 10);
            if (this.verbose.booleanValue()) {
                this.printKeyValue("  description", input.getDescription());
            }
            System.out.println();
        }
        this.printKeyValue("output datasets", "");
        for (SADLDescription.Output output : tool.getSadlDescription().getOutputs()) {
            this.printFixed("  " + output.getName().getDisplayName(), 30);
            this.printFixed(output.isOptional() ? "optional" : "", 10);
            System.out.println();
        }
        if (this.verbose.booleanValue()) {
            this.printKeyValue("source", "");
            System.out.println(tool.getSource());
        }
    }

    private void toolList(Namespace namespace) {
        String filter = namespace.getString(ARG_FILTER);
        HashMap<String, SADLDescription> tools = this.getToolboxClient().getTools();
        for (SADLDescription tool : tools.values()) {
            if (filter != null && (!tool.getName().getID().toLowerCase().contains(filter.toLowerCase()) || !tool.getName().getDisplayName().toLowerCase().contains(filter.toLowerCase()))) continue;
            this.printFixed(tool.getName().getID(), 40);
            this.printFixed(tool.getName().getDisplayName(), 40);
            System.out.println();
        }
    }

    private void sessionDelete(Namespace namespace) throws RestException {
        Session session = this.getSession(namespace);
        this.getSessionDbClient().deleteSession(session.getSessionId());
    }

    private void sessionDetails(Namespace namespace) throws RestException {
        Session session = this.getSession(namespace);
        this.printKeyValue(CMD_NAME, session.getName());
        this.printKeyValue("created", session.getCreated());
        this.printKeyValue("accessed", session.getAccessed());
        this.printKeyValue("session ID", session.getSessionId());
        this.printKeyValue(CMD_NOTES, session.getNotes());
    }

    private Dataset getDataset(Namespace namespace) throws RestException {
        String str = namespace.getString(ARG_DATASET);
        return this.getDataset(str, namespace);
    }

    private Dataset getDataset(String str, Namespace namespace) throws RestException {
        if (str != null) {
            HashMap<UUID, Dataset> datasets = this.getSessionDbClient().getDatasets(this.getSessionId(namespace));
            RestCliClient.time("list datasets");
            for (Dataset dataset : datasets.values()) {
                if (!str.equals(dataset.getName())) continue;
                return dataset;
            }
            for (UUID uuid : datasets.keySet()) {
                if (!uuid.toString().startsWith(str)) continue;
                return datasets.get(uuid);
            }
        }
        throw new IllegalArgumentException("dataset not found");
    }

    private Job getJob(String str, Namespace namespace) throws RestException {
        if (str != null) {
            HashMap<UUID, Job> jobs = this.getSessionDbClient().getJobs(this.getSessionId(namespace));
            RestCliClient.time("list datasets");
            for (Job job : jobs.values()) {
                if (!str.equals(job.getToolName())) continue;
                return job;
            }
            for (UUID uuid : jobs.keySet()) {
                if (!uuid.toString().startsWith(str)) continue;
                return jobs.get(uuid);
            }
        }
        throw new IllegalArgumentException("job not found");
    }

    private Session getSession(Namespace namespace) throws RestException {
        String str = namespace.getString(SESSION);
        if (str != null) {
            HashMap<UUID, Session> sessions = this.getSessionDbClient().getSessions();
            RestCliClient.time("list sessions");
            for (Session session : sessions.values()) {
                if (!str.equals(session.getName())) continue;
                return session;
            }
            for (UUID uuid : sessions.keySet()) {
                if (!uuid.toString().startsWith(str)) continue;
                return sessions.get(uuid);
            }
        }
        throw new IllegalArgumentException("session not found");
    }

    private void sessionList(Namespace namespace) throws RestException {
        SessionDbClient sessionDb = this.getSessionDbClient();
        for (Session session : sessionDb.getSessions().values()) {
            if (this.quiet.booleanValue()) {
                System.out.println(session.getName());
                continue;
            }
            this.printFixed("" + session.getSessionId(), 36);
            this.printFixed(session.getName(), 30);
            this.printFixed("" + session.getCreated(), 24);
            this.printFixed("" + session.getAccessed(), 24);
            System.out.println();
        }
    }

    private void sessionCreate(Namespace namespace) throws RestException {
        Session session = new Session();
        session.setName(namespace.getString(ARG_SESSION));
        this.getSessionDbClient().createSession(session);
    }

    private void sessionExport(Namespace namespace) throws RestException, IOException {
        File dir = new File(namespace.getString(ARG_DIR));
        File jobLinks = new File(dir, "jobs");
        File datasetLinks = new File(dir, "datasets");
        File fileLinks = new File(dir, "files");
        File jobs = new File(jobLinks, "UUID");
        File datasets = new File(datasetLinks, "UUID");
        File files = new File(fileLinks, "UUID");
        dir.mkdirs();
        jobs.mkdirs();
        datasets.mkdirs();
        files.mkdirs();
        Session session = this.getSessionDbClient().getSession(this.getSessionId(namespace));
        FileUtils.writeStringToFile((File)new File(dir, "session.json"), (String)RestUtils.asJson(session));
        for (Dataset dataset : session.getDatasets().values()) {
            this.verbose(dataset.getName());
            FileUtils.writeStringToFile((File)new File(datasets, dataset.getDatasetId().toString()), (String)RestUtils.asJson(dataset));
            this.getFileBrokerClient().download(this.getSessionId(namespace), dataset.getDatasetId(), new File(files, dataset.getDatasetId().toString()));
            Files.createSymbolicLink(this.getUniqueFile(datasetLinks, dataset.getName()).toPath(), new File("UUID", dataset.getDatasetId().toString()).toPath(), new FileAttribute[0]);
            Files.createSymbolicLink(this.getUniqueFile(fileLinks, dataset.getName()).toPath(), new File("UUID", dataset.getDatasetId().toString()).toPath(), new FileAttribute[0]);
        }
        for (Job job : session.getJobs().values()) {
            FileUtils.writeStringToFile((File)new File(jobs, job.getJobId().toString()), (String)RestUtils.asJson(job));
            Files.createSymbolicLink(this.getUniqueFile(jobLinks, job.getToolId()).toPath(), new File("UUID", job.getJobId().toString()).toPath(), new FileAttribute[0]);
        }
    }

    private void sessionImport(Namespace namespace) throws RestException, IOException {
        Job job;
        UUID newId;
        UUID oldId;
        Dataset dataset;
        String name = namespace.getString(CMD_NAME);
        File dir = new File(namespace.getString(ARG_DIR));
        File jobLinks = new File(dir, "jobs");
        File datasetLinks = new File(dir, "datasets");
        File fileLinks = new File(dir, "files");
        File jobs = new File(jobLinks, "UUID");
        File datasets = new File(datasetLinks, "UUID");
        File files = new File(fileLinks, "UUID");
        Session session = RestUtils.parseJson(Session.class, FileUtils.readFileToString((File)new File(dir, "session.json")));
        if (name != null) {
            session.setName(name);
        }
        session.setSessionId(null);
        UUID sessionId = this.getSessionDbClient().createSession(session);
        HashMap<UUID, UUID> datasetIds = new HashMap<UUID, UUID>();
        HashMap<UUID, UUID> jobIds = new HashMap<UUID, UUID>();
        for (File file : this.getUUIDFiles(datasets)) {
            dataset = RestUtils.parseJson(Dataset.class, FileUtils.readFileToString((File)file));
            this.verbose(dataset.getName());
            oldId = dataset.getDatasetId();
            dataset.setDatasetId(null);
            dataset.setFile(null);
            newId = this.getSessionDbClient().createDataset(sessionId, dataset);
            this.getFileBrokerClient().upload(sessionId, dataset.getDatasetId(), new File(files, file.getName()));
            datasetIds.put(oldId, newId);
        }
        for (File file : this.getUUIDFiles(jobs)) {
            job = RestUtils.parseJson(Job.class, FileUtils.readFileToString((File)file));
            oldId = job.getJobId();
            job.setJobId(null);
            newId = this.getSessionDbClient().createJob(sessionId, job);
            jobIds.put(oldId, newId);
        }
        for (UUID newDatasetId : datasetIds.values()) {
            dataset = this.getSessionDbClient().getDataset(sessionId, newDatasetId);
            UUID newJobId = (UUID)jobIds.get(dataset.getSourceJob());
            dataset.setSourceJob(newJobId);
            this.getSessionDbClient().updateDataset(sessionId, dataset);
        }
        for (UUID newJobId : jobIds.values()) {
            job = this.getSessionDbClient().getJob(sessionId, newJobId);
            for (Input input : job.getInputs()) {
                UUID oldDatasetId = UUID.fromString(input.getDatasetId());
                UUID newDatasetId = (UUID)datasetIds.get(oldDatasetId);
                input.setDatasetId(newDatasetId.toString());
            }
            this.getSessionDbClient().updateJob(sessionId, job);
        }
    }

    private File getUniqueFile(File dir, String name) {
        String basename = FilenameUtils.getBaseName((String)name);
        String extension = name.substring(basename.length());
        int i = 2;
        while (new File(dir, name).exists()) {
            name = basename + "-" + i + extension;
            ++i;
        }
        return new File(dir, name);
    }

    private List<File> getUUIDFiles(File dir) {
        ArrayList<File> files = new ArrayList<File>();
        for (File file : dir.listFiles()) {
            try {
                UUID.fromString(file.getName());
                files.add(file);
            }
            catch (IllegalArgumentException e) {
                System.err.println("skpping file " + file.getName());
            }
        }
        return files;
    }

    private RestFileBrokerClient getFileBrokerClient() {
        if (this.fileBrokerClient == null) {
            this.fileBrokerClient = new RestFileBrokerClient(this.getFileBrokerUri(), this.credentials);
        }
        return this.fileBrokerClient;
    }

    private SessionDbClient getSessionDbClient() {
        if (this.sessionDbClient == null) {
            this.sessionDbClient = new SessionDbClient(this.getSessionDbUri(), this.getSessionDbEventsUri(), this.credentials);
        }
        return this.sessionDbClient;
    }

    private ToolboxClientRest getToolboxClient() {
        if (this.toolboxClient == null) {
            this.toolboxClient = new ToolboxClientRest(this.getToolboxUri());
        }
        return this.toolboxClient;
    }

    private void printFixed(String string, int length) {
        System.out.print(StringUtils.rightPad((String)string, (int)length) + "  ");
    }

    private void printKeyValue(String key, Object value) {
        String margin = StringUtils.rightPad((String)"", (int)22);
        String wrappedValue = WordUtils.wrap((String)("" + value), (int)60).replace("\n", "\n" + margin);
        System.out.println(StringUtils.rightPad((String)key, (int)20) + "  " + wrappedValue);
    }
}

