/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.filebroker;

import fi.csc.chipster.rest.RestUtils;
import fi.csc.chipster.rest.StaticCredentials;
import fi.csc.chipster.rest.exception.ConflictException;
import fi.csc.chipster.rest.exception.NotAuthorizedException;
import fi.csc.chipster.rest.token.TokenRequestFilter;
import fi.csc.chipster.servicelocator.ServiceLocatorClient;
import fi.csc.chipster.sessiondb.RestException;
import fi.csc.chipster.sessiondb.SessionDbClient;
import fi.csc.chipster.sessiondb.model.Dataset;
import fi.csc.chipster.sessiondb.model.File;
import fi.csc.chipster.sessiondb.model.SessionEvent;
import fi.csc.microarray.util.IOUtils;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Enumeration;
import java.util.List;
import java.util.UUID;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.MediaType;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.server.InclusiveByteRange;
import org.eclipse.jetty.servlet.DefaultServlet;

public class FileServlet
extends DefaultServlet
implements SessionDbClient.SessionEventListener {
    private static final Logger logger = LogManager.getLogger();
    private boolean logRest = false;
    private java.io.File storageRoot;
    private SessionDbClient sessionDbClient;
    private String sessionDbUri;
    private String sessionDbEventsUri;

    public FileServlet(java.io.File storageRoot, SessionDbClient sessionDbClient, ServiceLocatorClient serviceLocator) {
        this.storageRoot = storageRoot;
        this.sessionDbClient = sessionDbClient;
        this.sessionDbUri = serviceLocator.get("session-db").get(0);
        this.sessionDbEventsUri = serviceLocator.get("session-db-events").get(0);
        this.logRest = true;
        logger.info("logging rest requests: " + this.logRest);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Dataset dataset;
        if (logger.isDebugEnabled()) {
            logger.debug("RESTful file access: GET request for " + request.getRequestURI());
        }
        boolean download = request.getParameter("download") != null;
        boolean type = request.getParameter("type") != null;
        String userToken = this.getToken(request);
        Path path = this.parsePath(request.getPathInfo());
        try {
            dataset = this.getDataset(path.getSessionId(), path.getDatasetId(), userToken, false);
        }
        catch (RestException e) {
            throw new ServletException(e.getMessage());
        }
        if (dataset.getFile() == null || dataset.getFile().getFileId() == null) {
            throw new ForbiddenException("file id is null");
        }
        UUID fileId = dataset.getFile().getFileId();
        java.io.File f = this.getStorageFile(fileId);
        if (!f.exists()) {
            throw new ForbiddenException("no such file");
        }
        RewrittenRequest rewrittenRequest = new RewrittenRequest(request, "/" + fileId.toString());
        if (download) {
            RestUtils.configureForDownload(response, dataset.getName());
        }
        if (type) {
            response.setContentType(this.getType(dataset).toString());
        }
        LocalDateTime before = LocalDateTime.now();
        super.doGet((HttpServletRequest)rewrittenRequest, response);
        if (this.logRest) {
            this.logAsyncGet(request, response, f, before);
        }
    }

    private void logAsyncGet(final HttpServletRequest request, HttpServletResponse response, final java.io.File f, final LocalDateTime before) {
        if (request.isAsyncStarted()) {
            request.getAsyncContext().addListener(new AsyncListener(){

                public void onTimeout(AsyncEvent event) throws IOException {
                }

                public void onStartAsync(AsyncEvent event) throws IOException {
                }

                public void onError(AsyncEvent event) throws IOException {
                }

                public void onComplete(AsyncEvent event) throws IOException {
                    FileServlet.this.logGet(request, f, before);
                }
            });
        } else {
            this.logGet(request, f, before);
        }
    }

    private void logGet(HttpServletRequest request, java.io.File f, LocalDateTime before) {
        long length = f.length();
        List ranges = InclusiveByteRange.satisfiableRanges((Enumeration)request.getHeaders(HttpHeader.RANGE.asString()), (long)f.length());
        if (ranges != null && ranges.size() == 1) {
            length = ((InclusiveByteRange)ranges.get(0)).getLast() - ((InclusiveByteRange)ranges.get(0)).getFirst();
        }
        Duration duration = Duration.between(before, LocalDateTime.now());
        double rate = this.getTransferRate(length, duration);
        logger.info("GET " + f.getName() + " from " + request.getRemoteHost() + " | " + FileUtils.byteCountToDisplaySize((long)length) + " | " + FileUtils.byteCountToDisplaySize((long)f.length()) + " | " + DurationFormatUtils.formatDurationHMS((long)duration.toMillis()) + " | " + new DecimalFormat("###.##").format(rate) + " MB/s");
    }

    private String getToken(HttpServletRequest request) {
        String tokenParameter = request.getParameter("token");
        String tokenHeader = request.getHeader("authorization");
        return TokenRequestFilter.getToken(tokenHeader, tokenParameter);
    }

    private Path parsePath(String pathInfo) {
        String[] path = pathInfo.split("/");
        if (path.length != 5) {
            throw new NotFoundException();
        }
        if (!"".equals(path[0])) {
            throw new BadRequestException("path doesn't start with slash");
        }
        if (!"sessions".equals(path[1])) {
            throw new NotFoundException(path[1] + " not found");
        }
        UUID sessionId = UUID.fromString(path[2]);
        if (!"datasets".equals(path[3])) {
            throw new NotFoundException(path[3] + " not found");
        }
        UUID datasetId = UUID.fromString(path[4]);
        return new Path(sessionId, datasetId);
    }

    private Dataset getDataset(UUID sessionId, UUID datasetId, String userToken, boolean requireReadWrite) throws RestException, IOException {
        SessionDbClient sessionDbWithUserCredentials = new SessionDbClient(this.sessionDbUri, this.sessionDbEventsUri, new StaticCredentials("token", userToken));
        try {
            Dataset dataset = sessionDbWithUserCredentials.getDataset(sessionId, datasetId, requireReadWrite);
            if (dataset == null) {
                throw new ForbiddenException("dataset not found");
            }
            return dataset;
        }
        catch (RestException e) {
            int statusCode = e.getResponse().getStatus();
            String msg = e.getMessage();
            if (statusCode == 403) {
                throw new ForbiddenException(msg);
            }
            if (statusCode == 401) {
                throw new NotAuthorizedException(msg);
            }
            if (statusCode == 404) {
                throw new NotFoundException(msg);
            }
            throw e;
        }
    }

    private MediaType getType(Dataset dataset) {
        MediaType type = null;
        if (dataset.getName().toLowerCase().endsWith(".html")) {
            type = MediaType.TEXT_HTML_TYPE;
        }
        return type;
    }

    private java.io.File getStorageFile(UUID fileId) {
        return new java.io.File(this.storageRoot, fileId.toString());
    }

    private static Long getParameterLong(HttpServletRequest req, String key) {
        String stringValue = req.getParameter(key);
        if (stringValue != null) {
            return Long.parseLong(stringValue);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (logger.isDebugEnabled()) {
            logger.info("PUT request for " + request.getRequestURI());
        }
        Long chunkNumber = FileServlet.getParameterLong(request, "flowChunkNumber");
        Long chunkSize = FileServlet.getParameterLong(request, "flowChunkSize");
        Long flowTotalChunks = FileServlet.getParameterLong(request, "flowTotalChunks");
        String userToken = this.getToken(request);
        UUID fileId = null;
        Dataset dataset = null;
        try {
            logger.debug("chunkNumber " + chunkNumber + " uploading");
            Path path = this.parsePath(request.getPathInfo());
            dataset = this.getDataset(path.getSessionId(), path.getDatasetId(), userToken, true);
            ServletInputStream inputStream = request.getInputStream();
            if (chunkNumber == null || chunkNumber == 1L) {
                if (dataset.getFile() != null) {
                    throw new ConflictException("file not null");
                }
                fileId = RestUtils.createUUID();
                java.io.File f = this.getStorageFile(fileId);
                if (f.exists()) {
                    throw new ConflictException("file exists");
                }
                try {
                    IOUtils.copy((InputStream)inputStream, (java.io.File)f);
                    File file = new File();
                    file.setFileId(fileId);
                    file.setSize(f.length());
                    file.setFileCreated(LocalDateTime.now());
                    dataset.setFile(file);
                    this.sessionDbClient.updateDataset(path.getSessionId(), dataset);
                }
                catch (EOFException e) {
                    f.delete();
                    throw new BadRequestException("EOF");
                }
            }
            if (dataset.getFile() == null) {
                throw new ConflictException("file is null");
            }
            fileId = dataset.getFile().getFileId();
            java.io.File f = this.getStorageFile(fileId);
            if (f.exists()) {
                if (chunkNumber == null || chunkSize == null) {
                    throw new ConflictException("missing query parameters");
                }
                if (this.isChunkReady(f, chunkNumber, chunkSize)) {
                    inputStream.close();
                    response.setStatus(200);
                    return;
                }
            }
            java.io.File chunkFile = new java.io.File(f.getParent(), f.getName() + ".chunk" + chunkNumber);
            try {
                Throwable throwable;
                logger.debug("file size at start: " + f.length());
                try {
                    throwable = null;
                    try (FileOutputStream chunkOutStream = new FileOutputStream(chunkFile, false);){
                        IOUtils.copy((InputStream)inputStream, (OutputStream)chunkOutStream);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                finally {
                    inputStream.close();
                }
                logger.debug("chunk file size: " + chunkFile.length());
                throwable = null;
                try (FileInputStream chunkInStream = new FileInputStream(chunkFile);
                     FileOutputStream outStream = new FileOutputStream(f, true);){
                    IOUtils.copy((InputStream)chunkInStream, (OutputStream)outStream);
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                logger.debug("file size after copy: " + f.length());
                if (flowTotalChunks == chunkNumber) {
                    dataset.getFile().setSize(f.length());
                    this.sessionDbClient.updateDataset(path.getSessionId(), dataset);
                }
            }
            catch (EOFException e) {
                throw new BadRequestException("EOF");
            }
            finally {
                if (chunkFile.exists()) {
                    chunkFile.delete();
                }
            }
            response.setStatus(204);
            return;
        }
        catch (RestException | IOException e) {
            throw new InternalServerErrorException("upload failed", (Throwable)e);
        }
    }

    private boolean isChunkReady(java.io.File f, Long chunkNumber, Long chunkSize) {
        long expectedSize = chunkNumber * chunkSize;
        logger.debug("is chunk " + chunkNumber + " ready? File size: " + f.length() + " expected " + expectedSize);
        return f.exists() && f.length() >= expectedSize;
    }

    @Override
    public void onEvent(SessionEvent e) {
        logger.debug("received a file event: " + (Object)((Object)e.getResourceType()) + " " + (Object)((Object)e.getType()));
        if (SessionEvent.ResourceType.FILE == e.getResourceType() && SessionEvent.EventType.DELETE == e.getType()) {
            if (e.getResourceId() != null) {
                this.getStorageFile(e.getResourceId()).delete();
            } else {
                logger.warn("received a file deletion event with null id");
            }
        }
    }

    private double getTransferRate(long fileSize, Duration duration) {
        double rate = duration.toMillis() != 0L ? (double)fileSize / (double)duration.toMillis() * 1000.0 / 1024.0 / 1024.0 : 0.0;
        return rate;
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setStatus(405);
    }

    protected void doHead(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setStatus(405);
    }

    protected void doOptions(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setStatus(200);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setStatus(405);
    }

    protected void doTrace(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setStatus(405);
    }

    public static class Path {
        private UUID datasetId;
        private UUID sessionId;

        public Path(UUID sessionId, UUID datasetId) {
            this.sessionId = sessionId;
            this.datasetId = datasetId;
        }

        public UUID getDatasetId() {
            return this.datasetId;
        }

        public void setDatasetId(UUID datasetId) {
            this.datasetId = datasetId;
        }

        public UUID getSessionId() {
            return this.sessionId;
        }

        public void setSessionId(UUID sessionId) {
            this.sessionId = sessionId;
        }
    }

    public static class RewrittenRequest
    extends HttpServletRequestWrapper {
        private String newPath;

        public RewrittenRequest(HttpServletRequest request, String newPath) {
            super(request);
            this.newPath = newPath;
        }

        public String getPathInfo() {
            return this.newPath;
        }
    }
}

