/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.proxy;

import fi.csc.chipster.proxy.ConnectionManager;
import fi.csc.chipster.proxy.WebSocketProxySocket;
import javax.inject.Singleton;
import javax.websocket.CloseReason;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import org.eclipse.jetty.websocket.servlet.WebSocketServlet;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;

@Singleton
public class WebSocketProxyServlet
extends WebSocketServlet {
    private ConnectionManager connectionManager;

    public WebSocketProxyServlet(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public void configure(WebSocketServletFactory factory) {
        factory.register(WebSocketProxySocket.class);
        final String proxyTo = this.getInitParameter("proxyTo");
        final String prefix = this.getInitParameter("prefix");
        factory.setCreator(new WebSocketCreator(){

            public Object createWebSocket(ServletUpgradeRequest req, ServletUpgradeResponse resp) {
                return new WebSocketProxySocket(prefix, proxyTo, WebSocketProxyServlet.this.connectionManager);
            }
        });
    }

    public static CloseReason toCloseReason(Throwable e) {
        String msg = "proxy error: " + e.getClass().getSimpleName() + " " + e.getMessage();
        if (e.getCause() != null) {
            msg = msg + " Caused by: " + e.getCause().getClass().getSimpleName() + " " + e.getCause().getMessage();
        }
        return new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.UNEXPECTED_CONDITION, msg);
    }
}

