/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.rest;

import fi.csc.chipster.auth.AuthenticationService;
import fi.csc.chipster.comp.RestCompServer;
import fi.csc.chipster.filebroker.FileBroker;
import fi.csc.chipster.proxy.ChipsterProxyServer;
import fi.csc.chipster.rest.Config;
import fi.csc.chipster.rest.JavascriptService;
import fi.csc.chipster.scheduler.Scheduler;
import fi.csc.chipster.servicelocator.ServiceLocator;
import fi.csc.chipster.sessiondb.SessionDb;
import fi.csc.chipster.sessionworker.SessionWorker;
import fi.csc.chipster.toolbox.ToolboxService;
import fi.csc.chipster.web.WebServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerLauncher {
    private final Logger logger = LogManager.getLogger();
    private AuthenticationService auth;
    private ServiceLocator serviceLocator;
    private SessionDb sessionDb;
    private Scheduler scheduler;
    private ToolboxService toolbox;
    private ChipsterProxyServer proxy;
    private FileBroker fileBroker;
    private WebServer web;
    private RestCompServer comp;
    private SessionDb sessionDbSlave;
    private SessionWorker sessionWorker;
    private JavascriptService typeService;

    public ServerLauncher(Config config, boolean verbose) throws Exception {
        long t = System.currentTimeMillis();
        if (verbose) {
            this.logger.info("starting authentication-service");
        }
        this.auth = new AuthenticationService(config);
        this.auth.startServer();
        if (verbose) {
            this.logger.info("starting service-locator");
        }
        this.serviceLocator = new ServiceLocator(config);
        this.serviceLocator.startServer();
        if (verbose) {
            this.logger.info("starting session-db");
        }
        this.sessionDb = new SessionDb(config);
        this.sessionDb.startServer();
        if (verbose) {
            this.logger.info("starting file-broker");
        }
        this.fileBroker = new FileBroker(config);
        this.fileBroker.startServer();
        if (verbose) {
            this.logger.info("starting session-worker");
        }
        this.sessionWorker = new SessionWorker(config);
        this.sessionWorker.startServer();
        if (verbose) {
            this.logger.info("starting scheduler");
        }
        this.scheduler = new Scheduler(config);
        this.scheduler.startServer();
        if (verbose) {
            this.logger.info("starting toolbox");
        }
        this.toolbox = new ToolboxService(config);
        this.toolbox.startServer();
        if (verbose) {
            this.logger.info("starting comp");
        }
        this.comp = new RestCompServer(null, config);
        this.comp.startServer();
        if (verbose) {
            this.logger.info("starting web server");
        }
        this.web = new WebServer(config);
        this.web.start();
        if (verbose) {
            this.logger.info("starting type service");
        }
        this.typeService = new JavascriptService("js/type-service");
        this.typeService.startServer();
        if (verbose) {
            this.logger.info("starting proxy");
        }
        this.proxy = new ChipsterProxyServer(config);
        this.proxy.startServer();
        if (verbose) {
            this.logger.info("up and running (" + (System.currentTimeMillis() - t) / 1000L + " seconds)");
            this.logger.info("---------------------------");
            this.logger.info("press enter to stop");
        }
        System.in.read();
        this.stop();
        System.exit(0);
    }

    public void stop() {
        if (this.proxy != null) {
            try {
                this.proxy.close();
            }
            catch (Exception e) {
                this.logger.warn("closing proxy failed", (Throwable)e);
            }
        }
        if (this.web != null) {
            try {
                this.web.close();
            }
            catch (Exception e) {
                this.logger.warn("closing web server failed", (Throwable)e);
            }
        }
        if (this.typeService != null) {
            try {
                this.typeService.close();
            }
            catch (Exception e) {
                this.logger.warn("closing type service failed");
            }
        }
        if (this.comp != null) {
            try {
                this.comp.shutdown();
            }
            catch (Exception e) {
                this.logger.warn("closing toolbox failed", (Throwable)e);
            }
        }
        if (this.toolbox != null) {
            try {
                this.toolbox.close();
            }
            catch (Exception e) {
                this.logger.warn("closing toolbox failed", (Throwable)e);
            }
        }
        if (this.scheduler != null) {
            try {
                this.scheduler.close();
            }
            catch (Exception e) {
                this.logger.warn("closing scheduler failed", (Throwable)e);
            }
        }
        if (this.sessionWorker != null) {
            try {
                this.sessionWorker.close();
            }
            catch (Exception e) {
                this.logger.warn("closing session-worker failed");
            }
        }
        if (this.fileBroker != null) {
            try {
                this.fileBroker.close();
            }
            catch (Exception e) {
                this.logger.warn("closing filebroker failed", (Throwable)e);
            }
        }
        if (this.sessionDbSlave != null) {
            try {
                this.sessionDbSlave.close();
            }
            catch (Exception e) {
                this.logger.warn("closing session-db slave failed", (Throwable)e);
            }
        }
        if (this.sessionDb != null) {
            try {
                this.sessionDb.close();
            }
            catch (Exception e) {
                this.logger.warn("closing session-db failed", (Throwable)e);
            }
        }
        if (this.serviceLocator != null) {
            try {
                this.serviceLocator.close();
            }
            catch (Exception e) {
                this.logger.warn("closing service-locator failed", (Throwable)e);
            }
        }
        if (this.auth != null) {
            try {
                this.auth.close();
            }
            catch (Exception e) {
                this.logger.warn("closing auth failed", (Throwable)e);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        Config config = new Config();
        new ServerLauncher(config, true);
    }

    public SessionDb getSessionDb() {
        return this.sessionDb;
    }
}

