/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.rest.websocket;

import fi.csc.chipster.rest.websocket.Subscriber;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import javax.websocket.RemoteEndpoint;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Topic {
    private static final Logger logger = LogManager.getLogger();
    private ConcurrentHashMap<RemoteEndpoint.Basic, Subscriber> subscribers = new ConcurrentHashMap();

    public void add(Subscriber s) {
        this.subscribers.put(s.getRemote(), s);
        logger.debug("subscribers: " + this.subscribers.size());
    }

    public void remove(RemoteEndpoint.Basic basicRemote) {
        this.subscribers.remove(basicRemote);
    }

    public boolean isEmpty() {
        return this.subscribers.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(String msg) {
        Topic topic = this;
        synchronized (topic) {
            logger.debug("publish to " + this.subscribers.size() + " subscribers: " + msg);
            for (Subscriber s : this.subscribers.values()) {
                try {
                    logger.debug("send to " + s.getRemoteAddress());
                    s.getRemote().sendText(msg);
                }
                catch (IOException e) {
                    logger.warn("failed to publish a message to: " + this.subscribers.get(s.getRemoteAddress()), (Throwable)e);
                }
            }
        }
    }

    public ConcurrentHashMap<RemoteEndpoint.Basic, Subscriber> getSubscribers() {
        return this.subscribers;
    }
}

