/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.scheduler;

import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;

public class JobSchedulingState {
    private LocalDateTime newTimestamp;
    private LocalDateTime scheduleTimestamp;
    private LocalDateTime runningTimestamp;
    private LocalDateTime runnableTimestamp;

    public JobSchedulingState() {
        this.setNewTimestamp();
    }

    public LocalDateTime getNewTimestamp() {
        return this.newTimestamp;
    }

    public void setNewTimestamp() {
        if (this.newTimestamp == null) {
            this.newTimestamp = LocalDateTime.now();
        }
    }

    public LocalDateTime getScheduleTimestamp() {
        return this.scheduleTimestamp;
    }

    public void setScheduleTimestamp() {
        this.scheduleTimestamp = LocalDateTime.now();
    }

    public LocalDateTime getRunningTimestamp() {
        return this.runningTimestamp;
    }

    public void setRunningTimestamp() {
        this.runningTimestamp = LocalDateTime.now();
    }

    public boolean isScheduled() {
        return this.scheduleTimestamp != null && this.runningTimestamp == null;
    }

    public boolean isRunning() {
        return this.runningTimestamp != null;
    }

    public void removeScheduled() {
        this.scheduleTimestamp = null;
    }

    public boolean isNew() {
        return this.scheduleTimestamp == null && this.runningTimestamp == null;
    }

    public long getTimeSinceNew() {
        return this.newTimestamp.until(LocalDateTime.now(), ChronoUnit.SECONDS);
    }

    public long getTimeSinceScheduled() {
        return this.scheduleTimestamp.until(LocalDateTime.now(), ChronoUnit.SECONDS);
    }

    public long getTimeSinceLastHeartbeat() {
        return this.runningTimestamp.until(LocalDateTime.now(), ChronoUnit.SECONDS);
    }

    public void setRunnableTimestamp() {
        this.runnableTimestamp = LocalDateTime.now();
    }

    public boolean isRunnable() {
        return this.runnableTimestamp != null;
    }
}

