/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.scheduler;

import fi.csc.chipster.auth.AuthenticationClient;
import fi.csc.chipster.rest.AdminResource;
import fi.csc.chipster.rest.Config;
import fi.csc.chipster.rest.RestUtils;
import fi.csc.chipster.rest.StatusSource;
import fi.csc.chipster.rest.websocket.PubSubServer;
import fi.csc.chipster.scheduler.IdPair;
import fi.csc.chipster.scheduler.JobCommand;
import fi.csc.chipster.scheduler.JobSchedulingState;
import fi.csc.chipster.scheduler.SchedulerJobs;
import fi.csc.chipster.scheduler.SchedulerTopicConfig;
import fi.csc.chipster.servicelocator.ServiceLocatorClient;
import fi.csc.chipster.sessiondb.RestException;
import fi.csc.chipster.sessiondb.SessionDbClient;
import fi.csc.chipster.sessiondb.model.Job;
import fi.csc.chipster.sessiondb.model.SessionEvent;
import fi.csc.microarray.messaging.JobState;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.websocket.DeploymentException;
import javax.websocket.MessageHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.glassfish.grizzly.http.server.HttpServer;

public class Scheduler
implements SessionDbClient.SessionEventListener,
MessageHandler.Whole<String>,
StatusSource {
    private Logger logger = LogManager.getLogger();
    private AuthenticationClient authService;
    private Config config;
    private ServiceLocatorClient serviceLocator;
    private String serviceId;
    private SessionDbClient sessionDbClient;
    private PubSubServer pubSubServer;
    private SchedulerJobs jobs = new SchedulerJobs();
    private long waitTimeout;
    private long waitRunnableTimeout;
    private long scheduleTimeout;
    private long heartbeatLostTimeout;
    private long jobTimerInterval;
    private Timer jobTimer;
    private HttpServer adminServer;

    public Scheduler(Config config) {
        this.config = config;
    }

    public void startServer() throws ServletException, DeploymentException, InterruptedException, RestException, IOException {
        String username = "scheduler";
        String password = this.config.getPassword(username);
        this.waitTimeout = this.config.getLong("scheduler-wait-timeout");
        this.waitRunnableTimeout = this.config.getLong("scheduler-wait-runnable-timeout");
        this.scheduleTimeout = this.config.getLong("scheduler-schedule-timeout");
        this.heartbeatLostTimeout = this.config.getLong("scheduler-heartbeat-lost-timeout");
        this.jobTimerInterval = this.config.getLong("scheduler-job-timer-interval") * 1000L;
        this.serviceLocator = new ServiceLocatorClient(this.config);
        this.authService = new AuthenticationClient(this.serviceLocator, username, password);
        this.sessionDbClient = new SessionDbClient(this.serviceLocator, this.authService.getCredentials());
        this.sessionDbClient.subscribe("jobs", this, "scheduler-job-listener");
        SchedulerTopicConfig topicConfig = new SchedulerTopicConfig(this.authService);
        this.pubSubServer = new PubSubServer(this.config.getBindUrl("scheduler"), "events", this, topicConfig, "scheduler-events");
        this.pubSubServer.setIdleTimeout(this.config.getLong("websocket-idle-timeout"));
        this.pubSubServer.start();
        this.logger.info("getting unfinished jobs from the session-db");
        this.getStateFromDb();
        this.jobTimer = new Timer("job timer", true);
        this.jobTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    Scheduler.this.handleJobTimer();
                }
                catch (Exception e) {
                    Scheduler.this.logger.error("error in job timer", (Throwable)e);
                }
            }
        }, this.jobTimerInterval, this.jobTimerInterval);
        this.logger.info("starting the admin rest server");
        this.adminServer = RestUtils.startAdminServer((Object)new AdminResource(this, this.pubSubServer), null, "scheduler", this.config, this.authService);
        this.logger.info("scheduler is up and running");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getStateFromDb() throws RestException {
        SchedulerJobs schedulerJobs = this.jobs;
        synchronized (schedulerJobs) {
            List<IdPair> runningDbJobs;
            List<IdPair> newDbJobs = this.sessionDbClient.getJobs(JobState.NEW);
            if (!newDbJobs.isEmpty()) {
                this.logger.info("found " + newDbJobs.size() + " waiting jobs from the session-db");
                for (IdPair job : newDbJobs) {
                    this.jobs.addNewJob(new IdPair(job.getSessionId(), job.getJobId()));
                }
            }
            if (!(runningDbJobs = this.sessionDbClient.getJobs(JobState.RUNNING)).isEmpty()) {
                this.logger.info("found " + runningDbJobs.size() + " running jobs from the session-db");
                for (IdPair job : runningDbJobs) {
                    this.jobs.addRunningJob(new IdPair(job.getSessionId(), job.getJobId()));
                }
            }
        }
    }

    public static void main(String[] args) throws Exception {
        Scheduler server = new Scheduler(new Config());
        try {
            server.startServer();
        }
        catch (Exception e) {
            System.err.println("scheduler startup failed, exiting");
            e.printStackTrace(System.err);
            server.close();
            System.exit(1);
        }
    }

    public void close() {
        RestUtils.shutdown("scheduler-admin", this.adminServer);
        try {
            this.sessionDbClient.close();
        }
        catch (IOException e) {
            this.logger.warn("failed to stop the session-db client", (Throwable)e);
        }
        if (this.pubSubServer != null) {
            this.pubSubServer.stop();
        }
    }

    @Override
    public void onEvent(SessionEvent e) {
        this.logger.debug("received a job event: " + (Object)((Object)e.getResourceType()) + " " + (Object)((Object)e.getType()));
        try {
            if (e.getResourceType() == SessionEvent.ResourceType.JOB) {
                this.handleDbEvent(e, new IdPair(e.getSessionId(), e.getResourceId()));
            }
        }
        catch (Exception ex) {
            this.logger.error("error when handling a session event", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDbEvent(SessionEvent e, IdPair jobIdPair) throws RestException {
        SchedulerJobs schedulerJobs = this.jobs;
        synchronized (schedulerJobs) {
            block2 : switch (e.getType()) {
                case CREATE: {
                    Job job = this.sessionDbClient.getJob(e.getSessionId(), e.getResourceId());
                    switch (job.getState()) {
                        case NEW: {
                            this.logger.info("received a new job " + jobIdPair + ", trying to schedule it");
                            this.jobs.addNewJob(jobIdPair);
                            this.schedule(jobIdPair);
                            break block2;
                        }
                    }
                    break;
                }
                case UPDATE: {
                    Job job = this.sessionDbClient.getJob(e.getSessionId(), e.getResourceId());
                    switch (job.getState()) {
                        case COMPLETED: 
                        case FAILED: 
                        case FAILED_USER_ERROR: {
                            this.logger.info("job finished " + jobIdPair);
                            this.jobs.remove(jobIdPair);
                            break block2;
                        }
                    }
                    break;
                }
                case DELETE: {
                    this.cancel(jobIdPair);
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(String message) {
        SchedulerJobs schedulerJobs = this.jobs;
        synchronized (schedulerJobs) {
            JobCommand compMsg = RestUtils.parseJson(JobCommand.class, message);
            IdPair jobIdPair = new IdPair(compMsg.getSessionId(), compMsg.getJobId());
            switch (compMsg.getCommand()) {
                case OFFER: {
                    this.logger.info("received an offer for job " + jobIdPair + " from comp " + this.asShort(compMsg.getCompId()));
                    if (this.jobs.get(jobIdPair) != null) {
                        if (this.jobs.get(jobIdPair).isRunning()) break;
                        this.jobs.get(jobIdPair).setRunningTimestamp();
                        this.run(compMsg, jobIdPair);
                        break;
                    }
                    this.logger.warn("comp " + this.asShort(compMsg.getCompId()) + " sent a offer of an non-existing job " + this.asShort(jobIdPair.getJobId()));
                    break;
                }
                case BUSY: {
                    this.logger.info("job " + jobIdPair + " is runnable on comp " + this.asShort(compMsg.getCompId()));
                    if (this.jobs.get(jobIdPair) != null) {
                        this.jobs.get(jobIdPair).setRunnableTimestamp();
                        break;
                    }
                    this.logger.warn("comp " + this.asShort(compMsg.getCompId()) + " sent a busy message of an non-existing job " + this.asShort(jobIdPair.getJobId()));
                    break;
                }
                case AVAILABLE: {
                    this.logger.debug("comp available " + this.asShort(compMsg.getCompId()));
                    this.scheduleNewJobs();
                    break;
                }
                case RUNNING: {
                    this.logger.debug("job running " + jobIdPair);
                    if (this.jobs.get(jobIdPair) != null) {
                        this.jobs.get(jobIdPair).setRunningTimestamp();
                        break;
                    }
                    this.logger.warn("comp " + this.asShort(compMsg.getCompId()) + " sent a heartbeat of an non-existing job " + this.asShort(jobIdPair.getJobId()));
                    break;
                }
                default: {
                    this.logger.warn("unknown command: " + (Object)((Object)compMsg.getCommand()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleJobTimer() {
        SchedulerJobs schedulerJobs = this.jobs;
        synchronized (schedulerJobs) {
            for (IdPair jobIdPair : this.jobs.getNewJobs().keySet()) {
                if (this.jobs.get(jobIdPair).isRunnable()) {
                    if (this.jobs.get(jobIdPair).getTimeSinceNew() <= this.waitRunnableTimeout) continue;
                    this.jobs.remove(jobIdPair);
                    this.expire(jobIdPair, "There was no computing server available to run this job, please try again later");
                    continue;
                }
                if (this.jobs.get(jobIdPair).getTimeSinceNew() <= this.waitTimeout) continue;
                this.jobs.remove(jobIdPair);
                this.expire(jobIdPair, "There was no computing server available to run this job, please inform server maintainers");
            }
            for (IdPair jobIdPair : this.jobs.getScheduledJobs().keySet()) {
                if (this.jobs.get(jobIdPair).getTimeSinceScheduled() <= this.scheduleTimeout) continue;
                this.jobs.get(jobIdPair).removeScheduled();
            }
            for (IdPair jobIdPair : this.jobs.getRunningJobs().keySet()) {
                if (this.jobs.get(jobIdPair).getTimeSinceLastHeartbeat() <= this.heartbeatLostTimeout) continue;
                this.jobs.remove(jobIdPair);
                this.expire(jobIdPair, "heartbeat lost");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void schedule(IdPair jobIdPair) {
        SchedulerJobs schedulerJobs = this.jobs;
        synchronized (schedulerJobs) {
            this.jobs.get(jobIdPair).setScheduleTimestamp();
            JobCommand cmd = new JobCommand(jobIdPair.getSessionId(), jobIdPair.getJobId(), null, JobCommand.Command.SCHEDULE);
            this.pubSubServer.publish(cmd);
        }
    }

    private void run(JobCommand compMsg, IdPair jobId) {
        this.logger.info("offer for job " + jobId + " chosen from comp " + this.asShort(compMsg.getCompId()));
        this.pubSubServer.publish(new JobCommand(compMsg.getSessionId(), compMsg.getJobId(), compMsg.getCompId(), JobCommand.Command.CHOOSE));
    }

    private void expire(IdPair jobId, String reason) {
        try {
            Job job = this.sessionDbClient.getJob(jobId.getSessionId(), jobId.getJobId());
            this.logger.warn("max wait time reached for job " + jobId);
            job.setEndTime(LocalDateTime.now());
            job.setState(JobState.EXPIRED_WAITING);
            job.setStateDetail("Job expired (" + reason + ")");
            this.sessionDbClient.updateJob(jobId.getSessionId(), job);
        }
        catch (RestException e) {
            this.logger.error("could not set an old job " + jobId + " to expired", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancel(IdPair jobId) {
        SchedulerJobs schedulerJobs = this.jobs;
        synchronized (schedulerJobs) {
            this.logger.info("cancel job " + jobId);
            this.jobs.remove(jobId);
            JobCommand cmd = new JobCommand(jobId.getSessionId(), jobId.getJobId(), null, JobCommand.Command.CANCEL);
            this.pubSubServer.publish(cmd);
        }
    }

    private void scheduleNewJobs() {
        List newJobs = this.jobs.getNewJobs().entrySet().stream().sorted((e1, e2) -> ((JobSchedulingState)e1.getValue()).getNewTimestamp().compareTo(((JobSchedulingState)e2.getValue()).getNewTimestamp())).map(e -> (IdPair)e.getKey()).collect(Collectors.toList());
        if (newJobs.size() > 0) {
            this.logger.info("rescheduling " + newJobs.size() + " waiting jobs (" + this.jobs.getScheduledJobs().size() + " still being scheduled");
            for (IdPair job : newJobs) {
                this.schedule(job);
            }
        }
    }

    private String asShort(UUID id) {
        return id.toString().substring(0, 4);
    }

    @Override
    public Map<String, Object> getStatus() {
        HashMap<String, Object> status = new HashMap<String, Object>();
        status.put("newJobCount", this.jobs.getNewJobs().size());
        status.put("runningJobCount", this.jobs.getRunningJobs().size());
        status.put("scheduledJobCount", this.jobs.getScheduledJobs().size());
        return status;
    }
}

