/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.servicelocator.resource;

import fi.csc.chipster.servicelocator.resource.Service;
import fi.csc.chipster.servicelocator.resource.ServiceCatalog;
import java.net.URI;
import java.util.Collection;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Path(value="services")
public class ServiceResource {
    public static final String SERVICES = "services";
    private static Logger logger = LogManager.getLogger();
    private ServiceCatalog serviceCatalog;

    public ServiceResource(ServiceCatalog serviceCatalog) {
        this.serviceCatalog = serviceCatalog;
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"unauthenticated"})
    public Response getAll(@Context SecurityContext sc) {
        Collection<Service> services = this.serviceCatalog.getAll();
        return Response.ok(this.toJaxbList(services)).build();
    }

    @POST
    @RolesAllowed(value={"server"})
    @Consumes(value={"application/json"})
    public Response post(Service service, @Context UriInfo uriInfo, @Context SecurityContext sc) {
        String serviceId = this.serviceCatalog.add("session-db", service);
        URI uri = uriInfo.getAbsolutePathBuilder().path(serviceId).build(new Object[0]);
        return Response.created((URI)uri).build();
    }

    @DELETE
    @RolesAllowed(value={"server"})
    @Path(value="{id}")
    public Response delete(@PathParam(value="id") String id, @Context SecurityContext sc) {
        this.serviceCatalog.remove(id);
        return Response.noContent().build();
    }

    private GenericEntity<Collection<Service>> toJaxbList(Collection<Service> result) {
        return new GenericEntity<Collection<Service>>(result){};
    }

    public ServiceCatalog getServiceCatalog() {
        return this.serviceCatalog;
    }
}

