/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.sessiondb.resource;

import fi.csc.chipster.rest.exception.NotAuthorizedException;
import fi.csc.chipster.rest.hibernate.HibernateUtil;
import fi.csc.chipster.sessiondb.model.Dataset;
import fi.csc.chipster.sessiondb.model.DatasetToken;
import fi.csc.chipster.sessiondb.model.Session;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.NotFoundException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DatasetTokenTable {
    public static final Logger logger = LogManager.getLogger();
    private static final int CLEAN_UP_INTERVAL = 60;
    private HibernateUtil hibernate;
    private Timer cleanUpTimer;

    public DatasetTokenTable(final HibernateUtil hibernate) {
        this.hibernate = hibernate;
        long cleanUpIntervalMs = 3600000L;
        this.cleanUpTimer = new Timer("dataset clean up timer", true);
        this.cleanUpTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    hibernate.runInTransaction(new HibernateUtil.HibernateRunnable<Void>(){

                        @Override
                        public Void run(org.hibernate.Session hibernateSession) {
                            DatasetTokenTable.this.cleanUp(hibernateSession);
                            return null;
                        }
                    });
                }
                catch (Exception e) {
                    logger.warn("dataset token clean up failed", (Throwable)e);
                }
            }
        }, cleanUpIntervalMs, cleanUpIntervalMs);
    }

    public DatasetToken checkAuthorization(UUID tokenKey, UUID sessionId, UUID datasetId) {
        return this.checkAuthorization(tokenKey, sessionId, datasetId, this.hibernate.session());
    }

    public DatasetToken checkAuthorization(UUID tokenKey, UUID sessionId, UUID datasetId, org.hibernate.Session hibernateSession) {
        if (tokenKey == null) {
            throw new NotAuthorizedException("dataset token is null");
        }
        Session session = (Session)hibernateSession.get(Session.class, (Serializable)sessionId);
        if (session == null) {
            throw new NotFoundException("session not found");
        }
        Dataset dataset = (Dataset)hibernateSession.get(Dataset.class, (Serializable)datasetId);
        if (dataset == null) {
            throw new NotFoundException("dataset not found");
        }
        DatasetToken token = (DatasetToken)hibernateSession.get(DatasetToken.class, (Serializable)tokenKey);
        if (token == null) {
            throw new ForbiddenException("token not found");
        }
        if (!sessionId.equals(token.getSession().getSessionId())) {
            throw new ForbiddenException("token not valid for this session");
        }
        if (!datasetId.equals(token.getDataset().getDatasetId())) {
            throw new ForbiddenException("token not valid for this dataset");
        }
        if (token.getValid().isBefore(LocalDateTime.now())) {
            throw new ForbiddenException("token expired");
        }
        return token;
    }

    public void save(DatasetToken datasetToken) {
        this.hibernate.session().save((Object)datasetToken);
    }

    public void cleanUp(org.hibernate.Session hibernateSession) {
        String hql = "delete from " + DatasetToken.class.getSimpleName() + " where valid< :valid";
        int result = hibernateSession.createQuery(hql).setParameter("valid", (Object)LocalDateTime.now()).executeUpdate();
        if (result > 0) {
            logger.info(result + " expired dataset tokens removed");
        }
    }
}

