/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.sessiondb.resource;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import fi.csc.chipster.rest.Config;
import fi.csc.chipster.rest.RestUtils;
import fi.csc.chipster.rest.hibernate.HibernateUtil;
import fi.csc.chipster.rest.token.TokenRequestFilter;
import fi.csc.chipster.sessiondb.model.Dataset;
import fi.csc.chipster.sessiondb.model.Rule;
import fi.csc.chipster.sessiondb.model.Session;
import fi.csc.chipster.sessiondb.resource.DatasetTokenTable;
import fi.csc.chipster.sessiondb.resource.SessionResource;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.StreamingOutput;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.query.Query;

public class RuleTable {
    public static final String EVERYONE = "everyone";
    private static Logger logger = LogManager.getLogger();
    private HibernateUtil hibernate;
    private Config config;
    private Set<String> servicesAccounts;
    private DatasetTokenTable datasetTokenTable;
    private TokenRequestFilter tokenRequestFilter;
    private SessionResource ruleRemovedListener;

    public RuleTable(HibernateUtil hibernate, DatasetTokenTable datasetTokenTable, TokenRequestFilter tokenRequestFilter) {
        this.hibernate = hibernate;
        this.config = new Config();
        this.servicesAccounts = this.config.getServicePasswords().keySet();
        this.datasetTokenTable = datasetTokenTable;
        this.tokenRequestFilter = tokenRequestFilter;
    }

    public Rule getRule(UUID ruleId, org.hibernate.Session hibernateSession) {
        Rule auth = (Rule)hibernateSession.get(Rule.class, (Serializable)ruleId);
        return auth;
    }

    public void delete(UUID sessionId, Rule rule, org.hibernate.Session hibernateSession) {
        hibernateSession.delete((Object)rule);
        if (this.ruleRemovedListener != null) {
            this.ruleRemovedListener.ruleRemoved(sessionId, rule);
        }
    }

    public Session checkAuthorization(String username, UUID sessionId, boolean requireReadWrite) {
        return this.checkAuthorization(username, sessionId, requireReadWrite, this.hibernate.session());
    }

    public Session checkAuthorization(String username, UUID sessionId, boolean requireReadWrite, org.hibernate.Session hibernateSession) {
        if (username == null) {
            throw new ForbiddenException("username is null");
        }
        Session session = (Session)hibernateSession.get(Session.class, (Serializable)sessionId);
        if (session == null) {
            throw new NotFoundException("session not found");
        }
        Rule auth = this.getRule(username, session, hibernateSession);
        if (auth == null) {
            throw new ForbiddenException("access denied");
        }
        if (requireReadWrite && !auth.isReadWrite()) {
            throw new ForbiddenException("read-write access denied");
        }
        return session;
    }

    public List<Rule> getRules(String username) {
        return this.hibernate.session().createQuery("from Rule where username=:username or username='everyone'").setParameter("username", (Object)username).list();
    }

    public List<Rule> getRules(UUID sessionId) {
        return this.hibernate.session().createQuery("from Rule where sessionId=:sessionId").setParameter("sessionId", (Object)sessionId).list();
    }

    public Response getRules() {
        StreamingOutput stream = new StreamingOutput(){

            public void write(final OutputStream output) {
                RuleTable.this.hibernate.runInTransaction(new HibernateUtil.HibernateRunnable<Void>(){

                    @Override
                    public Void run(org.hibernate.Session hibernateSession) {
                        try {
                            Query query = hibernateSession.createQuery("from Rule");
                            query.setReadOnly(true);
                            ScrollableResults results = query.scroll(ScrollMode.FORWARD_ONLY);
                            JsonGenerator jg = RestUtils.getObjectMapper().getFactory().createGenerator(output, JsonEncoding.UTF8);
                            jg.writeStartArray();
                            while (results.next()) {
                                Rule row = (Rule)results.get()[0];
                                jg.writeObject((Object)row);
                                jg.flush();
                            }
                            results.close();
                            jg.writeEndArray();
                            jg.flush();
                            jg.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            logger.error((Object)e);
                            throw new RuntimeException(e);
                        }
                        return null;
                    }
                });
            }
        };
        return Response.ok().entity((Object)stream).type("application/json").build();
    }

    public Session getSession(UUID sessionId) {
        return (Session)this.hibernate.session().get(Session.class, (Serializable)sessionId);
    }

    public Rule getRule(String username, Session session, org.hibernate.Session hibernateSession) {
        if (this.servicesAccounts.contains(username)) {
            return new Rule(username, true, null);
        }
        List auths = hibernateSession.createQuery("from Rule where (username=:username or username='everyone') and session=:session").setParameter("username", (Object)username).setParameter("session", (Object)session).list();
        if (auths.isEmpty()) {
            return null;
        }
        if (auths.size() == 1) {
            return (Rule)auths.get(0);
        }
        for (Rule auth : auths) {
            if (!auth.isReadWrite()) continue;
            return auth;
        }
        return (Rule)auths.get(0);
    }

    public void save(Rule auth, org.hibernate.Session hibernateSession) {
        logger.debug("save rule " + auth.getUsername());
        hibernateSession.save((Object)auth);
    }

    public void checkAuthorizationWithToken(String userToken, UUID sessionId, UUID datasetId, boolean requireReadWrite) {
        try {
            String username = this.tokenRequestFilter.tokenAuthentication(userToken).getName();
            this.checkAuthorization(username, sessionId, datasetId, requireReadWrite);
        }
        catch (NotFoundException e) {
            if (requireReadWrite) {
                throw new ForbiddenException((Throwable)e);
            }
            this.datasetTokenTable.checkAuthorization(UUID.fromString(userToken), sessionId, datasetId);
        }
    }

    public Dataset checkAuthorization(String username, UUID sessionId, UUID datasetId, boolean requireReadWrite) {
        Session session = this.checkAuthorization(username, sessionId, requireReadWrite, this.hibernate.session());
        Dataset dataset = session.getDatasets().get(datasetId);
        if (dataset == null) {
            throw new NotFoundException("dataset not found");
        }
        return dataset;
    }

    public Session getSessionForReading(SecurityContext sc, UUID sessionId) {
        return this.checkAuthorization(sc.getUserPrincipal().getName(), sessionId, false);
    }

    public Session getSessionForWriting(SecurityContext sc, UUID sessionId) {
        return this.checkAuthorization(sc.getUserPrincipal().getName(), sessionId, true);
    }

    public void setRuleRemovedListener(SessionResource sessionResource) {
        this.ruleRemovedListener = sessionResource;
    }
}

