/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.sessiondb.resource;

import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fi.csc.chipster.auth.resource.AuthPrincipal;
import fi.csc.chipster.rest.RestUtils;
import fi.csc.chipster.rest.hibernate.HibernateUtil;
import fi.csc.chipster.rest.hibernate.Transaction;
import fi.csc.chipster.sessiondb.model.Dataset;
import fi.csc.chipster.sessiondb.model.DatasetToken;
import fi.csc.chipster.sessiondb.model.File;
import fi.csc.chipster.sessiondb.model.Session;
import fi.csc.chipster.sessiondb.model.SessionEvent;
import fi.csc.chipster.sessiondb.resource.SessionResource;
import java.io.Serializable;
import java.net.URI;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SessionDatasetResource {
    public static final String QUERY_PARAM_READ_WRITE = "read-write";
    private static Logger logger = LogManager.getLogger();
    private final UUID sessionId;
    private SessionResource sessionResource;

    public SessionDatasetResource() {
        this.sessionId = null;
    }

    public SessionDatasetResource(SessionResource sessionResource, UUID id) {
        this.sessionResource = sessionResource;
        this.sessionId = id;
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"application/json"})
    @Transaction
    public Response get(@PathParam(value="id") UUID datasetId, @QueryParam(value="read-write") boolean requireReadWrite, @Context SecurityContext sc) {
        String userToken = ((AuthPrincipal)sc.getUserPrincipal()).getTokenKey();
        this.sessionResource.getRuleTable().checkAuthorizationWithToken(userToken, this.sessionId, datasetId, requireReadWrite);
        Dataset result = this.getDataset(datasetId, this.getHibernate().session());
        if (result == null) {
            throw new NotFoundException();
        }
        return Response.ok((Object)result).build();
    }

    public Dataset getDataset(UUID datasetId, org.hibernate.Session hibernateSession) {
        return (Dataset)hibernateSession.get(Dataset.class, (Serializable)datasetId);
    }

    @GET
    @RolesAllowed(value={"client", "server"})
    @Produces(value={"application/json"})
    @Transaction
    public Response getAll(@Context SecurityContext sc) {
        Collection<Dataset> result = this.sessionResource.getRuleTable().getSessionForReading(sc, this.sessionId).getDatasets().values();
        return Response.ok(SessionDatasetResource.toJaxbList(result)).build();
    }

    @POST
    @RolesAllowed(value={"client", "server"})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Transaction
    public Response post(Dataset dataset, @Context UriInfo uriInfo, @Context SecurityContext sc) {
        if (dataset.getDatasetId() != null) {
            throw new BadRequestException("dataset already has an id, post not allowed");
        }
        UUID id = RestUtils.createUUID();
        dataset.setDatasetId(id);
        Session session = this.sessionResource.getRuleTable().getSessionForWriting(sc, this.sessionId);
        dataset.setSession(session);
        if (dataset.getCreated() == null) {
            dataset.setCreated(LocalDateTime.now());
        }
        this.create(dataset, this.getHibernate().session());
        URI uri = uriInfo.getAbsolutePathBuilder().path(id.toString()).build(new Object[0]);
        ObjectNode json = new JsonNodeFactory(false).objectNode();
        json.put("datasetId", id.toString());
        return Response.created((URI)uri).entity((Object)json).build();
    }

    public void create(Dataset dataset, org.hibernate.Session hibernateSession) {
        this.checkFileModification(dataset, hibernateSession);
        if (dataset.getFile() != null) {
            hibernateSession.save((Object)dataset.getFile());
        }
        hibernateSession.save((Object)dataset);
        this.sessionResource.publish(this.sessionId.toString(), new SessionEvent(this.sessionId, SessionEvent.ResourceType.DATASET, dataset.getDatasetId(), SessionEvent.EventType.CREATE), hibernateSession);
    }

    private void checkFileModification(Dataset dataset, org.hibernate.Session hibernateSession) {
        if (dataset.getFile() == null || dataset.getFile().isEmpty()) {
            return;
        }
        File dbFile = (File)hibernateSession.get(File.class, (Serializable)dataset.getFile().getFileId());
        if (dbFile != null) {
            if (!dbFile.equals(dataset.getFile())) {
                throw new ForbiddenException("modification of existing file is forbidden");
            }
            dataset.setFile(dbFile);
        }
    }

    @PUT
    @RolesAllowed(value={"client", "server"})
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @Transaction
    public Response put(Dataset requestDataset, @PathParam(value="id") UUID datasetId, @Context SecurityContext sc) {
        requestDataset.setDatasetId(datasetId);
        Session session = this.sessionResource.getRuleTable().getSessionForWriting(sc, this.sessionId);
        Dataset dbDataset = (Dataset)this.getHibernate().session().get(Dataset.class, (Serializable)datasetId);
        if (dbDataset == null || dbDataset.getSession().getSessionId() != session.getSessionId()) {
            throw new NotFoundException("dataset doesn't exist");
        }
        if (!sc.isUserInRole("file-broker")) {
            this.checkFileModification(requestDataset, this.getHibernate().session());
        }
        if (requestDataset.getFile() == null || requestDataset.getFile().isEmpty()) {
            requestDataset.setFile(dbDataset.getFile());
        }
        requestDataset.setSession(session);
        this.update(requestDataset, this.getHibernate().session());
        return Response.noContent().build();
    }

    public void update(Dataset dataset, org.hibernate.Session hibernateSession) {
        hibernateSession.merge((Object)dataset);
        this.sessionResource.publish(this.sessionId.toString(), new SessionEvent(this.sessionId, SessionEvent.ResourceType.DATASET, dataset.getDatasetId(), SessionEvent.EventType.UPDATE), hibernateSession);
    }

    @DELETE
    @RolesAllowed(value={"client", "server"})
    @Path(value="{id}")
    @Transaction
    public Response delete(@PathParam(value="id") UUID datasetId, @Context SecurityContext sc) {
        Session session = this.sessionResource.getRuleTable().getSessionForWriting(sc, this.sessionId);
        Dataset dataset = (Dataset)this.sessionResource.getHibernate().session().get(Dataset.class, (Serializable)datasetId);
        if (dataset == null || dataset.getSession().getSessionId() != session.getSessionId()) {
            throw new NotFoundException("dataset not found");
        }
        this.deleteDataset(dataset, this.getHibernate().session());
        return Response.noContent().build();
    }

    public void deleteDataset(Dataset dataset, org.hibernate.Session hibernateSession) {
        int rows = this.getHibernate().session().createQuery("delete from " + DatasetToken.class.getSimpleName() + " where dataset=:dataset").setParameter("dataset", (Object)dataset).executeUpdate();
        logger.debug("deleted " + rows + " dataset tokens");
        hibernateSession.delete((Object)dataset);
        if (dataset.getFile() != null && dataset.getFile().getFileId() != null) {
            UUID fileId = dataset.getFile().getFileId();
            List fileDatasets = hibernateSession.createQuery("from Dataset where file=:file").setParameter("file", (Object)dataset.getFile()).list();
            fileDatasets.remove(dataset);
            if (fileDatasets.isEmpty()) {
                this.sessionResource.publish("files", new SessionEvent(this.sessionId, SessionEvent.ResourceType.FILE, fileId, SessionEvent.EventType.DELETE), hibernateSession);
            }
        }
        this.sessionResource.publish(this.sessionId.toString(), new SessionEvent(this.sessionId, SessionEvent.ResourceType.DATASET, dataset.getDatasetId(), SessionEvent.EventType.DELETE), hibernateSession);
    }

    public static GenericEntity<Collection<Dataset>> toJaxbList(Collection<Dataset> result) {
        return new GenericEntity<Collection<Dataset>>(result){};
    }

    private HibernateUtil getHibernate() {
        return this.sessionResource.getHibernate();
    }
}

