/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.sessionworker;

import java.io.InputStream;
import java.util.concurrent.Callable;
import org.apache.commons.io.IOUtils;

public class InputStreamEntry {
    private String name;
    private Callable<InputStream> inputStreamCallable;
    private int compressionLevel;

    public InputStreamEntry(String name, String content) {
        this(name, InputStreamEntry.toCallable(content));
    }

    public InputStreamEntry(String name, Callable<InputStream> inputStreamCallable) {
        this(name, inputStreamCallable, 1);
    }

    public InputStreamEntry(String name, Callable<InputStream> inputStreamCallable, int compressionLevel) {
        this.name = name;
        this.inputStreamCallable = inputStreamCallable;
        this.compressionLevel = compressionLevel;
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public void setCompressionLevel(int compressionLevel) {
        this.compressionLevel = compressionLevel;
    }

    public Callable<InputStream> getInputStreamCallable() {
        return this.inputStreamCallable;
    }

    public void setInputStreamCallable(Callable<InputStream> inputStreamCallable) {
        this.inputStreamCallable = inputStreamCallable;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    private static Callable<InputStream> toCallable(final String str) {
        return new Callable<InputStream>(){

            @Override
            public InputStream call() throws Exception {
                return IOUtils.toInputStream((String)str);
            }
        };
    }
}

