/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.sessionworker;

import fi.csc.chipster.auth.resource.AuthPrincipal;
import fi.csc.chipster.filebroker.RestFileBrokerClient;
import fi.csc.chipster.rest.CredentialsProvider;
import fi.csc.chipster.rest.RestUtils;
import fi.csc.chipster.rest.StaticCredentials;
import fi.csc.chipster.rest.hibernate.Transaction;
import fi.csc.chipster.servicelocator.ServiceLocatorClient;
import fi.csc.chipster.sessiondb.RestException;
import fi.csc.chipster.sessiondb.SessionDbClient;
import fi.csc.chipster.sessiondb.model.Dataset;
import fi.csc.chipster.sessiondb.model.Input;
import fi.csc.chipster.sessiondb.model.Job;
import fi.csc.chipster.sessiondb.model.Session;
import fi.csc.chipster.sessionworker.ExtractedSession;
import fi.csc.chipster.sessionworker.InputStreamEntry;
import fi.csc.chipster.sessionworker.JsonSession;
import fi.csc.chipster.sessionworker.XmlSession;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Path(value="sessions")
public class SessionWorkerResource {
    private static Logger logger = LogManager.getLogger();
    private ServiceLocatorClient serviceLocator;

    public SessionWorkerResource(ServiceLocatorClient serviceLocator) {
        this.serviceLocator = serviceLocator;
    }

    @GET
    @Path(value="{sessionId}")
    @Produces(value={"application/octet-stream"})
    @Transaction
    public Response get(@PathParam(value="sessionId") UUID sessionId, @Context SecurityContext sc) throws IOException, RestException {
        StaticCredentials credentials = this.getUserCredentials(sc);
        RestFileBrokerClient fileBroker = new RestFileBrokerClient(this.serviceLocator, (CredentialsProvider)credentials);
        SessionDbClient sessionDb = new SessionDbClient(this.serviceLocator, credentials);
        ArrayList<InputStreamEntry> entries = new ArrayList<InputStreamEntry>();
        Session session = sessionDb.getSession(sessionId);
        JsonSession.packageSession(sessionDb, fileBroker, session, sessionId, entries);
        Response.ResponseBuilder response = Response.ok((Object)this.getZipStreamingOuput(entries));
        RestUtils.configureForDownload(response, session.getName() + ".zip");
        return response.build();
    }

    private StreamingOutput getZipStreamingOuput(final ArrayList<InputStreamEntry> entries) {
        return new StreamingOutput(){

            public void write(OutputStream output) throws IOException, WebApplicationException {
                try (ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(output, 0x200000));){
                    for (InputStreamEntry entry : entries) {
                        zos.putNextEntry(new ZipEntry(entry.getName()));
                        zos.setLevel(entry.getCompressionLevel());
                        try (InputStream entryStream = entry.getInputStreamCallable().call();){
                            IOUtils.copy((InputStream)entryStream, (OutputStream)zos);
                        }
                        zos.closeEntry();
                    }
                }
                catch (Exception e) {
                    logger.error("error in copying dataset input stream to zip output stream", (Throwable)e);
                    throw new InternalServerErrorException("error in copying dataset input stream to zip output stream");
                }
            }
        };
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="{sessionId}/datasets/{datasetId}")
    @Transaction
    public Response post(final @PathParam(value="sessionId") UUID sessionId, final @PathParam(value="datasetId") UUID zipDatasetId, @Context SecurityContext sc) throws RestException, IOException {
        StaticCredentials credentials = this.getUserCredentials(sc);
        final RestFileBrokerClient fileBroker = new RestFileBrokerClient(this.serviceLocator, (CredentialsProvider)credentials);
        final SessionDbClient sessionDb = new SessionDbClient(this.serviceLocator, credentials);
        return Response.ok((Object)new StreamingOutput(){
            private CountDownLatch latch = new CountDownLatch(1);

            public void write(final OutputStream output) throws IOException, WebApplicationException {
                try {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                String spaces = " ";
                                for (int i = 0; i < 10; ++i) {
                                    spaces = spaces + spaces;
                                }
                                spaces = spaces + "\n";
                                while (!latch.await(1L, TimeUnit.SECONDS)) {
                                    output.write(spaces.getBytes());
                                    output.flush();
                                }
                            }
                            catch (IOException | InterruptedException e) {
                                logger.error("error in keep-alive thread", (Throwable)e);
                            }
                        }
                    }).start();
                    ExtractedSession sessionData = JsonSession.extractSession(fileBroker, sessionDb, sessionId, zipDatasetId);
                    if (sessionData == null) {
                        sessionData = XmlSession.extractSession(fileBroker, sessionDb, sessionId, zipDatasetId);
                    }
                    if (sessionData == null) {
                        throw new BadRequestException("unrecognized file format");
                    }
                    ArrayList warnings = SessionWorkerResource.this.updateSession(sessionDb, sessionId, sessionData);
                    HashMap<String, ArrayList> response = new HashMap<String, ArrayList>();
                    response.put("warnings", warnings);
                    this.latch.countDown();
                    output.write(RestUtils.asJson(warnings).getBytes());
                    output.close();
                }
                catch (RestException e) {
                    this.latch.countDown();
                    logger.error("session extraction failed", (Throwable)e);
                }
            }
        }).build();
    }

    private ArrayList<String> updateSession(SessionDbClient sessionDb, UUID sessionId, ExtractedSession extractedSession) throws RestException {
        UUID newId;
        UUID oldId;
        Session session = extractedSession.getSession();
        Collection<Dataset> datasets = session.getDatasets().values();
        Collection<Job> jobs = session.getJobs().values();
        HashMap<UUID, UUID> datasetIdMap = extractedSession.getDatasetIdMap();
        HashMap<UUID, UUID> jobIdMap = new HashMap<UUID, UUID>();
        ArrayList<String> warnings = new ArrayList<String>();
        session.setSessionId(sessionId);
        sessionDb.updateSession(session);
        for (Job job : jobs) {
            oldId = job.getJobId();
            job.setJobId(null);
            for (Input input : job.getInputs()) {
                UUID newDatasetId = datasetIdMap.get(UUID.fromString(input.getDatasetId()));
                if (input.getDatasetId() != null && newDatasetId == null) {
                    warnings.add("input dataset of job " + job.getToolId() + " " + input.getInputId() + " missing");
                    continue;
                }
                input.setDatasetId(newDatasetId.toString());
            }
            newId = sessionDb.createJob(sessionId, job);
            jobIdMap.put(oldId, newId);
        }
        for (Dataset dataset : datasets) {
            oldId = dataset.getDatasetId();
            newId = datasetIdMap.get(oldId);
            if (newId == null) {
                warnings.add("dataset " + dataset.getName() + " missing");
            }
            dataset.setDatasetId(newId);
            UUID newSourceJobId = (UUID)jobIdMap.get(dataset.getSourceJob());
            if (dataset.getSourceJob() != null && newSourceJobId == null) {
                warnings.add("source job of dataset " + dataset.getName() + " missing");
            }
            dataset.setSourceJob(newSourceJobId);
            dataset.setFile(null);
            System.out.println("updating dataset " + oldId + " " + newId);
            sessionDb.updateDataset(sessionId, dataset);
        }
        return warnings;
    }

    private StaticCredentials getUserCredentials(SecurityContext sc) {
        String token = ((AuthPrincipal)sc.getUserPrincipal()).getTokenKey();
        return new StaticCredentials("token", token);
    }
}

