/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.toolbox;

import fi.csc.chipster.toolbox.SADLReplacements;
import fi.csc.chipster.toolbox.SADLTool;
import fi.csc.chipster.toolbox.Toolbox;
import fi.csc.chipster.toolbox.ToolboxTool;
import fi.csc.chipster.toolbox.toolpartsparser.ToolPartsParser;
import fi.csc.chipster.util.StringUtils;
import fi.csc.microarray.description.SADLDescription;
import fi.csc.microarray.description.SADLGenerator;
import fi.csc.microarray.description.SADLParser;
import fi.csc.microarray.description.SADLSyntax;
import fi.csc.microarray.messaging.message.ModuleDescriptionMessage;
import fi.csc.microarray.module.chipster.ChipsterSADLParser;
import fi.csc.microarray.util.XmlUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class ToolboxModule {
    private static final Logger logger = Logger.getLogger(ToolboxModule.class);
    private LinkedList<ToolboxCategory> categories = new LinkedList();
    private LinkedHashMap<String, ToolboxTool> tools = new LinkedHashMap();
    private List<ToolboxTool> toolsWithCustomRuntime = new LinkedList<ToolboxTool>();
    private Path moduleDir;
    private Path moduleFile;
    private String summary = null;
    private String moduleName = null;
    private SADLReplacements sadlReplacements;

    public ToolboxModule(Path moduleDir, Path moduleFile, File toolsBin) throws ParserConfigurationException, FileNotFoundException, SAXException, IOException {
        this.moduleFile = moduleFile;
        this.moduleDir = moduleDir;
        this.sadlReplacements = new SADLReplacements(toolsBin);
        this.load();
    }

    public ModuleDescriptionMessage getModuleDescriptionMessage() {
        ModuleDescriptionMessage msg = new ModuleDescriptionMessage(this.moduleName);
        for (ToolboxCategory toolboxCategory : this.categories) {
            ModuleDescriptionMessage.Category category = new ModuleDescriptionMessage.Category(toolboxCategory.getName(), toolboxCategory.getColor(), toolboxCategory.isHidden());
            for (ToolboxTool tool : toolboxCategory.getTools()) {
                category.addTool(tool.getSadlString(), null);
            }
            msg.addCategory(category);
        }
        return msg;
    }

    public ToolboxTool getTool(String id) {
        return this.tools.get(id);
    }

    public Collection<ToolboxTool> getAll() {
        return this.tools.values();
    }

    public String getSummary() {
        return this.summary;
    }

    private void load() throws FileNotFoundException, SAXException, IOException, ParserConfigurationException {
        Document document = XmlUtil.parseReader((Reader)Files.newBufferedReader(this.moduleFile));
        Element moduleElement = (Element)document.getElementsByTagName("module").item(0);
        this.moduleName = moduleElement.getAttribute("name");
        if (this.moduleName.isEmpty()) {
            this.summary = "not loading a module without a name";
            logger.warn((Object)this.summary);
            return;
        }
        int totalCount = 0;
        int successfullyLoadedCount = 0;
        int hiddenCount = 0;
        int disabledCount = 0;
        for (Element categoryElement : XmlUtil.getChildElements((Element)moduleElement, (String)"category")) {
            String categoryName = categoryElement.getAttribute("name");
            if (categoryName.isEmpty()) {
                logger.warn((Object)"not loading a category without a name");
                continue;
            }
            boolean categoryDisabled = categoryElement.getAttribute("disabled").equals("true");
            if (categoryDisabled) {
                logger.info((Object)("not loading category " + categoryName + ": disabled"));
                continue;
            }
            String categoryColor = categoryElement.getAttribute("color");
            if (categoryColor.isEmpty()) {
                logger.warn((Object)("not loading category " + categoryName + ": no color"));
                continue;
            }
            boolean categoryHidden = Boolean.valueOf(categoryElement.getAttribute("hidden"));
            ToolboxCategory category = new ToolboxCategory(categoryName, categoryColor, categoryHidden);
            this.categories.add(category);
            for (Element toolElement : XmlUtil.getChildElements((Element)categoryElement, (String)"tool")) {
                SADLDescription sadlDescription;
                SADLTool.ParsedScript parsedScript;
                ++totalCount;
                String toolId = toolElement.getTextContent().trim();
                if (toolId.isEmpty()) continue;
                boolean toolHidden = categoryHidden;
                String nonDefaultModuleName = toolElement.getAttribute("module");
                Path toolModuleDir = nonDefaultModuleName != null && !nonDefaultModuleName.equals("") ? this.moduleDir.getParent().resolve(nonDefaultModuleName) : this.moduleDir;
                boolean parametersOk = true;
                HashMap<String, String> parameters = new HashMap<String, String>();
                for (Element parameterElement : XmlUtil.getChildElements((Element)toolElement, (String)"parameter")) {
                    String parameterName = XmlUtil.getChildElement((Element)parameterElement, (String)"name").getTextContent().trim();
                    if (parameterName == null || parameterName.isEmpty()) {
                        logger.warn((Object)"parameter without a name");
                        parametersOk = false;
                        break;
                    }
                    String parameterValue = XmlUtil.getChildElement((Element)parameterElement, (String)"value").getTextContent().trim();
                    if (parameterValue == null) {
                        logger.warn((Object)"parameter without a value");
                        parametersOk = false;
                        break;
                    }
                    parameters.put(parameterName, parameterValue);
                }
                if (!parametersOk) {
                    logger.warn((Object)("not loading " + toolId + ": parameters not ok"));
                    continue;
                }
                ToolPartsParser partsParser = Toolbox.getToolPartsParser(toolId);
                if (partsParser == null) {
                    logger.warn((Object)("not loading " + toolId + ": no parser"));
                    continue;
                }
                try {
                    parsedScript = partsParser.parse(toolModuleDir, toolId);
                }
                catch (Exception e) {
                    logger.warn((Object)("loading " + toolId + " failed, parsing parts failed"), (Throwable)e);
                    continue;
                }
                try {
                    sadlDescription = new ChipsterSADLParser().parse(parsedScript.SADL);
                }
                catch (SADLParser.ParseException e) {
                    logger.warn((Object)("loading " + toolId + " failed, parsing sadl failed"), (Throwable)e);
                    continue;
                }
                String toolIdFromSadl = sadlDescription.getName().getID();
                if (!toolId.equals(toolIdFromSadl)) {
                    logger.warn((Object)("not loading " + toolId + " mismatching tool id from module file and sadl: " + toolId + " " + toolIdFromSadl));
                    continue;
                }
                String runtimeName = sadlDescription.getRuntime();
                if (runtimeName == null) {
                    runtimeName = Toolbox.getDefaultRuntime(toolId);
                }
                if (runtimeName == null) {
                    logger.warn((Object)("not loading " + toolId + " could not get runtime name"));
                }
                boolean filenamesOk = true;
                HashSet<String> uniqueNames = new HashSet<String>();
                ArrayList<String> allNames = new ArrayList<String>();
                for (SADLDescription.Input input : sadlDescription.getInputs()) {
                    allNames.add(input.getName().getID());
                }
                for (SADLDescription.Output output : sadlDescription.getOutputs()) {
                    allNames.add(output.getName().getID());
                }
                for (String name : allNames) {
                    if (name == null) continue;
                    if (uniqueNames.contains(name)) {
                        logger.warn((Object)("filename " + name + " isn't unique"));
                        filenamesOk = false;
                        continue;
                    }
                    uniqueNames.add(name);
                }
                if (!filenamesOk) {
                    logger.warn((Object)("not loading " + toolId + ": non-unique filename(s)"));
                    continue;
                }
                try {
                    for (SADLDescription.Parameter param : sadlDescription.getParameters()) {
                        if (param.getType() != SADLSyntax.ParameterType.ENUM) continue;
                        List<SADLDescription.Name> options = Arrays.asList(param.getSelectionOptions());
                        param.setSelectionOptions(this.sadlReplacements.processNames(options));
                        List<String> defaults = Arrays.asList(param.getDefaultValues());
                        param.setDefaultValues(this.sadlReplacements.processStrings(defaults));
                    }
                }
                catch (IOException e) {
                    logger.warn((Object)("not loading " + toolId + ": " + e.getMessage()));
                    continue;
                }
                String generatedSadl = null;
                try {
                    generatedSadl = SADLGenerator.generate((SADLDescription)sadlDescription);
                }
                catch (Exception e) {
                    logger.warn((Object)("not loading " + toolId + ": "), (Throwable)e);
                    continue;
                }
                ToolboxTool toolboxTool = new ToolboxTool(toolId, sadlDescription, generatedSadl, parsedScript.code, parsedScript.source, this.moduleDir.getFileName().toString(), runtimeName);
                this.tools.put(toolId, toolboxTool);
                ++successfullyLoadedCount;
                category.addTool(toolboxTool);
                String hiddenStatus = "";
                if (toolHidden) {
                    hiddenStatus = "HIDDEN";
                    ++hiddenCount;
                }
                if (sadlDescription.getRuntime() != null) {
                    this.toolsWithCustomRuntime.add(toolboxTool);
                }
                logger.debug((Object)String.format("loaded %s %s from %s %s", toolId, sadlDescription.getName().getDisplayName(), toolId, hiddenStatus));
            }
        }
        this.summary = "loaded " + this.moduleName + " " + successfullyLoadedCount + "/" + totalCount + " tools, " + disabledCount + " disabled, " + hiddenCount + " hidden";
        logger.info((Object)this.summary);
        if (!this.toolsWithCustomRuntime.isEmpty()) {
            logger.info((Object)"tools with custom runtime:");
            for (ToolboxTool tool : this.toolsWithCustomRuntime) {
                logger.info((Object)(tool.getId() + " " + tool.getRuntime()));
            }
        }
    }

    public String getName() {
        return this.moduleName;
    }

    public String getNamePretty() {
        if (this.moduleName.equals("ngs")) {
            return this.moduleName.toUpperCase();
        }
        return StringUtils.capitalizeFirstLetter((String)this.moduleName);
    }

    public List<ToolboxCategory> getCategories() {
        return this.categories;
    }

    public static class ToolboxCategory {
        private String name;
        private String color;
        private Boolean hidden;
        private List<ToolboxTool> tools = new LinkedList<ToolboxTool>();

        public ToolboxCategory(String name, String color, Boolean hidden) {
            this.name = name;
            this.color = color;
            this.hidden = hidden;
        }

        public String getName() {
            return this.name;
        }

        public String getColor() {
            return this.color;
        }

        public Boolean isHidden() {
            return this.hidden;
        }

        public void addTool(ToolboxTool tool) {
            this.tools.add(tool);
        }

        public List<ToolboxTool> getTools() {
            return this.tools;
        }
    }
}

