/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.web;

import fi.csc.chipster.auth.AuthenticationClient;
import fi.csc.chipster.rest.Config;
import fi.csc.chipster.rest.RestUtils;
import fi.csc.chipster.rest.StatusSource;
import fi.csc.chipster.servicelocator.ServiceLocatorClient;
import fi.csc.chipster.web.ForwardingResourceHandler;
import java.io.File;
import java.net.URI;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AllowSymLinkAliasChecker;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.glassfish.grizzly.http.server.HttpServer;

public class WebServer {
    private static final String INDEX_HTML = "index.html";
    private static final Logger logger = LogManager.getLogger();
    private Config config;
    private Server server;
    private ServiceLocatorClient serviceLocator;
    private AuthenticationClient authService;
    private HttpServer adminServer;

    public WebServer(Config config) {
        this.config = config;
    }

    public void start() throws Exception {
        String username = "web-server";
        String password = this.config.getPassword(username);
        this.serviceLocator = new ServiceLocatorClient(this.config);
        this.authService = new AuthenticationClient(this.serviceLocator, username, password);
        URI baseUri = URI.create(this.config.getBindUrl("web-server"));
        this.server = new Server();
        ServerConnector connector = new ServerConnector(this.server);
        connector.setPort(baseUri.getPort());
        connector.setHost(baseUri.getHost());
        this.server.addConnector((Connector)connector);
        String rootPath = this.config.getString("web-server-web-root-path");
        File root = new File(rootPath);
        logger.info("web root: " + root.getCanonicalPath());
        if (!root.exists()) {
            throw new IllegalArgumentException("web root " + rootPath + " doesn't exist");
        }
        ForwardingResourceHandler forwardingResourceHandler = new ForwardingResourceHandler();
        forwardingResourceHandler.setDirectoriesListed(false);
        forwardingResourceHandler.setWelcomeFiles(new String[]{INDEX_HTML});
        forwardingResourceHandler.setResourceBase(rootPath);
        ContextHandler contextHandler = new ContextHandler();
        contextHandler.setHandler((Handler)forwardingResourceHandler);
        contextHandler.addAliasCheck((ContextHandler.AliasCheck)new AllowSymLinkAliasChecker());
        File indexFile = new File(root, INDEX_HTML);
        if (!indexFile.exists()) {
            logger.warn("index.html " + indexFile + " doesn't exist");
        }
        HandlerList handlers = new HandlerList();
        handlers.setHandlers(new Handler[]{contextHandler, new DefaultHandler()});
        this.server.setHandler((Handler)handlers);
        StatusSource stats = RestUtils.createStatisticsListener(this.server);
        this.server.start();
        this.adminServer = RestUtils.startAdminServer("web-server", this.config, this.authService, stats);
    }

    public static void main(String[] args) throws Exception {
        WebServer service = new WebServer(new Config());
        RestUtils.shutdownGracefullyOnInterrupt(service.server, "web-server");
        service.start();
    }

    public void close() {
        RestUtils.shutdown("web-server-admin", this.adminServer);
        try {
            this.server.stop();
        }
        catch (Exception e) {
            logger.warn("failed to stop the web server", (Throwable)e);
        }
    }
}

