/*
 * seejpeg.h
 *
 * Copyright (C) 1993-1999 Evan Harris
 *
 * Permission is granted to freely redistribute and modify this code,
 * providing the author(s) get credit for having written it.
 */

/* 	$Id: seejpeg.h,v 1.8 1999/11/07 05:22:30 evan Exp $	 */

#include <stdlib.h>
#include <stdio.h>
#include <jpeglib.h>

typedef int bool;

/* display.c */
void chiptype_init(void);
void gamma_table_init(double gamma);
void display_init(int image_width, int image_height, int components);
void display_set_palette(int num_colors, JSAMPARRAY colormap, int components);
void display_set_greyscale_palette(void);
void display_rows(int num_rows,
		  JSAMPARRAY pixel_data,
		  int image_width,
		  int components);
void scroll_until_end(void);
void display_shutdown(void);
bool is_supported_256_mode(int mode);
bool is_supported_32k16m_mode(int mode);

/* image.c */
int read_image_file (char *filename);

/* jpeg.c */
int read_JPEG_file (char *filename);
void error_exit (const char *msgtext);
void trace_message (const char *msgtext);

/* cmap.c */
void translate_init(void);
void translate_row(int width, JSAMPARRAY rgb_row, JSAMPARRAY cmap_row);

/* variables */
extern int opt_greyscale;
extern int opt_onepass;
extern int opt_quantize;
extern int opt_verbose;
extern int opt_forcemode;
extern int opt_widthonly;
extern int opt_doublex;
extern int opt_doubley;
extern int opt_slideshow;
extern int opt_cycle;
extern int opt_centre;
extern int opt_maxwidth;
extern int opt_minwidth;
extern double opt_fuzz;
extern double opt_gamma;
extern int opt_enable_5x4;
extern int opt_enable_4x3;
extern int opt_enable_8x5;
extern int opt_enable_16x9;

#define NEXT_IMAGE 0
#define PREVIOUS_IMAGE 1
#define SAME_IMAGE 2
#define NO_IMAGE 3
extern int next_image;

#define GAMMA_TABLE_SIZE 256
extern unsigned int gamma_table[GAMMA_TABLE_SIZE];
extern unsigned int gamma_table_shift2[GAMMA_TABLE_SIZE];
extern unsigned int gamma_table_shift3[GAMMA_TABLE_SIZE];

/*
 * The video mode we test for to see if hicolor or truecolor modes are
 * available.
 *
 * If this mode is not available we assume that only colour mapped
 * (256 colour) modes are available and we automatically set two pass
 * quantization for the user.  Unfortunately, two pass quantization in
 * JPEG is a memory pig.
 */

#ifndef TESTMODE
#define TESTMODE G640x480x32K
#endif
