// UNSUPPORTED: target={{.*}}-zos{{.*}}, target={{.*}}-aix{{.*}}
@import DependsOnModule;

// RUN: rm -rf %t %t-obj %t-hash
// RUN: %clang_cc1 -w -Wunused -fmodules -fmodule-format=raw -fimplicit-module-maps -fdisable-module-hash -fmodules-cache-path=%t -F %S/Inputs -DBLARG -DWIBBLE=WOBBLE -fmodule-feature myfeature %s
// RUN: %clang_cc1 -module-file-info %t/DependsOnModule.pcm | FileCheck %s --check-prefixes=RAW,CHECK,MACROS

// RUN: %clang_cc1 -w -Wunused -fmodules -fmodule-format=obj -fimplicit-module-maps -fdisable-module-hash -fmodules-cache-path=%t-obj -F %S/Inputs -DBLARG -DWIBBLE=WOBBLE -fmodule-feature myfeature %s
// RUN: %clang_cc1 -module-file-info %t-obj/DependsOnModule.pcm | FileCheck %s --check-prefixes=OBJ,CHECK,MACROS

// RUN: %clang_cc1 -w -Wunused -fmodules -fmodule-format=obj -fimplicit-module-maps                       -fmodules-cache-path=%t-hash -F %S/Inputs -DBLARG -DWIBBLE=WOBBLE -fmodule-feature myfeature %s
// RUN: %clang_cc1 -module-file-info %t-hash/*/DependsOnModule-*.pcm | FileCheck %s --check-prefixes=OBJ,CHECK,NO_MACROS

// RAW:   Module format: raw
// OBJ:   Module format: obj
// CHECK: Generated by this Clang:

// CHECK: Module name: DependsOnModule
// CHECK: Module map file: {{.*}}DependsOnModule.framework{{[/\\]}}Modules{{[/\\]}}module.modulemap
// CHECK: Imports module 'Module': {{.*}}Module{{.*}}.pcm

// CHECK: Language options:
// CHECK:   C99: Yes
// CHECK:   Objective-C: Yes
// CHECK:   modules semantics: Yes
// CHECK:   Module features:
// CHECK:     myfeature

// CHECK: Target options:
// CHECK:     Triple:
// CHECK:     CPU:
// CHECK:     TuneCPU:
// CHECK:     ABI:

// CHECK: Header search options:
// CHECK:   System root [-isysroot=]: '/'
// CHECK:   Resource dir [ -resource-dir=]: '{{.*}}clang{{.*}}'
// CHECK:   Use builtin include directories [-nobuiltininc]: Yes
// CHECK:   Use standard system include directories [-nostdinc]: No
// CHECK:   Use standard C++ include directories [-nostdinc++]: Yes
// CHECK:   Use libc++ (rather than libstdc++) [-stdlib=]:

// CHECK: Preprocessor options:
// CHECK:   Uses compiler/target-specific predefines [-undef]: Yes
// CHECK:   Uses detailed preprocessing record (for indexing): No
// NO_MACROS-NOT: Predefined macros:
// MACROS:   Predefined macros:
// MACROS-NEXT: -DBLARG
// MACROS-NEXT: -DWIBBLE=WOBBLE
// CHECK: Input file: {{.*}}module.modulemap
// CHECK: Input file: {{.*}}module.private.modulemap
// CHECK: Input file: {{.*}}DependsOnModule.h
// CHECK: Input file: {{.*}}module.modulemap
// CHECK: Input file: {{.*}}other.h
// CHECK: Input file: {{.*}}not_cxx.h
// CHECK: Input file: {{.*}}not_coroutines.h
// CHECK: Input file: {{.*}}SubFramework.h
// CHECK: Input file: {{.*}}Other.h
// CHECK: Input file: {{.*}}DependsOnModulePrivate.h

// CHECK: Diagnostic options:
// CHECK:   IgnoreWarnings: Yes
// CHECK:   Diagnostic flags:
// CHECK:     -Wunused
