;; anthy-unicode-kyuri.el

;; Copyright (C) 2005
;; Author: Yukihiro Matsumoto <matz@ruby-lang.org>

(require 'anthy-unicode)

(setq anthy-kyuri-mode-hiragana-map
  '(
    ("bh" . "ぁ") ("h" . "あ") ("bk" . "ぃ") ("k" . "い") ("bj" . "ぅ")
    ("j" . "う") ("yj" . "う゛") ("yh" . "う゛ぁ") ("yk" . "う゛ぃ") ("y;" . "う゛ぇ") 
    ("yl" . "う゛ぉ") ("b;" . "ぇ") (";" . "え") ("bl" . "ぉ") ("l" . "お")
    ("dh" . "か") ("qh" . "が") ("dk" . "き") ("du" . "きゃ") ("di" . "きゅ") ("do" . "きょ")
    ("duu" . "きゃあ") ("dii" . "きゅう") ("doo" . "きょう")
    ("qk" . "ぎ") ("qu" . "ぎゃ") ("qi" . "ぎゅ") ("qo" . "ぎょ")
    ("quu" . "ぎゃあ") ("qii" . "ぎゅう") ("qoo" . "ぎょう")
    ("dj" . "く") ("qj" . "ぐ") ("d;" . "け") ("q;" . "げ") ("dl" . "こ") ("ql" . "ご")
    ("fh" . "さ") ("zh" . "ざ") ("fk" . "し")
    ("fu" . "しゃ") ("fi" . "しゅ") ("fo" . "しょ") ("fb;" . "しぇ")
    ("fuu" . "しゃあ") ("fii" . "しゅう") ("foo" . "しょう") 
    ("zk" . "じ") ("zu" . "じゃ") ("zi" . "じゅ") ("zo" . "じょ")
    ("zuu" . "じゃあ") ("zii" . "じゅう") ("zoo" . "じょう")
    ("fj" . "す") ("zj" . "ず") ("f;" . "せ") ("z;" . "ぜ") ("fl" . "そ") ("zl" . "ぞ")
    ("gh" . "た") ("vh" . "だ") ("gk" . "ち")
    ("gu" . "ちゃ") ("gi" . "ちゅ") ("go" . "ちょ") ("gb;" . "ちぇ")
    ("guu" . "ちゃあ") ("gii" . "ちゅう") ("goo" . "ちょう")
    ("vk" . "ぢ") ("vu" . "ぢゃ") ("vi" . "ぢゅ") ("vo" . "ぢょ") ("vb;" . "ぢぇ")
    ("vuu" . "ぢゃあ") ("vii" . "ぢゅう")
    ("voo" . "ぢょう") ("m" . "っ") ("ddh" . "っか") ("qqh" . "っが") ("ddk" . "っき")
    ("ddu" . "っきゃ") ("ddi" . "っきゅ") ("ddo" . "っきょ")
    ("dduu" . "っきゃあ") ("ddii" . "っきゅう") ("ddoo" . "っきょう")
    ("qqk" . "っぎ") ("qqu" . "っぎゃ") ("qqi" . "っぎゅ") ("qqo" . "っぎょ")
    ("qquu" . "っぎゃあ") ("qqii" . "っぎゅう") ("qqoo" . "っぎょう")
    ("ddj" . "っく") ("dd;" . "っけ") ("ddl" . "っこ")
    ("qqj" . "っぐ") ("qq;" . "っげ") ("qql" . "っご")
    ("ffh" . "っさ") ("zzh" . "っざ") ("ffk" . "っし")
    ("ffu" . "っしゃ") ("ffi" . "っしゅ") ("ffo" . "っしょ")
    ("ffuu" . "っしゃあ") ("ffii" . "っしゅう") ("ffoo" . "っしょう")
    ("zzk" . "っじ")
    ("zzu" . "っじゃ") ("zzi" . "っじゅ") ("zzo" . "っじょ")
    ("zzuu" . "っじゃあ") ("zzii" . "っじゅう") ("zzoo" . "っじょう")
    ("ffj" . "っす") ("zzj" . "っず") ("ff;" . "っせ") ("zz;" . "っぜ") ("ffl" . "っそ")
    ("zzl" . "っぞ") ("ggh" . "った") ("vvh" . "っだ") ("ggk" . "っち")
    ("ggu" . "っちゃ") ("ggi" . "っちゅ") ("ggo" . "っちょ") ("ggb;" . "っちぇ") 
    ("gguu" . "っちゃあ") ("ggii" . "っちゅう") ("ggoo" . "っちょう")
    ("vvk" . "っぢ")
    ("vvu" . "っぢゃ") ("vvi" . "っぢゅ") ("vvoo" . "っぢょ")
    ("vvuu" . "っぢゃあ") ("vvii" . "っぢゅう") ("vvoo" . "っぢょう")
    ("ggj" . "っつ") ("gg;" . "って") ("ggl" . "っと") 
    ("vvj" . "っづ") ("vv;" . "っで") ("vvl" . "っど")
    ("ssh" . "っは") ("cch" . "っば") ("tth" . "っぱ")
    ("ttk" . "っひ")
    ("ssu" . "っひゃ") ("ssi" . "っひゅ") ("sso" . "っひょ")
    ("ssuu" . "っひゃあ") ("ssii" . "っひゅう") ("ssoo" . "っひょう")
    ("cck" . "っび")
    ("ccu" . "っびゃ") ("ccii" . "っびゅ") ("cco" . "っびょ")
    ("ccuu" . "っびゃあ") ("ccii" . "っびゅう") ("ccoo" . "っびょう")
    ("ttk" . "っぴ")
    ("ttu" . "っぴゃ") ("tti" . "っぴゅ") ("tto" . "っぴょ")
    ("ttuu" . "っぴゃあ") ("ttii" . "っぴゅう") ("ttoo" . "っぴょう")
    ("ssj" . "っふ")
    ("ssbh" . "っふぁ") ("ssbk" . "っふぃ") ("ssb;" . "っふぇ") ("ssbl" . "っふぉ")
    ("ccj" . "っぶ") ("ttj" . "っぷ") ("ss;" . "っへ") ("cc;" . "っべ") ("tt;" . "っぺ")
    ("ssl" . "っほ") ("ccl" . "っぼ") ("ttl" . "っぽ") ("aah" . "っや") ("aaj" . "っゆ")
    ("yyo" . "っよ") ("rra" . "っら") ("rri" . "っり")
    ("rru" . "っりゃ") ("rri" . "っりゅ") ("rro" . "っりょ")
    ("rruu" . "っりゃあ") ("rrii" . "っりゅう") ("rroo" . "っりょう")
    ("rrj" . "っる") ("rr;" . "っれ") ("rrl" . "っろ")
    ("gj" . "つ") ("vj" . "づ") ("g;" . "て") ("v;" . "で")
    ("vbu" . "でゃ") ("vbk" . "でぃ") ("vbj" . "でゅ") ("vb;" . "でぇ") ("vbo" . "でょ")
    ("gbu" . "てゃ") ("gbk" . "てぃ") ("gbj" . "てゅ") ("gbo" . "てょ")
    ("gl" . "と") ("vl" . "ど") ("eh" . "な") ("ek" . "に")
    ("eu" . "にゃ") ("ei" . "にゅ") ("eo" . "にょ")
    ("euu" . "にゃあ") ("eii" . "にゅう") ("eoo" . "にょう")
    ("ej" . "ぬ") ("e;" . "ね") ("el" . "の")
    ("sh" . "は") ("ch" . "ば") ("th" . "ぱ") ("sk" . "ひ")
    ("su" . "ひゃ") ("si" . "ひゅ") ("so" . "ひょ") ("sb;" . "ひぇ")
    ("suu" . "ひゃあ") ("sii" . "ひゅう") ("soo" . "ひょう")
    ("ck" . "び")
    ("cu" . "びゃ") ("ci" . "びゅ") ("co" . "びょ") ("cb;" . "ひょ")
    ("cuu" . "びゃあ") ("cii" . "びゅう") ("coo" . "びょう")
    ("tk" . "ぴ")
    ("tu" . "ぴゃ") ("ti" . "ぴゅ") ("to" . "ぴょ") ("tb;" . "ぴぇ")
    ("tuu" . "ぴゃあ") ("tii" . "ぴゅう") ("too" . "ぴょう")
    ("sj" . "ふ")
    ("sbh" . "ふぁ") ("sbk" . "ふぃ") ("sbj" . "ふぅ") ("sb;" . "ふぇ") ("sbl" . "ふぉ")
    ("cj" . "ぶ")
    ("cbh" . "ぶぁ") ("cbk" . "ぶぃ") ("cbj" . "ぶぅ") ("cb;" . "ぶぇ") ("cbl" . "ぶぉ")
    ("tj" . "ぷ")
    ("tbh" . "ぷぁ") ("tbk" . "ぷぃ") ("tbj" . "ぷぅ") ("tb;" . "ぷぇ") ("tbl" . "ぷぉ")
    ("s;" . "へ") ("c;" . "べ") ("t;" . "ぺ")
    ("sl" . "ほ") ("cl" . "ぼ") ("tl" . "ぽ")
    ("wh" . "ま") ("wk" . "み")
    ("wu" . "みゃ") ("wi" . "みゅ") ("wo" . "みょ")
    ("wuu" . "みゃあ") ("wii" . "みゅう") ("woo" . "みょう")
    ("wj" . "む") ("w;" . "め") ("wl" . "も")
    ("u" . "ゃ") ("ah" . "や") ("i" . "ゅ") ("aj" . "ゆ") ("o" . "ょ")
    ("al" . "よ")
    ("rh" . "ら") ("rk" . "り")
    ("ru" . "りゃ") ("ri" . "りゅ") ("ro" . "りょ")
    ("ruu" . "りゃあ") ("rii" . "りゅう") ("roo" . "りょう")
    ("rj" . "る") ("r;" . "れ") ("rl" . "ろ")
    ("bxh" . "ゎ") ("xh" . "わ") ("xk" . "ゐ") ("x;" . "ゑ")
    ("xbk" . "うぃ") ("xb;" . "うぇ")
    ("xl" . "を") ("n" . "ん")
    ("p" . "ー") ("zb;" . "じぇ") 
    ("zp" . "〜") ("z/" . "・") ("zx" . "^^;;;")

    ("[" . "「") ("]" . "」") ("{" . "『") ("}" . "』")
    ("X1" . "○") ("X!" . "●") ("X2" . "▽") ("X@" . "▼") ("X3" . "△")
    ("X#" . "▲") ("X4" . "□") ("X$" . "■") ("X5" . "◇") ("X%" . "◆")
    ("X6" . "☆") ("X^" . "★") ("X7" . "◎") ("X&" . "£") ("X8" . "¢")
    ("X*" . "×") ("X9" . "♂") ("X(" . "【") ("X0" . "♀") ("X)" . "】")
    ("X-" . "〜") ("X_" . "∴") ("X=" . "≒") ("X+" . "±") ("X\\" . "＼")
    ("X|" . "‖") ("X\`" . "´") ("X~" . "¨") ("Xq" . "《") ("XQ" . "〈")
    ("Xw" . "》") ("XW" . "〉") ("Xe" . "々") ("XR" . "仝") ("Xt" . "〆")
    ("XT" . "§") ("Xp" . "〒") ("XP" . "↑") ("X[" . "『") ("X]" . "』")
    ("X{" . "〔") ("X}" . "〕") ("Xs" . "ヽ") ("XS" . "ヾ") ("Xd" . "ゝ")
    ("XD" . "ゞ") ("Xf" . "〃") ("XF" . "→") ("Xg" . "‐") ("Xj" . "↓")
    ("XG" . "―") ("Xh" . "←") ("Xk" . "↑") ("Xl" . "→") ("X:" . "゜")
    ("X\'" . "‘") ("X\"" . "“") ("Xx" . ":-") ("XX" . ":-)")
    ("Xc" . "〇") ("XC" . "℃") ("Xv" . "※") ("XV" . "÷") ("Xb" . "°")
    ("XB" . "←") ("Xn" . "′") ("XN" . "↓") ("Xっ" . "″") ("XM" . "〓")
    ("X," . "‥") ("X<" . "≦") ("X." . "…") ("X>" . "≧") ("X/" . "・")
    ("X?" . "∞") ("z1" . "○") ("z!" . "●") ("z2" . "▽") ("z@" . "▼")
    ("z3" . "△") ("z#" . "▲") ("z4" . "□") ("z$" . "■") ("z5" . "◇")
    ("z%" . "◆") ("z6" . "☆") ("z^" . "★") ("z7" . "◎") ("z&" . "£")
    ("z8" . "¢") ("z*" . "×") ("z9" . "♂") ("z(" . "【") ("z0" . "♀")
    ("z)" . "】") ("zp" . "〜") ("z_" . "∴") ("z=" . "≠") ("z+" . "±")
    ("z\\" . "＼") ("z|" . "‖") ("z\`" . "´") ("z~" . "¨") ("z:" . "゜")
    ("z\'" . "‘") ("z\"" . "“") ("z," . "‥") ("z<" . "≦") ("z." . "…")
    ("z>" . "≧") ("z/" . "・") ("z?" . "∞") ("z[" . "『") ("z]" . "』")
    ("z{" . "〔") ("z}" . "〕") ("zx" . "^^;;;") ("zX" . "(^^)") ("zs" . "　") 
    ("@ " . "　") ("@/" . "／") ("@\\" . "＼") ("@@" . "＠") ("@," . "，")
    ("@." . "．") ("@~" . "〜") ("@-" . "―") ("@||" . "‖") ("@|" . "｜")
    ("@\"" . "〃") ("@*" . "×") ("@=" . "〓") ("@3" . "…") ("@2" . "‥")
    ("@0" . "○") ("@[" . "［") ("@]" . "］") ("@{" . "｛") ("@}" . "｝")
    ("@<" . "《") ("@>" . "》")

    ("Z0" . "０") ("Z1" . "１") ("Z2" . "２") ("Z3" . "３") ("Z4" . "４")
    ("Z5" . "５") ("Z6" . "６") ("Z7" . "７") ("Z8" . "８") ("Z9" . "９")
    ("ZA" . "Ａ") ("ZB" . "Ｂ") ("ZC" . "Ｃ") ("ZD" . "Ｄ") ("ZE" . "Ｅ") ("ZF" . "Ｆ")
    ("ZG" . "Ｇ") ("ZH" . "Ｈ") ("ZI" . "Ｉ") ("ZJ" . "Ｊ") ("ZK" . "Ｋ") ("ZL" . "Ｌ")
    ("ZM" . "Ｍ") ("ZN" . "Ｎ") ("ZO" . "Ｏ") ("ZP" . "Ｐ") ("ZQ" . "Ｑ") ("ZR" . "Ｒ")
    ("ZS" . "Ｓ") ("ZT" . "Ｔ") ("ZU" . "Ｕ") ("ZV" . "Ｖ") ("ZW" . "Ｗ") ("ZX" . "Ｘ")
    ("ZY" . "Ｙ") ("ZZ" . "Ｚ")
    ("Za" . "ａ") ("Zb" . "ｂ") ("Zc" . "ｃ") ("Zd" . "ｄ") ("Ze" . "ｅ") ("Zf" . "ｆ")
    ("Zg" . "ｇ") ("Zh" . "ｈ") ("Zi" . "ｉ") ("Zj" . "ｊ") ("Zk" . "ｋ") ("Zl" . "ｌ")
    ("Zm" . "ｍ") ("Zn" . "ｎ") ("Zo" . "ｏ") ("Zp" . "ｐ") ("Zq" . "ｑ") ("Zr" . "ｒ")
    ("Zs" . "ｓ") ("Zt" . "ｔ") ("Zu" . "ｕ") ("Zv" . "ｖ") ("Zw" . "ｗ") ("Zx" . "ｘ")
    ("Zy" . "ｙ") ("Zz" . "ｚ")
    ("Z!" . "！") ("Z@" . "＠") ("Z#" . "＃") ("Z$" . "＄") ("Z%" . "％")
    ("Z^" . "＾") ("Z&" . "＆") ("Z*" . "＊") ("Z(" . "（") ("Z)" . "）") ("Z-" . "−")
    ("Z=" . "＝") ("Z`" . "｀") ("Z\\" . "￥") ("Z|" . "｜") ("Z_" . "＿") ("Z+" . "＋")
    ("Z~" . "￣") ("Z[" . "［") ("Z]" . "］") ("Z{" . "｛") ("Z}" . "｝") ("Z:" . "：")
    ("Z;" . "；") ("Z\"" . "”") ("Z\\'" . "’") ("Z<" . "＜") ("Z>" . "＞") ("Z?" . "？")
    ("Z/" . "／") ("Z," . "，") ("Z." . "．")

    ("!" . "!") ("\"" . "\"") ("#" . "#") ("$" . "$") ("%" . "%") ("&" . "&")
    ("'" . "'") ("(" . "(") (")" . ")") ("|" . "|")
    ("*" . "*") ("+" . "+") ("`" . "`") ("-" . "-") ("/" . "/")
    (":" . ":") ("<" . "<") ("=" . "=") (">" . ">") ("@" . "@")
    ("0" . "0") ("1" . "1") ("2" . "2") ("3" . "3") ("4" . "4")
    ("5" . "5") ("6" . "6") ("7" . "7") ("8" . "8") ("9" . "9")
    ))

;;
;; toggleの変更
;;
(defun anthy-send-change-toggle-command (str)
  (anthy-send-recv-command
   (concat " CHANGE_TOGGLE ~\n")))

(defun anthy-kyuri ()
  (setq anthy-rkmap-keybind nil)
  (anthy-send-recv-command " SET_PREEDIT_MODE 0\n")
  (anthy-set-break-into-roman t)
  (anthy-send-change-toggle-command "~")
  (anthy-clear-map)
  (mapcar (lambda (x)
	    (anthy-change-hiragana-map (car x) (cdr x)))
	  anthy-kyuri-mode-hiragana-map)
  )

(define-key anthy-mode-map (char-to-string 10) 'newline-and-indent)
(define-key anthy-mode-map (char-to-string 17) 'quoted-insert)

(anthy-kyuri)

(defun anthy-on ()
  (interactive)
  (anthy-mode-on))

(defun anthy-off ()
  (interactive)
  (anthy-mode-off))

(defun anthy-force-off ()
  (interactive)
  (anthy-handle-normal-key "(enter)")
  (anthy-off))

(global-set-key "\C-o" 'anthy-on)
(global-set-key "\C-z" 'anthy-off)
(global-set-key "\C-c\C-t" 'anthy-add-word-interactive)
(define-key anthy-preedit-keymap "\C-z" 'anthy-force-off)
(setq anthy-wide-space " ")
(setq anthy-use-hankaku-kana nil)


