// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py
// RUN: %clang_cc1 -emit-llvm -triple powerpc64-unknown-unknown \
// RUN:   -std=c++20 %s -o - -debug-info-kind=limited | FileCheck %s
// RUN: %clang_cc1 -emit-llvm -triple powerpc64le-unknown-unknown \
// RUN:   -std=c++20 %s -o - -debug-info-kind=limited | FileCheck %s

#include <stdarg.h>

static __ibm128 sgf;
__ibm128 arrgf[10];
__ibm128 func1(__ibm128 arg);

class CTest {
  __ibm128 pf;
  static const __ibm128 scf;
  volatile __ibm128 vf;

public:
  CTest(__ibm128 arg) : pf(arg), vf(arg) {}
  __ibm128 func2(__ibm128 arg) {
    return pf + arg;
  }
  static __ibm128 func3(__ibm128 arg) {
    return arg * CTest::scf;
  }
};

constexpr __ibm128 func_add(__ibm128 a, __ibm128 b) {
  return a + b;
}

constinit const __ibm128 ci = func_add(1.0, 2.0);
__ibm128 gf = ci;

__ibm128 func_arith(__ibm128 a, __ibm128 b, __ibm128 c) {
  __ibm128 v1 = a + b;
  __ibm128 v2 = a - c;
  __ibm128 v3 = v1 * c;
  __ibm128 v4 = v2 / v3;
  return v4;
}

__ibm128 func_vaarg(int n, ...) {
  va_list ap;
  va_start(ap, n);
  __ibm128 r = va_arg(ap, __ibm128);
  va_end(ap);
  return r;
}

template <typename T> struct T1 {
  T mem1;
};
template <> struct T1<__ibm128> {
  __ibm128 mem2;
};

template <__ibm128 Q> struct T2 {
  constexpr static __ibm128 mem = Q;
};

typedef float w128ibm __attribute__((mode(IF)));
typedef _Complex float w128ibm_c __attribute__((mode(IC)));

w128ibm icmode_self(w128ibm x) { return x; }
w128ibm_c icmode_self_complex(w128ibm_c x) { return x; }

int main(void) {
  __ibm128 lf;
  CTest ct(lf);
  T1<__ibm128> tf;
  __ibm128 lfi = tf.mem2 + func1(lf) - CTest::func3(lf);
}

// CHECK: %class.CTest = type { ppc_fp128, ppc_fp128 }
// CHECK: %struct.T1 = type { ppc_fp128 }

// CHECK: @arrgf = global [10 x ppc_fp128] zeroinitializer, align 16
// CHECK: @gf = global ppc_fp128 0xM40080000000000000000000000000000, align 16
// CHECK: @_ZN5CTest3scfE = external constant ppc_fp128, align 16

// CHECK: define dso_local noundef ppc_fp128 @_Z10func_arithggg(ppc_fp128 noundef %a, ppc_fp128 noundef %b, ppc_fp128 noundef %c)
// CHECK: entry:
// CHECK:   store ppc_fp128 %a, ptr %a.addr, align 16
// CHECK:   store ppc_fp128 %b, ptr %b.addr, align 16
// CHECK:   store ppc_fp128 %c, ptr %c.addr, align 16
// CHECK:   %0 = load ppc_fp128, ptr %a.addr, align 16
// CHECK:   %1 = load ppc_fp128, ptr %b.addr, align 16
// CHECK:   %add = fadd ppc_fp128 %0, %1
// CHECK:   store ppc_fp128 %add, ptr %v1, align 16
// CHECK:   %2 = load ppc_fp128, ptr %a.addr, align 16
// CHECK:   %3 = load ppc_fp128, ptr %c.addr, align 16
// CHECK:   %sub = fsub ppc_fp128 %2, %3
// CHECK:   store ppc_fp128 %sub, ptr %v2, align 16
// CHECK:   %4 = load ppc_fp128, ptr %v1, align 16
// CHECK:   %5 = load ppc_fp128, ptr %c.addr, align 16
// CHECK:   %mul = fmul ppc_fp128 %4, %5
// CHECK:   store ppc_fp128 %mul, ptr %v3, align 16
// CHECK:   %6 = load ppc_fp128, ptr %v2, align 16
// CHECK:   %7 = load ppc_fp128, ptr %v3, align 16
// CHECK:   %div = fdiv ppc_fp128 %6, %7
// CHECK:   store ppc_fp128 %div, ptr %v4, align 16
// CHECK:   %8 = load ppc_fp128, ptr %v4, align 16
// CHECK:   ret ppc_fp128 %8
// CHECK: }

// CHECK: define dso_local noundef ppc_fp128 @_Z10func_vaargiz(i32 noundef signext %n, ...)
// CHECK: entry:
// CHECK:   store i32 %n, ptr %n.addr, align 4
// CHECK:   call void @llvm.va_start.p0(ptr %ap)
// CHECK:   %argp.cur = load ptr, ptr %ap, align 8
// CHECK:   %argp.next = getelementptr inbounds i8, ptr %argp.cur, i64 16
// CHECK:   store ptr %argp.next, ptr %ap, align 8
// CHECK:   %0 = load ppc_fp128, ptr %argp.cur, align 8
// CHECK:   store ppc_fp128 %0, ptr %r, align 16
// CHECK:   call void @llvm.va_end.p0(ptr %ap)
// CHECK:   %1 = load ppc_fp128, ptr %r, align 16
// CHECK:   ret ppc_fp128 %1
// CHECK: }

// CHECK: define dso_local noundef ppc_fp128 @_Z11icmode_selfg(ppc_fp128 noundef %x)
// CHECK: define dso_local noundef { ppc_fp128, ppc_fp128 } @_Z19icmode_self_complexCg(ppc_fp128 noundef %x.coerce0, ppc_fp128 noundef %x.coerce1)

// CHECK: define dso_local noundef signext i32 @main()
// CHECK: entry:
// CHECK:   %0 = load ppc_fp128, ptr %lf, align 16
// CHECK:   call void @_ZN5CTestC1Eg(ptr noundef nonnull align 16 dereferenceable(32) %ct, ppc_fp128 noundef %0)
// CHECK:   %mem2 = getelementptr inbounds nuw %struct.T1, ptr %tf, i32 0, i32 0
// CHECK:   %1 = load ppc_fp128, ptr %mem2, align 16
// CHECK:   %2 = load ppc_fp128, ptr %lf, align 16
// CHECK:   %call = call noundef ppc_fp128 @_Z5func1g(ppc_fp128 noundef %2)
// CHECK:   %add = fadd ppc_fp128 %1, %call
// CHECK:   %3 = load ppc_fp128, ptr %lf, align 16
// CHECK:   %call1 = call noundef ppc_fp128 @_ZN5CTest5func3Eg(ppc_fp128 noundef %3)
// CHECK:   %sub = fsub ppc_fp128 %add, %call1
// CHECK:   store ppc_fp128 %sub, ptr %lfi, align 16
// CHECK:   ret i32 0
// CHECK: }

// CHECK: define linkonce_odr void @_ZN5CTestC1Eg(ptr noundef nonnull align 16 dereferenceable(32) %this, ppc_fp128 noundef %arg)
// CHECK: entry:
// CHECK:   store ptr %this, ptr %this.addr, align 8
// CHECK:   store ppc_fp128 %arg, ptr %arg.addr, align 16
// CHECK:   %this1 = load ptr, ptr %this.addr, align 8
// CHECK:   %0 = load ppc_fp128, ptr %arg.addr, align 16
// CHECK:   call void @_ZN5CTestC2Eg(ptr noundef nonnull align 16 dereferenceable(32) %this1, ppc_fp128 noundef %0)
// CHECK:   ret void
// CHECK: }

// CHECK: define linkonce_odr noundef ppc_fp128 @_ZN5CTest5func3Eg(ppc_fp128 noundef %arg)
// CHECK: entry:
// CHECK:   %arg.addr = alloca ppc_fp128, align 16
// CHECK:   store ppc_fp128 %arg, ptr %arg.addr, align 16
// CHECK:   %0 = load ppc_fp128, ptr %arg.addr, align 16
// CHECK:   %1 = load ppc_fp128, ptr @_ZN5CTest3scfE, align 16
// CHECK:   %mul = fmul ppc_fp128 %0, %1
// CHECK:   ret ppc_fp128 %mul
// CHECK: }

// CHECK: define linkonce_odr void @_ZN5CTestC2Eg(ptr noundef nonnull align 16 dereferenceable(32) %this, ppc_fp128 noundef %arg)
// CHECK: entry:
// CHECK:   store ptr %this, ptr %this.addr, align 8
// CHECK:   store ppc_fp128 %arg, ptr %arg.addr, align 16
// CHECK:   %this1 = load ptr, ptr %this.addr, align 8
// CHECK:   %pf = getelementptr inbounds nuw %class.CTest, ptr %this1, i32 0, i32 0
// CHECK:   %0 = load ppc_fp128, ptr %arg.addr, align 16
// CHECK:   store ppc_fp128 %0, ptr %pf, align 16
// CHECK:   %vf = getelementptr inbounds nuw %class.CTest, ptr %this1, i32 0, i32 1
// CHECK:   %1 = load ppc_fp128, ptr %arg.addr, align 16
// CHECK:   store volatile ppc_fp128 %1, ptr %vf, align 16
// CHECK:   ret void
// CHECK: }

// CHECK: !6 = distinct !DIGlobalVariable(name: "gf", scope: !2, file: !7, line: {{[0-9]+}}, type: !8, isLocal: false, isDefinition: true)
// CHECK: !8 = !DIBasicType(name: "__ibm128", size: 128, encoding: DW_ATE_float)
