set(vcProjectFile "${RunCMake_TEST_BINARY_DIR}/ControlFlowGuardProject.vcxproj")
if(NOT EXISTS "${vcProjectFile}")
  set(RunCMake_TEST_FAILED "Project file ControlFlowGuardProject.vcxproj does not exist.")
  return()
endif()

set(Is_in_link_section 0)
set(HAS_ControlFlowGuardSetting 0)

file(STRINGS "${vcProjectFile}" lines)
foreach(line IN LISTS lines)
  if(line MATCHES "^ *<LinkControlFlowGuard>([^<>]+)</LinkControlFlowGuard>")
      set(RunCMake_TEST_FAILED "Project file ControlFlowGuardProject.vcxproj contains the invalid <LinkControlFlowGuard> link property.")
      return()
    break()
  endif()
  if(line MATCHES "^ *<Link>")
    # The start of the link section of the vcxproj file
    set(Is_in_link_section 1)
    continue()
  endif()
  if(line MATCHES "^ *</Link>")
    # The end of the link section of the vcxproj file
    set(Is_in_link_section 0)
    continue()
  endif()
  if(Is_in_link_section)
    if(line MATCHES "^ *<AdditionalOptions>([^<>]+)</AdditionalOptions>")
      if("${CMAKE_MATCH_1}" MATCHES ".*/guard:cf.*")
        set(HAS_ControlFlowGuardSetting 1)
        break()
      endif()
    endif()
  endif()
endforeach()

if(NOT HAS_ControlFlowGuardSetting)
  set(RunCMake_TEST_FAILED "Project file ControlFlowGuardProject.vcxproj does not have '/guard:cf' specified in the <AdditionalOptions> property.")
  return()
endif()
