# ts_param.tcl

proc initparams {} {

  set s {
    { Edit  0 {
        {"Intern" "tedit" "%e"}
        {"vi &" "exbg" "xterm -geometry %g -e vi !i+%! %e"}
    } }
    { Compose 0 {
      {"LaTeX" "exwin" "latex %p"}
      {"TeX" "exwin" "tex %p"}
    } }
    { Reference 0 {
      {"Makeindex" "exwin" "makeindex %r.idx"}
    } }
    { View 0 {
      {"Xdvi" "exwin" "xdvi -geometry %g %r" }
      {"Xdvi &" "exbg" "xdvi -geometry %g %r"}
      {"Ghostview" "exwin" "ghostview %r.ps"}
    } }
    { Print 0 {
      {"DVIPS" exwin "dvips -t a4 !l-t landscape! !0-p %! !9-l %! !c-c %! !o-A! !e-B! !x%! %r"}
    } }
    { Graphic 0 {
      {"XFig &" "exbg" "xfig -geometry %g -but_ 3 -me %o.fig"}
    } }
    { Util 0 {
      {"View Logfile" exwin "less %r.log"}
      {"Delete Waste" exwin "rm *.aux *.log *.toc *.ind *.ilg *.bak"}
      {"Shell" exwin "/bin/sh"}
    } }
    { Filter 0 {
    } }
  }
  return $s
}

proc readparams {} {
  global params ted gparams

  if [catch {set fd [open $params(local_paramfile) r]}] {
    # Check for global options
    if [catch {set fd [open $params(global_paramfile) r]}] {
      # Default values
      set s [initparams]
    } else {
      set s [read $fd]
      close $fd
    }
  } else {
    set s [read $fd]
    close $fd
  }
  foreach cmd {Edit Compose View Print Reference Graphic Util Filter} {
    set params($cmd) {}
    set params(${cmd}_name) {}
    set params(${cmd}_default) 0
  }
  set ted(global_params) {}
  foreach l $s {
    set cmd [lindex $l 0]
    if {[lsearch {Edit Compose View Print Reference Graphic Util Filter} $cmd] \
      >= 0} {
      set default [lindex $l 1]
      set params($cmd) [lindex $l 2]
      set params(${cmd}_name) [lindex [lindex $params($cmd) $default] 0]
      set params(${cmd}_default) $default
    } elseif {$cmd == "Options"} {
#     Set default values
      set gparams(hlplan) "eng"
      set gparams(showicons) 1
      set lopt [lindex $l 1]
      foreach par $lopt {
        set p0 [lindex $par 0]
	set p1 [lindex $par 1]
	set gparams($p0) $p1
      }
    }
  }
}

proc writeparams {} {
  global params ted gparams

  set fd [open $params(local_paramfile) w]
  foreach cmd {Edit Compose Reference View Print Util Graphic Filter} {
    puts $fd "\{ $cmd $params(${cmd}_default) \{"
      foreach l $params($cmd) {
        puts $fd "\{$l\}"
      }
    puts $fd "\} \}"
  }
  puts $fd "\{ Options \{"
  foreach l [array names gparams] {
    puts $fd "\{[list $l $gparams($l)]\}"
  }
  puts $fd "\} \}"
  close $fd
}

proc selectparams {cmd} {
  global params pdlg

  proc PSetFields {i} {
    global pdlg

    set pdlg(sel) $i
    set l [lindex $pdlg(cmds) $i] 
    if {[llength $l] > 0} {set pdlg(name) [lindex $l 0]}
    if {[llength $l] > 1} {set pdlg(cmd) [lindex $l 1]}
    if {[llength $l] > 2} {set pdlg(opt) [lindex $l 2]}
  }

  proc PSelect {i} {
    global pdlg

    .pdlg.lb.b activate $i
    .pdlg.lb.b select anchor $i
    .pdlg.lb.b select set anchor $i
    .pdlg.lb.b see $i
    PSetFields $i
  }

  proc PNext {} {
    global pdlg

    incr pdlg(sel)
    if {$pdlg(sel) >= [.pdlg.lb.b size]} {
      set pdlg(sel) [expr [.pdlg.lb.b size] - 1]
    }
    PSelect $pdlg(sel)
  }
  proc PPrev {} {
    global pdlg

    incr pdlg(sel) -1
    if {$pdlg(sel) < 0} {set pdlg(sel) 0}
    PSelect $pdlg(sel)
  }
  
  proc PAdd {{app ins}} {
    global pdlg params

    foreach f [array names pdlg] {
      set p($f) ""
    }
    if {[InpDlg pdlg .idlg "Parameter" $params(dlg_geom) "Add Parameter" {
      {Name char 15 name}
      {"Exec Proc" char 15 cmd}
      {"Options" char 45 opt}
      } p]} {
      set l [list $pdlg(name) $pdlg(cmd) $pdlg(opt)]
      if {$app == "ins"} {
        set i $pdlg(sel)
      } else {
        set i [llength $pdlg(cmds)]
      }
      set pdlg(cmds) \
        [linsert $pdlg(cmds) $i $l]
      .pdlg.lb.b insert $i $pdlg(name)
      update idletasks
      PSelect $i
    }
  }

  proc PEdit {} {
    global pdlg

    debug "Dialog geometry: $pdlg(geom)"
    if {[InpDlg pdlg .idlg "Parameter" $pdlg(geom) "Edit Parameter" {
      {Name char 15 name}
      {"Exec Proc" char 15 cmd}
      {"Options" char 45 opt}
      } pdlg]} {
      set l [list $pdlg(name) $pdlg(cmd) $pdlg(opt)]
      set pdlg(cmds) \
        [lreplace $pdlg(cmds) $pdlg(sel) $pdlg(sel) $l]
        .pdlg.lb.b delete $pdlg(sel)
        .pdlg.lb.b insert $pdlg(sel) $pdlg(name)
      PSelect $pdlg(sel)
    }
  }
  proc PDel {} {
    global pdlg

    if {[Dialog .ddlg $pdlg(geom) "" "Delete entry $pdlg(name)" \
      question 0 1 {Yes <Any-y>} {No <Any-n>}] == 0} {
      debug "PDel"
      set pdlg(cmds) \
        [lreplace $pdlg(cmds) $pdlg(sel) $pdlg(sel)]
      .pdlg.lb.b delete $pdlg(sel)
      PSelect 0
    }
  }
  
  toplevel .pdlg
  wm transient .pdlg .
#  wm overrideredirect .pdlg 1
  wm geometry .pdlg $params(dlg_geom)
  wm title .pdlg "Select Parameter"

  frame .pdlg.b
  pack .pdlg.b -side right
  button .pdlg.b.ok -text "OK" -font 6x13bold -anchor w \
    -command {set pdlg(ok) 1}
  pack .pdlg.b.ok -side top -padx 5 -pady 5 -fill x
  button .pdlg.b.cancel -text "Cancel" -font 6x13bold -anchor w \
    -command {set pdlg(ok) 0}
  pack .pdlg.b.cancel -side top -padx 5 -pady 5 -fill x
  button .pdlg.b.edit -text "Edit" -underline 0 -font 6x13bold -anchor w \
  -command PEdit
  pack .pdlg.b.edit -side top -padx 5 -pady 5 -fill x
  button .pdlg.b.insert -text "Insert" -underline 0 -font 6x13bold \
    -anchor w -command {PAdd ins}
  pack .pdlg.b.insert -side top -padx 5 -pady 5 -fill x
  button .pdlg.b.append -text "Append" -underline 0 -font 6x13bold -anchor w \
    -command {PAdd app}
  pack .pdlg.b.append -side top -padx 5 -pady 5 -fill x
  button .pdlg.b.delete -text "Delete" -underline 0 -font 6x13bold -anchor w \
    -command {PDel}
  pack .pdlg.b.delete -side top -padx 5 -pady 5 -fill x

  label .pdlg.lsel -text "Select $cmd action" -font fixed
  pack .pdlg.lsel -anchor w
  frame .pdlg.lb 
  pack .pdlg.lb
  scrollbar .pdlg.lb.s -command ".pdlg.lb.b yview"
  listbox .pdlg.lb.b -yscroll ".pdlg.lb.s set" -relief sunken -bd 1
  pack .pdlg.lb.b -side left 
  pack .pdlg.lb.s -side right -fill y
  frame .pdlg.name
  pack .pdlg.name -side bottom -before .pdlg.b
  label .pdlg.name.l -text "Name" -width 10
  entry .pdlg.name.e -textvariable pdlg(name) -width 25 -state disabled
  pack .pdlg.name.l .pdlg.name.e -side left -anchor w
  frame .pdlg.cmd
  pack .pdlg.cmd -side bottom -before .pdlg.name
  label .pdlg.cmd.l -text "Exec proc" -width 10
  entry .pdlg.cmd.e -textvariable pdlg(cmd) -width 25 -state disabled
  pack .pdlg.cmd.l .pdlg.cmd.e -side left
  frame .pdlg.opt
  pack .pdlg.opt -side bottom -before .pdlg.cmd
  label .pdlg.opt.l -text "Call options" -width 10
  entry .pdlg.opt.e -textvariable pdlg(opt) -width 25 -state disabled
  pack .pdlg.opt.l .pdlg.opt.e -side left

  set pdlg(cmds) $params($cmd)
  foreach l $pdlg(cmds) {
    .pdlg.lb.b insert end [lindex $l 0]
  }
  set pdlg(sel) $params(${cmd}_default)
  set pdlg(name) $params(${cmd}_name)
  PSetFields $pdlg(sel)
  # Bindings
  bindtags .pdlg.lb.b [list Listbox .pdlg.lb.b]
  bind .pdlg.lb.b <Any-Return> {set pdlg(ok) 1}
  bind .pdlg.lb.b <Escape>  {set pdlg(ok) 0}
  bind .pdlg.lb.b <Any-a>   {PAdd app}
  bind .pdlg.lb.b <Any-i>   {PAdd ins}
  bind .pdlg.lb.b <Any-e>   {PEdit}
  bind .pdlg.lb.b <Any-d>   {PDel}
  bind .pdlg.lb.b <Delete>  {PDel}
  bind .pdlg.lb.b <Down>    {PSetFields [%W index active]}
  bind .pdlg.lb.b <Up>      {PSetFields [%W index active]}
  bind .pdlg.lb.b <1>	    {PSetFields [%W nearest %y]}
  update
  # Compute geometry
  set x [expr [winfo rootx .pdlg]]
  set y [expr [winfo rooty .pdlg] + [winfo height .pdlg] + 5]
  set pdlg(geom) +$x+$y
  debug "Dialog geometry: $pdlg(geom)"
  PSelect $pdlg(sel)
  set old_focus [focus]
  focus .pdlg.lb.b
  grab .pdlg
  tkwait var pdlg(ok)
  grab release .pdlg
  focus $old_focus
  destroy .pdlg
  if {$pdlg(ok)} {
    set params($cmd) $pdlg(cmds)
    set l [lindex $params($cmd) $pdlg(sel)]
    set params(${cmd}_name) [lindex $l 0]
    set params(${cmd}_default) $pdlg(sel)
    if {$cmd == "Util"} {
      utilmenu .menubar.mUtil
    }
  }
  return
}

proc SaCmd {} {
  global adlg params

  set params($adlg(cmd)_default) [.selact index active]
  set l [lindex $params($adlg(cmd)) $params($adlg(cmd)_default)]
  set params($adlg(cmd)_name) [lindex $l 0]

  grab release .selact
  focus $adlg(focus)
  .selact unpost
  destroy .selact
}

proc SelectAction {w cmd} {
  global adlg params

  #if [winfo exists .selact] {destroy .selact}
  set adlg(list) {}
  set adlg(cmd) $cmd
  catch {menu .selact -tearoff 0}
  .selact delete 0 end
  foreach e $params($cmd) {
    lappend adlg(list) [lindex $e 0]
    .selact add command -label [lindex $e 0] -command {SaCmd}
  }
  set x [winfo rootx $w]
  set y [expr [winfo rooty $w] + [winfo height $w]]
  .selact post $x $y
  .selact activate $params(${cmd}_default)
  set adlg(focus) [focus]
  focus .selact
  grab -global .selact
}

proc Options {} {
  global params odlg gparams

  foreach l [array names gparams] {
    set odlg($l) $gparams($l)
  }
  set odlg(pos) "+[winfo rootx .]+[winfo rooty .]"
###  regexp {\+[0-9]+\+[0-9]+} [wm geometry .] odlg(pos)

  set hlplan {}
  foreach l [glob $params(hlpdir)/*] {
    lappend hlplan [file tail $l]
  }
  toplevel .odlg
  wm transient .odlg .
  wm geometry .odlg $params(dlg_geom)
  wm title .odlg "Global settings"
  
  label .odlg.lpos -text "TS Window Position:" -underline 7
  entry .odlg.epos -textvariable odlg(pos) -relief sunken -bd 2 \
    -width 10
  grid .odlg.lpos -row 0 -column 0 -sticky w
  grid .odlg.epos -row 0 -column 1 -sticky w

  frame .odlg.f1 -height 2 -bd 1 -relief sunken
  grid .odlg.f1 -row 1 -column 0 -columnspan 2 -sticky ew -pady 2

  label .odlg.lhlp -text "Help language:" -underline 0 -anchor w
  listbox .odlg.lishlp -height 2
  set i 0
  set k 0
  foreach l $hlplan {
    .odlg.lishlp insert end $l
    if {$l == $odlg(hlplan)} {set k $i}
    incr i
  }
  .odlg.lishlp activate $k
  .odlg.lishlp select anchor $k
  .odlg.lishlp select set anchor $k
  grid .odlg.lhlp -row 2 -column 0 -sticky w
  grid .odlg.lishlp -row 2 -column 1 -sticky w
  
  frame .odlg.f2 -height 2 -bd 1 -relief sunken
  grid .odlg.f2 -row 3 -column 0 -columnspan 2 -sticky ew -pady 2

  label .odlg.lispell -text "Ispell parameter"
  label .odlg.llang -text "Language (-d):" -underline 0 -anchor w
  entry .odlg.elang -textvariable odlg(splang)
  label .odlg.lenc -text "Encoding (-T):" -underline 0 -anchor w
  entry .odlg.eenc -textvariable odlg(spenc)
  grid .odlg.lispell -row 4 -column 0 -columnspan 2 -sticky w
  grid .odlg.llang -row 5 -column 0 -sticky w
  grid .odlg.elang -row 5 -column 1 -sticky w
  grid .odlg.lenc -row 6 -column 0 -sticky w
  grid .odlg.eenc -row 6 -column 1 -sticky w

  frame .odlg.f3 -height 2 -bd 1 -relief sunken
  grid .odlg.f3 -row 7 -column 0 -columnspan 2 -sticky ew -pady 2

  frame .odlg.b
  grid .odlg.b -row 8 -column 0 -columnspan 2 -sticky ew

  frame .odlg.b.fok -relief sunken -bd 1
  button .odlg.b.ok -text "OK" -command {set odlg(ok) 1}
  button .odlg.b.cancel -text "Cancel" -command {set odlg(ok) 0}
  pack .odlg.b.fok .odlg.b.cancel -side left -padx 10 -pady 5
  pack .odlg.b.ok -padx 5 -pady 5 -in .odlg.b.fok

  foreach w {.odlg.lishlp .odlg.epos .odlg.b.ok .odlg.b.cancel .odlg.elang
    .odlg.eenc} {
    bindtags $w [concat [bindtags $w] .odlg]]
  }
  bind .odlg <Alt-Any-p> {focus .odlg.epos}
  bind .odlg <Alt-Any-h> {focus .odlg.lishlp}
  bind .odlg <Alt-Any-l> {focus .odlg.elang}
  bind .odlg <Alt-Any-e> {focus .odlg.eenc}
  bind .odlg <Control-Return> {set odlg(ok) 1}
  bind .odlg <Escape>         {set odlg(ok) 0}
  set old_focus [focus]
  focus .odlg
  grab .odlg
  tkwait variable odlg(ok)
  grab release .odlg
  if $odlg(ok) {
    foreach l [array names odlg] {
      set gparams($l) $odlg($l)
    }
    if {$odlg(pos) != ""} {
      set gparams(pos) $odlg(pos)
      wm geometry . $odlg(pos)
      SetPos   
    } else {
      set pos [winfo geometry .]
      if {[regexp {\+[0-9]+\+[0-9]+} $pos pos]} {
        set gparams(pos) $pos
      }
    }
    set gparams(hlplan) [lindex $hlplan [.odlg.lishlp index active]]
    .term config -font $odlg(font)
    for {set i 0} {$i < 10} {incr i} {
      if [winfo exists .t$i] {
        .t$i.text config -bg $odlg(background) -fg $odlg(foreground) \
          -font $odlg(font)
      }
    }
  }
  focus $old_focus
  destroy .odlg
}
