%{

     extern char *yytext;
     long int Line_No=1;
     extern void yyerror(char *);
     int i;

#define BOOLEAN int
#define TRUE 1
#define FALSE 0

%}

%union {
     char string[512];
     int def;
}

%token TEXT,RUN,ENDOFFILE,MISC

%type <string> text;

%start done

%%

done:
     | done MISC {
	  printf("%s",yytext);
     }
     | done text MISC {
	  printf("(%s)%s",$2,yytext);
     }
     | done text RUN {
	  printf("\n%% #INCLUDing ``%s''\n\n",$2);
	  ReadFromScript($2);
     }
     | done ENDOFFILE {
	  if (!ReturnToParentScript())
	       return (0);
	  printf("\n%% #END of INCLUDE\n");
     }
     | done RUN {
	  yyerror("contains an indirect run operation");
     }
     ;

text: TEXT {
          strcpy($$,&yytext[1]);
	  for (i=strlen($$); i-- > 0 && $$[i] != ')'; $$[i] = '\0');
	  if ($$[i] == ')')
	       $$[i] = '\0';
     }
     | text TEXT {
	  printf("(%s)",$1);
	  strcpy($$,&yytext[1]);
	  for (i=strlen($$); i-- > 0 && $$[i] != ')'; $$[i] = '\0');
	  if ($$[i] == ')')
	       $$[i] = '\0';
     }
     ;

     
%%

#include "lex.yy.c"


main()
{
     yyparse();
     exit (0);
}
