/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.jmakepdfx;

import com.dickimawbooks.jmakepdfx.InterruptTimerTask;
import com.dickimawbooks.jmakepdfx.Jmakepdfx;
import com.dickimawbooks.jmakepdfx.ProcessListener;

public class PdfxProcessListener
implements ProcessListener {
    private Jmakepdfx app;
    private String message;
    private String errors;
    private Process process;
    private Thread thread;
    private InterruptTimerTask interruptor;

    public PdfxProcessListener(Jmakepdfx jmakepdfx) {
        this.app = jmakepdfx;
        this.message = null;
        this.errors = null;
    }

    @Override
    public void setProcess(Process process) {
        this.process = process;
    }

    @Override
    public void processLine(int n, String string) {
        this.app.setInfo(string);
        if (n > 4 && !string.startsWith("Page")) {
            if (this.message == null) {
                this.message = string;
            } else if (!this.message.contains(string)) {
                this.message = this.message + "\n" + string;
            }
        }
    }

    @Override
    public void processErrorLine(int n, String string) {
        this.errors = this.errors == null ? string : this.errors + "\n" + string;
    }

    @Override
    public void error(Exception exception) {
        this.app.error(exception);
    }

    public String getMessage() {
        return this.message;
    }

    public String getErrors() {
        return this.errors;
    }

    @Override
    public void terminateProcess() {
        if (this.thread != null) {
            Jmakepdfx.debug("Interrupting " + this.thread);
            this.thread.interrupt();
        }
        if (this.process != null) {
            Jmakepdfx.debug("Destroying " + this.process);
            this.process.destroy();
        }
    }

    @Override
    public void setThread(Thread thread) {
        this.thread = thread;
    }

    @Override
    public void setInterruptor(InterruptTimerTask interruptTimerTask) {
        this.interruptor = interruptTimerTask;
    }

    @Override
    public InterruptTimerTask getInterruptor() {
        return this.interruptor;
    }
}

