/*
 * An output filter to produce LaTeX using Paul DuBois' RTF reader
 * WECHTL Erwin
 * Woerthg. 2/18
 * A-2500 Baden
 * AUSTRIA
 *
 * a student of the University in vienna
 * Technische Universitaet Wien
 * Institut fuer Technische Informatik
 * Treitlstr. 3
 * A-1040 WIEN
 * AUSTRIA
 *
 * Changed code from:
 *
 * Written and copyright (c) 1991 by Robert Lupton (rhl@astro.princeton.edu)
 * Permission is granted to freely distribute and modify this code, providing:
 *	1/ This copyright notice is preserved
 *	2/ You send me a copy of any changes for inclusion in a future release
 */
#ifdef __STDC__				/* Convert to a string */
#   define STR(S) #S			/* ANSI */
#   define A(x) x			/* for prototypes */
#else
#   define STR(S) "S"			/* often works... */
#   define A(x)				/* no prototypes */
#endif
#define TW_TO_CA(I) ((I)/(4,5*20.0))	/* convert twips to number of characters */
#define CA_TO_TW(I) ((I)*(4,5*20.0))	/* convert twips to number of characters */
#define TW_TO_PT(I) ((I)/20.0)		/* convert twips to points */
#define TW_TO_IN(I) ((I)/(72*20.0))	/* convert twips to inches. Note that*/
#define IN_TO_TW(I) ((float)(I*72*20))	/* RTF assumes 1" = 72pt, not 72.27 */


/*****************************************************************************/
/*
 * Tab things
 */
#define defaultTabWidth 8
#define TabLeft 0			/* values for type */
#define TabCentre 1
#define TabRight 2
#define TabDecimal 3

typedef struct {
   int pos;				/* positions of tabstops in twips */
   int type;				/* type of centering */
}TABSTOPS;
#define NTABS 12			/* maximum number of tabs */
static void tabstopsInit A((void));
static void start_tabstops A((void));
static int tab=0;
static TABSTOPS tabstops[NTABS],	/* the current values */
	  old_tabstops[NTABS];		/* and the old ones */
static int ignore_tabwidths = 0;	/* ignore the positions of tabs */
static int ntabs = 0;			/* number of tabstops set */
static int old_ntabs = 0;		/* number of tabstops in old_tapstops*/
static tab_num = 0;			/* the number of the next tab */

static void end_table A((void));
static char tabinitold[80];		/* parameters of the last table */
static char tabinitnew[80];		/* parameters of the current table */
static float smaller_cell_factor = 0.7;	/* to de/encrease the width of the cells */
float f;
static int max_cellnr = 0;		/* maximum number of cells of the current table */
static int cellnr = 0;			/* current number of the cell of the current table */
static int endOfLastCell;
static int table_mode = 0;		/* Are we in a table */

static void output_8bit A((int));	/* output a char with 8th bit set */
static void output_str A((char *, int));/* output commands, comments...  */
static void output A((int, int));      	/* output a character and looking for
					   special ones */
static void p6 A((char *));


#define TRUE 1;
#define FALSE 0;

static void UnknownClass A((void));
static void GroupClass A((void));
static void TblAttr A((void));
static void TextClass A((void));
static void CharSet A((void));
static void ControlClass A((void));
static void Destination A((void));
static void SpecialChar A((void));
static void DocAttr A((void));
static void SectAttr A((void));
static void ParAttr A((void));
static void CharAttr A((void));
static void PictAttr A((void));
static void FieldAttr A((void));
static void TOCAttr A((void));
static void PosAttr A((void));
/*****************************************************************************/
/*
 * The flag values for the RTF and LaTeX group stacks
 */
#define Undefined 0			/* LaTeX type */
#define Math 1		
#define Font 2
#define Font_Num 3
#define Font_Size 4
#define Style 5
#define Par_Attr 6
#define Footnote 7
#define Start_Para 8
#define Sub_Super 9
#define TabularInit 11
#define Tabular 12
#define Desti 13
#define Underline 14
#define Paragraph 15
#define NormalWORDstyle 16
#define SpecialWORDstyle 10
#define Header 17
#define LRskip 18
#define Tabstops 19


#define Plain 1				/* RTF and LaTeX flags if(Font) */
#define Bold 2
#define Italic 3
#define Outlined 4
#define Shadow 5
#define SmallCaps 6
#define AllCaps 7
#define StrikeThru 8
#define Invisible 9

#define LeftAlign	   01		/* RTF and LaTeX flags if(Par_Attr) */
#define RightAlign	   02
#define Centred		   04

#define Pageno_Decimal 1		/* pagenumber styles */
#define Pageno_LRoman 2
#define Pageno_URoman 3
/*
 * First the LaTeX stack, used to remember what needs to be written as
 * we close groups (including math groups)
 */
typedef struct latex_group {
   char *str;				/* what needs inserting */
   long type;				/* what type it is */
   long flags;				/* details of the type */
   long saved;				/* save the old value of something */
   struct latex_group *prev;
} LATEX_STACK;


/*****************************************************************************/
/*
 * And then RTF grouping stuff
 */
typedef struct {
   long font;				/* which font */
   int FontNum;
   int FontType;
   int FontSize;
   int sub_super_height;                 /* vertical offset of text */
   int smallcaps;
} CHAR_ATTR;

typedef struct {
   long flags;				/* centering, justification, etc. */
   int parindent;			/* \fi to RTF */
   int leftskip,rightskip;		/* \li/\ri to RTF */
   int parskip;				/* the usual LaTeX parskip */
   int skip_before,skip_after;		/* \sb/\sa to RTF */
} PAR_ATTR;

typedef struct status {
   LATEX_STACK *LaTeX_stack;		/* stack of LaTeX stuff to output */
   CHAR_ATTR char_attr;			/* Character attributes */
   PAR_ATTR par_attr;			/* Paragraph attributes */
   int style;				/* current style (if relevant) */
   struct status *prev;
} RTF_STACK;

static CHAR_ATTR char_attr = {
   Plain,				/* font */
   -1,					/* FontNum */
   0,					/* FontType */
   10,					/* FontSize */
   0,					/* sub super heigh */
   0,					/* smallcaps */
};
#define LaTeXdefault -99
static PAR_ATTR par_attr = {
   0,
   LaTeXdefault,			/* parindent */
   0, 0,				/* left/rightskip */
   0, 0,				/* skip_before/after  */
};
typedef struct LATEXStyle 	LATEXStyle;

struct LATEXStyle
{
	char		*rtfSName;	/* style name */
	int		rtfSNum;	/* style number */
	LATEXStyle	*LaTeXNextStyle;  /* next style in style list */
	char		BeginCommand[80]; /* begin and           */
	char		EndCommand[80];   /* end of LaTeX-command*/
	int		special_WinwordStyle;
	int		stacktype;
	CHAR_ATTR 	char_attr;	 /* Character attributes */
	PAR_ATTR 	par_attr;	 /* Paragraph attributes */
};



static void pop_rtf_group A((void));	/* pop the status group */
static void push_rtf_group A((void));  	/* push the status group */
static int pop_LaTeX_stack A((void));	/* pop the LaTeX stack */
static void push_LaTeX_stack A((char *, int, long));
static int top_LaTeX_flags A((int));	/* return the flags of the stack top */
static RTF_STACK *rtf_ptr;
static RTF_STACK rtf_current;		/* current values of things that
					   get pushed on rtf stack */
static RTF_STACK rtf_default;		/* default values of things that
					   live on the rtf stack */


/*****************************************************************************/
/*
 * Document attributes, not subject to grouping
 */
static int pageno = 1;
static int pageno_style = Pageno_Decimal;
static int pageno_x = 720;		/* 0.5" */
static int pageno_y = 720;		/* 0.5" */
static int lineno = 1;
static int paper_width = 12240;		/* 8.5" */
static int paper_height = 15840;	/* 11" */
static int left_margin = 1800;		/* 1.25" */
static int right_margin = 1800;		/* 1.25" */
static int top_margin = 1440;		/* 1.5" */
static int bottom_margin = 1440;	/* 1.5" */


/*****************************************************************************/

static void end_para A((void));		/* print the end-of-para string */
static void msg_map_to A((char *, char *));/* treat one keyword as another */
static void msg_not_needed A((char *));	/* LaTeX doesn't need this keyword */
static void msg_not_supported A((char *));/* LaTeX can't use this keyword */
static void msg_not_yet A((char *));	/* Not yet supported */
static void in_math A((char *));	/* output must be in math mode */
static void initialise A((void));	/* initialise the document */
static char *page_num A((void));	/* a string giving the current pageno*/
static void print_text A((char **, FILE *));/* print some text (char *text[]) */
static void read_pict A((void));	/* read an rtfPict destination */
static void set_font A((int, int, char *, char *));/* switch to a new font */
static void set_headfoot_lines A((void));/* set \head/footline */
static void start_para A((void));	/* Called at the start of each para */
static char *LaTeX_name A((char *));	/* remove spaces from a word */
static void update_current A((void));	/* update the current state */
static void set_subsuper A((int));
static void set_smallcaps A((void));
static void usage A((void));		/* print a helpful message */
static char *StrSave A((char *));
static void DefineStyles A((void));
static void setstylecommand A((int));
static void set_fontsize A((int));

static char buff[100];			/* temporary scratch space */

static int change_headfoot = 1;		/* change the \head/footline? */
static int default_font = -1;		/* The default font */
static int end_of_par = 0;		/* we just saw rtfPar */
static int footnote_num0 = 1;		/* the starting footnote number */
static int footnotes_restart_each_page = 1; /* as it says */
static int in_table = 0;		/* are we in a table? */
static int inDefineStyle;		/* In this procedure */
static int initialised = 0;		/* have we called initialise() yet? */
static int verbose = 0;			/* shall we output some information on stderr */
static noUnderline = 0;			/* change underline to italic */
static int header_on = 1;		/* use RTR_header (if 0 use LaTeX default header */
static int rl_skip_on = 1;		/* translate left and right skip of paragraphs
					   may cause some trouble */
static int other_linebreak = 0; 	/* use \hfil\break instead of \\ 
					   for making a new line    */
static int tabstops_on = 1;
static int formatting_para = 1;         /* translate paragraph formating stuff */
static int formatting_char = 1;		/* translate character formating stuff */
static int formatting_table = 1;	/* formating in tables? default: on */
static int formatting_sWORD = 0;        /* use WORD-style for heading, footer
					   (if 0 use LaTeX default formatting */
static int Cformatting_para;		/* current formating on? */
static int Cformatting_char;
static int no_grouping = 0;		/* don't allow any LaTeX font grouping */
static int rtf_group = 0;		/* level of RTF grouping */
static int text_out = 0;		/* we are actually writing text */
static int LaTeX_group = 0;		/* level of RTF grouping */
static int writing_defs = 0;		/* are we writing macro definitions? */
static int german_squotes =0;		/* German single quotes on output ? */
static int german_dquotes =0;		/* German double quotes on output ? */
static int quotecount =0;		/* Count doublequotes if next true */
static int translate_quotes =0;		/* Translate doublequotes to
					 * alternating begin and end quotes
					 */

#define line_length 255			/* the parameter for fgets */
static void read_code_file A((char *));	/* file with the characters above 128 */
static void open_code_file A((char *));	/* file with the characters above 128 */
static void open_land_file A((char *));	/* file with the special WORD styles */
static FILE *fpcode, *fpland;

