/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.bibeditor;

import java.util.ArrayList;
import net.sourceforge.texlipse.bibeditor.BibColorProvider;
import net.sourceforge.texlipse.bibeditor.BibCommandRule;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

public class BibCodeScanner
extends RuleBasedScanner {
    public BibCodeScanner(BibColorProvider provider) {
        Token keyword = new Token((Object)new TextAttribute(provider.getColor("key.BibColor")));
        Token comment = new Token((Object)new TextAttribute(provider.getColor("slc.BibColor")));
        Token other = new Token((Object)new TextAttribute(provider.getColor("def.BibColor")));
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new EndOfLineRule("%", (IToken)comment));
        rules.add(new BibCommandRule((IToken)keyword));
        rules.add(new WhitespaceRule((IWhitespaceDetector)new WhitespaceDetector()));
        WordRule wordRule = new WordRule((IWordDetector)new BibWordDetector(), (IToken)other);
        rules.add(wordRule);
        IRule[] result = new IRule[rules.size()];
        rules.toArray(result);
        this.setRules(result);
    }

    private class BibWordDetector
    implements IWordDetector {
        private BibWordDetector() {
        }

        public boolean isWordPart(char character) {
            return Character.isJavaIdentifierPart(character);
        }

        public boolean isWordStart(char character) {
            return Character.isJavaIdentifierStart(character);
        }
    }

    private class WhitespaceDetector
    implements IWhitespaceDetector {
        private WhitespaceDetector() {
        }

        public boolean isWhitespace(char character) {
            return Character.isWhitespace(character);
        }
    }
}

