/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.bibeditor;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.texlipse.bibparser.BibOutlineContainer;
import net.sourceforge.texlipse.model.ReferenceEntry;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class BibContentProvider
implements ITreeContentProvider {
    private IPositionUpdater fPositionUpdater = new DefaultPositionUpdater("__bib_segments");
    private Map contentIndex = new HashMap();
    private BibOutlineContainer content;
    private String sortBy = "natural";
    private IDocument document;

    public BibContentProvider(IDocument document) {
        this.document = document;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput != null) {
            BibOutlineContainer inp;
            this.content = inp = (BibOutlineContainer)newInput;
            if (inp.getSorting().equals("natural")) {
                this.contentIndex.clear();
                this.contentIndex.put("natural", inp);
                if (!"natural".equals(this.sortBy)) {
                    this.content = this.changeSort(this.sortBy);
                }
            }
            if (this.document != null) {
                this.document.addPositionUpdater(this.fPositionUpdater);
            }
        }
    }

    public void dispose() {
        if (this.contentIndex != null) {
            this.contentIndex.clear();
            this.contentIndex = null;
        }
        if (this.content != null) {
            this.content = null;
        }
    }

    private Object[] getContainerChildren(BibOutlineContainer boc) {
        if (boc.getChildEntries() != null) {
            return boc.getChildEntries().toArray();
        }
        return boc.getChildContainers().toArray();
    }

    public Object[] getElements(Object element) {
        return this.getContainerChildren(this.content);
    }

    public boolean hasChildren(Object element) {
        return !(element instanceof ReferenceEntry);
    }

    public Object getParent(Object element) {
        return null;
    }

    public Object[] getChildren(Object element) {
        if (element instanceof BibOutlineContainer) {
            return this.getContainerChildren((BibOutlineContainer)element);
        }
        return new Object[0];
    }

    public BibOutlineContainer changeSort(String sBy) {
        BibOutlineContainer newContainer = this.content;
        if (this.contentIndex.containsKey(sBy)) {
            newContainer = (BibOutlineContainer)this.contentIndex.get(sBy);
        } else {
            if ("year".equals(sBy)) {
                newContainer = ((BibOutlineContainer)this.contentIndex.get("natural")).buildYearSort();
            } else if ("author".equals(sBy)) {
                newContainer = ((BibOutlineContainer)this.contentIndex.get("natural")).buildAuthorSort();
            } else if ("index".equals(sBy)) {
                newContainer = ((BibOutlineContainer)this.contentIndex.get("natural")).buildIndexSort();
            } else if ("journal".equals(sBy)) {
                newContainer = ((BibOutlineContainer)this.contentIndex.get("natural")).buildJournalSort();
            }
            this.contentIndex.put(sBy, newContainer);
        }
        this.sortBy = sBy;
        return newContainer;
    }
}

