/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.editor;

import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.editor.TexCompletionProcessor;
import net.sourceforge.texlipse.model.TexCommandEntry;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;

public class TexCompletionProposal
implements ICompletionProposal {
    private TexCommandEntry fentry;
    private int fReplacementOffset;
    private int fReplacementLength;
    private ISourceViewer fviewer;

    public TexCompletionProposal(TexCommandEntry entry, int replacementOffset, int replacementLength, ISourceViewer viewer) {
        this.fentry = entry;
        this.fReplacementLength = replacementLength;
        this.fReplacementOffset = replacementOffset;
        this.fviewer = viewer;
    }

    public void apply(IDocument document) {
        try {
            if (this.fentry.arguments > 0) {
                StringBuffer displayKey = new StringBuffer(this.fentry.key);
                int j = 0;
                while (j < this.fentry.arguments) {
                    displayKey.append("{}");
                    ++j;
                }
                document.replace(this.fReplacementOffset, this.fReplacementLength, displayKey.toString());
                if (TexlipsePlugin.getDefault().getPreferenceStore().getBoolean("texBracketCompletion")) {
                    LinkedModeModel model = new LinkedModeModel();
                    int j2 = 0;
                    while (j2 < this.fentry.arguments) {
                        int newOffset = this.fReplacementOffset + this.fentry.key.length() + j2 * 2 + 1;
                        LinkedPositionGroup group = new LinkedPositionGroup();
                        group.addPosition(new LinkedPosition(document, newOffset, 0, -1));
                        model.addGroup(group);
                        ++j2;
                    }
                    model.forceInstall();
                    EditorLinkedModeUI ui = new EditorLinkedModeUI(model, (ITextViewer)this.fviewer);
                    ui.setSimpleMode(false);
                    ui.setExitPolicy((LinkedModeUI.IExitPolicy)new ExitPolicy('}', this.fviewer));
                    ui.setExitPosition((ITextViewer)this.fviewer, this.fReplacementOffset + displayKey.length(), 0, Integer.MAX_VALUE);
                    ui.setCyclingMode(LinkedModeUI.CYCLE_NEVER);
                    ui.enter();
                }
            } else {
                document.replace(this.fReplacementOffset, this.fReplacementLength, this.fentry.key);
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    public Point getSelection(IDocument document) {
        if (this.fentry.arguments > 0) {
            return new Point(this.fReplacementOffset + this.fentry.key.length() + 1, 0);
        }
        return new Point(this.fReplacementOffset + this.fentry.key.length(), 0);
    }

    public String getAdditionalProposalInfo() {
        return this.fentry.info.length() > 60 ? TexCompletionProcessor.wrapString(this.fentry.info, 60) : this.fentry.info;
    }

    public String getDisplayString() {
        return this.fentry.key;
    }

    public Image getImage() {
        return this.fentry.getImage();
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    protected static class ExitPolicy
    implements LinkedModeUI.IExitPolicy {
        final char fExitCharacter;
        ISourceViewer fviewer;

        public ExitPolicy(char exitCharacter, ISourceViewer viewer) {
            this.fExitCharacter = exitCharacter;
            this.fviewer = viewer;
        }

        public LinkedModeUI.ExitFlags doExit(LinkedModeModel environment, VerifyEvent event, int offset, int length) {
            if (event.character == this.fExitCharacter) {
                if (this.fviewer.getDocument().getChar(offset) == this.fExitCharacter) {
                    event.doit = false;
                }
                try {
                    if (this.fviewer.getDocument().getChar(offset + 1) == '{') {
                        this.fviewer.setSelectedRange(offset + 2, 0);
                    } else {
                        this.fviewer.setSelectedRange(offset + 1, 0);
                    }
                    return null;
                }
                catch (BadLocationException badLocationException) {
                    try {
                        this.fviewer.setSelectedRange(offset + 1, 0);
                    }
                    catch (BadLocationException badLocationException2) {}
                }
            } else if (event.character == '{') {
                try {
                    if (this.fviewer.getDocument().getChar(offset - 1) == '{') {
                        event.doit = false;
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
            return null;
        }
    }
}

