/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.outline;

import java.util.HashSet;
import net.sourceforge.texlipse.model.OutlineNode;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class TexOutlineFilter
extends ViewerFilter {
    private HashSet visibleTypes = new HashSet();
    private HashSet visibleEnvironments = new HashSet();

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        OutlineNode node = (OutlineNode)element;
        Integer nodeType = new Integer(node.getType());
        if (this.visibleTypes.contains(nodeType)) {
            if (nodeType != 13) {
                return true;
            }
            return this.visibleEnvironments.contains(node.getName());
        }
        return false;
    }

    public void toggleType(int nodeType, boolean visible) {
        Integer type = new Integer(nodeType);
        if (visible) {
            this.visibleTypes.add(type);
        } else {
            this.visibleTypes.remove(type);
        }
    }

    public void toggleEnvironment(String environment, boolean visible) {
        if (visible) {
            this.visibleEnvironments.add(environment);
        } else {
            this.visibleEnvironments.remove(environment);
        }
    }

    public boolean isEnvironmentVisible(String environment) {
        return this.visibleEnvironments.contains(environment);
    }

    public boolean isTypeVisible(int type) {
        return this.visibleTypes.contains(new Integer(type));
    }

    public void reset() {
        this.visibleTypes.clear();
        this.visibleEnvironments.clear();
    }
}

