/* -*-C-*-
 * ###################################################################
 *  Cpptcl - integrating C++ with Tcl
 * 
 *  FILE: "aaa_cpptcl_docs.h"
 *                                    created: 16/6/96 {5:44:14 pm} 
 *                                last update: 16/7/97 {3:05:12 pm} 
 *  Author: Vince Darley
 *  E-mail: <darley@fas.harvard.edu>
 *    mail: Division of Applied Sciences, Harvard University
 *          Oxford Street, Cambridge MA 02138, USA
 *     www: <http://www.fas.harvard.edu/~darley/>
 *  
 *  Description: Top-level documentation for EvoX
 * 
 * ###################################################################
 */

//@Man: A Quick Introduction
/*@TeX:

\begin{center}
	{\HUGE Cpptcl and EvoX}\\	
	{\Large A \CC/Tcl/Tk meta_object system}
	{\Large and extendable simulation environment}

{\large by Vince Darley}

Division of Applied Sciences \\
Harvard University \\
33 Oxford Street \\
Cambridge MA 02138
\end{center}

{\large Abstract}

People use \CC because it is both powerful and efficient.  People use
Tcl and Tk because they allow rapid prototyping, simple scripting
and building of graphical interfaces with great ease.

My approach is that one should use each language for what it does best,
and so I have built a series of libraries which link \CC and Tcl.
The way in which I use these libraries for my research is as follows:
\CC simulation objects are coded, then simulations are created via
simple Tcl scripts (either manually or by the GUI which records actions 
automatically).  These simulations can then run without sacrificing any
of \CC's efficiency, yet they may still be adjusted, examined or changed on 
the fly using Tcl.

EvoX's a cool tool for the simulation of complex systems. It's an meta_object 
based, \CC class system with various analysis tools included. EvoX has a 
tcl/tk interface, large parts of which use the `[incr tcl]' extension for 
meta_object oriented capabilities. This provides a largely parallel class hierarchy 
embodying the interface-relevant parts of a given model world. EvoX is 
very simply extensible and specialisable both in terms of creating new 
\CC objects for a user's simulations and in terms of extending the 
interface if desired (although this is not normally necessary). Lastly 
EvoX uses a distributed programming paradigm so that simulations running 
locally or remotely may be examined, adjusted and analysed using a single 
interface.


{\large Overview}

EvoX stands for `Evolution in complex systems'.  It is a simulation 
environment, designed for the investigation of emergent phenomena, but 
sufficiently general that it can be used for many purposes. For example 
I have used EvoX for studying the effects of a deforming topology on an 
evolving population, feedback interactions in a simple artificial economy 
of agents and comparative studies of optimisation algorithms on travelling 
salesman problems.

EvoX is based around a \CC class hierarchy implementing simulation and 
analysis objects, overlain with a Tcl/Tk meta_object-oriented graphical user 
interface.  As well as communicating with each other in the usual \CC 
fashion of public interfaces and member function calls, EvoX provides a 
secondary method in which objects explicitly declare observables and events 
they can provide and sockets which other events may call.  This 
`EvoX-interface' (provided by, but only a part of the \CC interface) is 
manipulated by the EvoX environment. 

EvoX currently requires the latest release of Tcl (as of May
1996). This is Tcl7.5.  It includes cross-platform support (for Unix,
MacOS and Windows), and supports dynamic loading of Tcl extensions, which
is why older versions are not supported.

You are currently reading the programmer's documentation, and on-line
reference.  For a more general introduction to EvoX, go to 
\URL{http://www.fas.harvard.edu/~darley/evox/evox/evox.html}
(you should at least read that first)

EvoX is built upon Cpptcl.  Cpptcl contains two libraries which are also 
extremely useful for general \CC -Tcl interaction, and can be used 
completely separately from the rest of the EvoX system and hierarchy.  
These libraries are `Cpptcl' and `Cpptclextra'; their documentation 
contains details of such usage.

So, EvoX and Cpptcl are divided into 5 libraries:

\begin{description} 
  \item[Cpptcl] integrates \CC with Tcl.  Has
  facilities for creation, destruction and manipulation of \CC objects
  from Tcl.  It also contains utilities which make it much, much easier to
  parse the Tcl argument lists (argc,argv), using a very natural, extensible
  stream based approach for examining arguments.  This has the nice side-effect
  or allowing help, error messages and syntax messages to be generated 
  automatically by my \CC -Tcl interface.

  \item[Cpptclextra] if you wish to allow access to \CC data members, enclose
  one Tcl meta_object inside another, have Tk-like configuration options for data
  members, allow run-time message passing, data gathering and file manipulation
  all from the Tcl interface (and yet separate from that interface too!) then this
  is the library to use.

  \item[EvoXTclExtra] EvoX simulation classes.

  \item[EvoXLib] EvoX simulation classes.

  \item[EvoXBaseClasses] EvoX simulation classes.

\end{description}

*/

//@Man: Cpptcl library
//@Type: CHAPTER
/** 
 * In order to integrate any C or \CC code with Tcl it is necessary to declare 
 * to the Tcl interpreter(s) the new commands implemented by one's Tcl code. 
 * This library contains three simple \CC classes which perform this feat. One 
 * class implements a \CC Tcl-intepreter stream class, allowing \CC addicts 
 * to use Tcl-interpreters in a more \CC kind of way. Another two classes 
 * implement the glue which connects Tcl commands to \CC objects. 
 * 
 * The end result for the user is that any \CC meta_object which needs to be 
 * creatable and manipulable from Tcl need just inherit from the classs 
 * `tcl_object', and a function call must be made once in your preamble to 
 * declare the meta_object type.
 * 
 * Furthermore a couple of support classes are included to facilitate the 
 * parsing of commands from Tcl into \CC. A stream based class 
 * `tcl_args' allows rapid parsing of any Tcl command, including 
 * automatic signalling of parsing errors, with informative error messages 
 * including syntax, help and available command information -- this makes the 
 * Tcl interface to any \CC meta_object self-documenting!
 * 
 * Hence this library may be of use to anyone wishing to write \CC extensions 
 * to Tcl. The overhead in terms of code size and speed is negligible.
 */

