/*
 * Decompiled with CFR 0.152.
 */
package nts.hyph;

import java.io.Serializable;

public class HyphNode
implements Serializable {
    public static final HyphNode NULL;
    public static final HyphNode ZERO;
    public final int offset;
    public final int value;
    public final HyphNode next;

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof HyphNode)) {
            return false;
        }
        HyphNode that = (HyphNode)obj;
        return this.offset == that.offset && this.value == that.value && this.next == that.next;
    }

    public boolean isZero() {
        return this.offset == 0 && this.value == 0 && this.next == null;
    }

    public int hashCode() {
        int code = 0;
        HyphNode hyph = this;
        do {
            code += 313 * (1009 * hyph.offset + hyph.value);
        } while ((hyph = hyph.next) != null);
        return code;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        HyphNode hyph = this;
        do {
            buf.append(" ->").append(hyph.offset).append(": ").append(hyph.value);
        } while ((hyph = hyph.next) != null);
        return buf.toString();
    }

    public HyphNode(int offset, int value, HyphNode next) {
        this.offset = offset;
        this.value = value;
        this.next = next;
    }

    static {
        ZERO = new HyphNode(0, 0, null);
    }
}

