/*
 * Decompiled with CFR 0.152.
 */
package nts.node;

import nts.base.Dimen;
import nts.node.LinesShape;

public class HangIndent
implements LinesShape {
    private final int boundary;
    private final Dimen firstWidth;
    private final Dimen firstIndent;
    private final Dimen secondWidth;
    private final Dimen secondIndent;

    public boolean isFinal(int idx) {
        return idx >= this.boundary;
    }

    public Dimen getWidth(int idx) {
        return idx < this.boundary ? this.firstWidth : this.secondWidth;
    }

    public Dimen getIndent(int idx) {
        return idx < this.boundary ? this.firstIndent : this.secondIndent;
    }

    public static LinesShape makeShape(int ha, Dimen hi, Dimen hs) {
        Dimen size;
        Dimen ind;
        if (hi.isZero()) {
            return new HangIndent(hs, Dimen.ZERO);
        }
        if (hi.lessThan(0)) {
            ind = Dimen.ZERO;
            Dimen dimen = hs.plus(hi);
        } else {
            ind = hi;
            size = hs.minus(hi);
        }
        return ha < 0 ? new HangIndent(-ha, size, ind, hs, Dimen.ZERO) : new HangIndent(ha, hs, Dimen.ZERO, size, ind);
    }

    public HangIndent(int b, Dimen fw, Dimen fi, Dimen sw, Dimen si) {
        this.boundary = b;
        this.firstWidth = fw;
        this.firstIndent = fi;
        this.secondWidth = sw;
        this.secondIndent = si;
    }

    public HangIndent(Dimen sw, Dimen si) {
        this(0, Dimen.ZERO, Dimen.ZERO, sw, si);
    }
}

