Package polexpr README
======================

Usage
-----

The package can be used with TeX based formats incorporating the
e-TeX primitives.  The `\expanded` primitive available generally
since TeXLive 2019 is required.

    \input polexpr.sty

with Plain or other non-LaTeX macro formats, or:

    \usepackage{polexpr}

with the LaTeX macro format.

The package currently requires xintexpr.sty `1.4d` or later.

Abstract
--------

The package provides a parser `\poldef` of algebraic polynomial
expressions.  As it is based on
[xintexpr](http://www.ctan.org/pkg/xint)
the coefficients are allowed to be arbitrary rational numbers.

Once defined, a polynomial is usable by its name either as a numerical
function in `\xintexpr/\xinteval`, or for additional polynomial
definitions, or as argument to the package macros.  The localization of
real roots to arbitrary precision as well as the determination of all
rational roots is implemented via such macros.

Since release `0.8`, polexpr extends the
[xintexpr](http://www.ctan.org/pkg/xint) syntax to recognize
polynomials as a new variable type (and not only as functions).
Functionality which previously was implemented via macros such as the
computation of a greatest common divisor is now available directly in
`\xintexpr`, `\xinteval` or `\poldef` via infix or functional syntax.

Releases
--------

- 0.1 (2018/01/11)
  Initial release (files README, polexpr.sty).
- 0.2 (2018/01/14)
  Documentation moved to polexpr.{txt,html}.
- 0.3 (2018/01/17)
  Make polynomials known to `\xintfloatexpr` and improve
    documentation.
- 0.3.1 (2018/01/18)
  Fix two typos in documentation.
- 0.4 (2018/02/16)
  - Revert 0.3 automatic generation of floating point variants.
  - Move CHANGE LOG from README.md to HTML documentation.
  - A few bug fixes and breaking changes. Please refer to
      `polexpr.html`.
  - Main new feature: root localization via [Sturm
      Theorem](https://en.wikipedia.org/wiki/Sturm%27s_theorem).
- 0.4.1 (2018/03/01)
  Synced with xintexpr 1.3.
- 0.4.2 (2018/03/03)
  Documentation fix.
- 0.5 (2018/04/08)
  - new macros `\PolMakePrimitive` and `\PolIContent`.
  - main (breaking) change: `\PolToSturm` creates a chain of primitive
      integer coefficients polynomials.
- 0.5.1 (2018/04/22)
  The `'` character can be used in polynomial names.
- 0.6 (2018/11/20)
  New feature: multiplicity of roots.
- 0.7 (2018/12/08), 0.7.1 (bugfix), 0.7.2 (bugfix) (2018/12/09)
  New feature: finding all rational roots.
- 0.7.3 (2019/02/04)
  Bugfix: polynomial names ending in digits caused errors. Thanks to
  Thomas Söll for report.
- 0.7.4 (2019/02/12)
  Bugfix: 20000000000 is too big for \numexpr, shouldn't I know that?
  Thanks to Jürgen Gilg for report.
- 0.7.5 (2020/01/31)
  Synced with xintexpr 1.4. Requires it.
- 0.8 (2021/03/29)
  Complete refactoring of the package core for better integration with
  and enhancement of xintexpr 1.4.
- 0.8.1 (2021/04/12)
  Bugfix: a typo broke the 0.8 ``diff1()`` and related functions.
- 0.8.2 (2021/05/05)
  Track `xintexpr` 1.4e changes

Files of 0.8.2 release:

- polexpr.sty, polexprcore.tex, polexprexpr.tex, polexprsturm.tex,
- README.md,
- polexpr.html (documentation)

Acknowledgments
---------------

Thanks to Jürgen Gilg whose question about
[xintexpr](http://www.ctan.org/pkg/xint) usage for differentiating
polynomials was the initial trigger leading to this package, and to
Jürgen Gilg and Thomas Söll for testing it on some concrete problems.

License
-------

Copyright (C) 2018-2021 Jean-François Burnol

See documentation of package [xintexpr](http://www.ctan.org/pkg/xint) for
contact information.

This Work may be distributed and/or modified under the conditions of the
LaTeX Project Public License version 1.3c. This version of this license
is in

> <http://www.latex-project.org/lppl/lppl-1-3c.txt>

and version 1.3 or later is part of all distributions of LaTeX version
2005/12/01 or later.

This Work has the LPPL maintenance status author-maintained.

The Author of this Work is Jean-François Burnol.

This Work consists of the package files polexpr.sty, polexprcore.tex,
polexprexpr.tex, polexprsturm.tex, this README.md and polexpr.html.
