#!/bin/bash

pushd $(dirname $0) > /dev/null
HERE=$(pwd)
popd

if [ -z $1 ]; then
    echo "Argument 1 is the classname to analyze."
    exit
fi
CLASSNAME="$1"
SRCDIR=$HERE/codecoverage/sources/dev
if [ ! -z $2 ]; then
    SRCDIR="$2"
fi
WORKDIR=$HERE/codecoverage/work
if [ ! -z $3 ]; then
    WORKDIR="$3"
fi


./pmake.sh codecoverage test-ait-2 -Dconfig.classname=$CLASSNAME -Dconfig.datadir=$WORKDIR/coverage/data -Dconfig.srcdir=$SRCDIR -Dconfig.origclassdir=$WORKDIR/classes/dev -Dconfig.covclassdir=$WORKDIR/coverage/classes


