/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.htmlcleaner.BaseToken;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.CleanerTransformations;
import org.htmlcleaner.CommentNode;
import org.htmlcleaner.ContentNode;
import org.htmlcleaner.DoctypeToken;
import org.htmlcleaner.EndTagToken;
import org.htmlcleaner.ITagInfoProvider;
import org.htmlcleaner.TagInfo;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.TagToken;
import org.htmlcleaner.TagTransformation;
import org.htmlcleaner.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HtmlTokenizer {
    private static final int WORKING_BUFFER_SIZE = 1024;
    private BufferedReader _reader;
    private char[] _working = new char[1024];
    private transient int _pos = 0;
    private transient int _len = -1;
    private transient char[] _saved = new char[512];
    private transient int _savedLen = 0;
    private transient DoctypeToken _docType = null;
    private transient TagToken _currentTagToken = null;
    private transient List<BaseToken> _tokenList = new ArrayList<BaseToken>();
    private boolean _asExpected = true;
    private boolean _isScriptContext = false;
    private CleanerProperties props;
    private boolean isOmitUnknownTags;
    private boolean isTreatUnknownTagsAsContent;
    private boolean isOmitDeprecatedTags;
    private boolean isTreatDeprecatedTagsAsContent;
    private boolean isNamespacesAware;
    private boolean isOmitComments;
    private boolean isAllowMultiWordAttributes;
    private boolean isAllowHtmlInsideAttributes;
    private CleanerTransformations transformations;
    private ITagInfoProvider tagInfoProvider;
    private StringBuilder commonStr = new StringBuilder();

    public HtmlTokenizer(Reader reader, CleanerProperties props, CleanerTransformations transformations, ITagInfoProvider tagInfoProvider) throws IOException {
        this._reader = new BufferedReader(reader);
        this.props = props;
        this.isOmitUnknownTags = props.isOmitUnknownTags();
        this.isTreatUnknownTagsAsContent = props.isTreatUnknownTagsAsContent();
        this.isOmitDeprecatedTags = props.isOmitDeprecatedTags();
        this.isTreatDeprecatedTagsAsContent = props.isTreatDeprecatedTagsAsContent();
        this.isNamespacesAware = props.isNamespacesAware();
        this.isOmitComments = props.isOmitComments();
        this.isAllowMultiWordAttributes = props.isAllowMultiWordAttributes();
        this.isAllowHtmlInsideAttributes = props.isAllowHtmlInsideAttributes();
        this.transformations = transformations;
        this.tagInfoProvider = tagInfoProvider;
    }

    private void addToken(BaseToken token) {
        this._tokenList.add(token);
        this.makeTree(this._tokenList);
    }

    abstract void makeTree(List<BaseToken> var1);

    abstract TagNode createTagNode(String var1);

    private void readIfNeeded(int neededChars) throws IOException {
        if (this._len == -1 && this._pos + neededChars >= 1024) {
            int charsRead;
            int numToCopy = 1024 - this._pos;
            System.arraycopy(this._working, this._pos, this._working, 0, numToCopy);
            this._pos = 0;
            int expected = 1024 - numToCopy;
            int size = 0;
            int offset = numToCopy;
            do {
                if ((charsRead = this._reader.read(this._working, offset, expected)) < 0) continue;
                size += charsRead;
                offset += charsRead;
                expected -= charsRead;
            } while (charsRead >= 0 && expected > 0);
            if (expected > 0) {
                this._len = size + numToCopy;
            }
            for (int i = 0; i < (this._len >= 0 ? this._len : 1024); ++i) {
                char ch = this._working[i];
                if (ch < '\u0001' || ch > ' ' || ch == '\n' || ch == '\r') continue;
                this._working[i] = 32;
            }
        }
    }

    List<BaseToken> getTokenList() {
        return this._tokenList;
    }

    private void go() throws IOException {
        ++this._pos;
        this.readIfNeeded(0);
    }

    private void go(int step) throws IOException {
        this._pos += step;
        this.readIfNeeded(step - 1);
    }

    private boolean startsWith(String value) throws IOException {
        int valueLen = value.length();
        this.readIfNeeded(valueLen);
        if (this._len >= 0 && this._pos + valueLen > this._len) {
            return false;
        }
        for (int i = 0; i < valueLen; ++i) {
            char ch2;
            char ch1 = Character.toLowerCase(value.charAt(i));
            if (ch1 == (ch2 = Character.toLowerCase(this._working[this._pos + i]))) continue;
            return false;
        }
        return true;
    }

    private boolean startsWithSimple(String value) throws IOException {
        int valueLen = value.length();
        this.readIfNeeded(valueLen);
        if (this._len >= 0 && this._pos + valueLen > this._len) {
            return false;
        }
        for (int i = 0; i < valueLen; ++i) {
            if (value.charAt(i) == this._working[this._pos + i]) continue;
            return false;
        }
        return true;
    }

    private boolean isWhitespace(int position) {
        if (this._len >= 0 && position >= this._len) {
            return false;
        }
        return Character.isWhitespace(this._working[position]);
    }

    private boolean isWhitespace() {
        return this.isWhitespace(this._pos);
    }

    private boolean isWhitespaceSafe() {
        return Character.isWhitespace(this._working[this._pos]);
    }

    private boolean isChar(int position, char ch) {
        if (this._len >= 0 && position >= this._len) {
            return false;
        }
        return Character.toLowerCase(ch) == Character.toLowerCase(this._working[position]);
    }

    private boolean isChar(char ch) {
        return this.isChar(this._pos, ch);
    }

    private boolean isCharSimple(char ch) {
        return (this._len < 0 || this._pos < this._len) && ch == this._working[this._pos];
    }

    private char getCurrentChar() {
        return this._working[this._pos];
    }

    private boolean isCharEquals(char ch) {
        return this._working[this._pos] == ch;
    }

    private boolean isIdentifierStartChar(int position) {
        if (this._len >= 0 && position >= this._len) {
            return false;
        }
        char ch = this._working[position];
        return Character.isUnicodeIdentifierStart(ch) || ch == '_';
    }

    private boolean isIdentifierStartChar() {
        return this.isIdentifierStartChar(this._pos);
    }

    private boolean isIdentifierChar() {
        if (this._len >= 0 && this._pos >= this._len) {
            return false;
        }
        char ch = this._working[this._pos];
        return Character.isUnicodeIdentifierStart(ch) || Character.isDigit(ch) || Utils.isIdentifierHelperChar(ch);
    }

    private boolean isValidXmlChar() {
        return this.isAllRead() || Utils.isValidXmlChar(this._working[this._pos]);
    }

    private boolean isValidXmlCharSafe() {
        return Utils.isValidXmlChar(this._working[this._pos]);
    }

    private boolean isAllRead() {
        return this._len >= 0 && this._pos >= this._len;
    }

    private void save(char ch) {
        if (this._savedLen >= this._saved.length) {
            char[] newSaved = new char[this._saved.length + 512];
            System.arraycopy(this._saved, 0, newSaved, 0, this._saved.length);
            this._saved = newSaved;
        }
        this._saved[this._savedLen++] = ch;
    }

    private void saveCurrent() {
        if (!this.isAllRead()) {
            this.save(this._working[this._pos]);
        }
    }

    private void saveCurrentSafe() {
        this.save(this._working[this._pos]);
    }

    private void saveCurrent(int size) throws IOException {
        this.readIfNeeded(size);
        int pos = this._pos;
        while (!this.isAllRead() && size > 0) {
            this.save(this._working[pos]);
            ++pos;
            --size;
        }
    }

    private void skipWhitespaces() throws IOException {
        while (!this.isAllRead() && this.isWhitespaceSafe()) {
            this.saveCurrentSafe();
            this.go();
        }
    }

    private boolean addSavedAsContent() {
        if (this._savedLen > 0) {
            this.addToken(new ContentNode(this._saved, this._savedLen));
            this._savedLen = 0;
            return true;
        }
        return false;
    }

    void start() throws IOException {
        this._currentTagToken = null;
        this._tokenList.clear();
        this._asExpected = true;
        this._isScriptContext = false;
        boolean isLateForDoctype = false;
        this._pos = 1024;
        this.readIfNeeded(0);
        boolean isScriptEmpty = true;
        while (!this.isAllRead()) {
            this._savedLen = 0;
            this._currentTagToken = null;
            this._asExpected = true;
            this.readIfNeeded(10);
            if (this._isScriptContext) {
                if (this.startsWith("</script") && (this.isWhitespace(this._pos + 8) || this.isChar(this._pos + 8, '>'))) {
                    this.tagEnd();
                } else if (isScriptEmpty && this.startsWithSimple("<!--")) {
                    this.comment();
                } else {
                    String lastTokenAsString;
                    BaseToken lastToken;
                    boolean isTokenAdded = this.content();
                    if (isScriptEmpty && isTokenAdded && (lastToken = this._tokenList.get(this._tokenList.size() - 1)) != null && (lastTokenAsString = lastToken.toString()) != null && lastTokenAsString.trim().length() > 0) {
                        isScriptEmpty = false;
                    }
                }
                if (this._isScriptContext) continue;
                isScriptEmpty = true;
                continue;
            }
            if (this.startsWith("<!doctype")) {
                if (!isLateForDoctype) {
                    this.doctype();
                    isLateForDoctype = true;
                    continue;
                }
                this.ignoreUntil('<');
                continue;
            }
            if (this.startsWithSimple("</") && this.isIdentifierStartChar(this._pos + 2)) {
                isLateForDoctype = true;
                this.tagEnd();
                continue;
            }
            if (this.startsWithSimple("<!--")) {
                this.comment();
                continue;
            }
            if (this.startsWithSimple("<") && this.isIdentifierStartChar(this._pos + 1)) {
                isLateForDoctype = true;
                this.tagStart();
                continue;
            }
            if (this.props.isIgnoreQuestAndExclam() && (this.startsWithSimple("<!") || this.startsWithSimple("<?"))) {
                this.ignoreUntil('>');
                if (!this.isCharSimple('>')) continue;
                this.go();
                continue;
            }
            this.content();
        }
        this._reader.close();
    }

    private boolean isReservedTag(String tagName) {
        return "html".equals(tagName = tagName.toLowerCase()) || "head".equals(tagName) || "body".equals(tagName);
    }

    private void tagStart() throws IOException {
        TagInfo tagInfo;
        this.saveCurrent();
        this.go();
        if (this.isAllRead()) {
            return;
        }
        String tagName = this.identifier();
        TagTransformation tagTransformation = null;
        if (this.transformations != null && this.transformations.hasTransformationForTag(tagName) && (tagTransformation = this.transformations.getTransformation(tagName)) != null) {
            tagName = tagTransformation.getDestTag();
        }
        if (tagName != null && ((tagInfo = this.tagInfoProvider.getTagInfo(tagName)) == null && !this.isOmitUnknownTags && this.isTreatUnknownTagsAsContent && !this.isReservedTag(tagName) || tagInfo != null && tagInfo.isDeprecated() && !this.isOmitDeprecatedTags && this.isTreatDeprecatedTagsAsContent)) {
            this.content();
            return;
        }
        TagNode tagNode = this.createTagNode(tagName);
        this._currentTagToken = tagNode;
        if (this._asExpected) {
            this.skipWhitespaces();
            this.tagAttributes();
            if (tagName != null) {
                if (tagTransformation != null) {
                    tagNode.transformAttributes(tagTransformation);
                }
                this.addToken(this._currentTagToken);
            }
            if (this.isCharSimple('>')) {
                this.go();
                if ("script".equalsIgnoreCase(tagName)) {
                    this._isScriptContext = true;
                }
            } else if (this.startsWithSimple("/>")) {
                this.go(2);
                if ("script".equalsIgnoreCase(tagName)) {
                    this.addToken(new EndTagToken(tagName));
                }
            }
            this._currentTagToken = null;
        } else {
            this.addSavedAsContent();
        }
    }

    private void tagEnd() throws IOException {
        TagInfo tagInfo;
        TagTransformation tagTransformation;
        this.saveCurrent(2);
        this.go(2);
        if (this.isAllRead()) {
            return;
        }
        String tagName = this.identifier();
        if (this.transformations != null && this.transformations.hasTransformationForTag(tagName) && (tagTransformation = this.transformations.getTransformation(tagName)) != null) {
            tagName = tagTransformation.getDestTag();
        }
        if (tagName != null && ((tagInfo = this.tagInfoProvider.getTagInfo(tagName)) == null && !this.isOmitUnknownTags && this.isTreatUnknownTagsAsContent && !this.isReservedTag(tagName) || tagInfo != null && tagInfo.isDeprecated() && !this.isOmitDeprecatedTags && this.isTreatDeprecatedTagsAsContent)) {
            this.content();
            return;
        }
        this._currentTagToken = new EndTagToken(tagName);
        if (this._asExpected) {
            this.skipWhitespaces();
            this.tagAttributes();
            if (tagName != null) {
                this.addToken(this._currentTagToken);
            }
            if (this.isCharSimple('>')) {
                this.go();
            }
            if ("script".equalsIgnoreCase(tagName)) {
                this._isScriptContext = false;
            }
            this._currentTagToken = null;
        } else {
            this.addSavedAsContent();
        }
    }

    private String identifier() throws IOException {
        this._asExpected = true;
        if (!this.isIdentifierStartChar()) {
            this._asExpected = false;
            return null;
        }
        this.commonStr.delete(0, this.commonStr.length());
        while (!this.isAllRead() && this.isIdentifierChar()) {
            this.saveCurrentSafe();
            this.commonStr.append(this._working[this._pos]);
            this.go();
        }
        while (this.commonStr.length() > 0 && Utils.isIdentifierHelperChar(this.commonStr.charAt(this.commonStr.length() - 1))) {
            this.commonStr.deleteCharAt(this.commonStr.length() - 1);
        }
        if (this.commonStr.length() == 0) {
            return null;
        }
        String id = this.commonStr.toString();
        int columnIndex = id.indexOf(58);
        if (columnIndex >= 0) {
            String prefix = id.substring(0, columnIndex);
            String suffix = id.substring(columnIndex + 1);
            int nextColumnIndex = suffix.indexOf(58);
            if (nextColumnIndex >= 0) {
                suffix = suffix.substring(0, nextColumnIndex);
            }
            id = this.isNamespacesAware ? prefix + ":" + suffix : suffix;
        }
        return id;
    }

    private void tagAttributes() throws IOException {
        while (!this.isAllRead() && this._asExpected && !this.isCharSimple('>') && !this.startsWithSimple("/>")) {
            String attValue;
            this.skipWhitespaces();
            String attName = this.identifier();
            if (!this._asExpected) {
                if (!(this.isCharSimple('<') || this.isCharSimple('>') || this.startsWithSimple("/>"))) {
                    if (this.isValidXmlChar()) {
                        this.saveCurrent();
                    }
                    this.go();
                }
                if (this.isCharSimple('<')) continue;
                this._asExpected = true;
                continue;
            }
            this.skipWhitespaces();
            if (this.isCharSimple('=')) {
                this.saveCurrentSafe();
                this.go();
                attValue = this.attributeValue();
            } else {
                attValue = "empty".equals(this.props.booleanAttributeValues) ? "" : ("true".equals(this.props.booleanAttributeValues) ? "true" : attName);
            }
            if (!this._asExpected) continue;
            this._currentTagToken.setAttribute(attName, attValue);
        }
    }

    private String attributeValue() throws IOException {
        this.skipWhitespaces();
        if (this.isCharSimple('<') || this.isCharSimple('>') || this.startsWithSimple("/>")) {
            return "";
        }
        boolean isQuoteMode = false;
        boolean isAposMode = false;
        this.commonStr.delete(0, this.commonStr.length());
        if (this.isCharSimple('\'')) {
            isAposMode = true;
            this.saveCurrentSafe();
            this.go();
        } else if (this.isCharSimple('\"')) {
            isQuoteMode = true;
            this.saveCurrentSafe();
            this.go();
        }
        while (!(this.isAllRead() || ((!isAposMode || this.isCharEquals('\'')) && (!isQuoteMode || this.isCharEquals('\"')) || !this.isAllowHtmlInsideAttributes && (this.isCharEquals('>') || this.isCharEquals('<')) || !this.isAllowMultiWordAttributes && this.isWhitespaceSafe()) && (isAposMode || isQuoteMode || this.isWhitespaceSafe() || this.isCharEquals('>') || this.isCharEquals('<')))) {
            if (this.isValidXmlCharSafe()) {
                this.commonStr.append(this._working[this._pos]);
                this.saveCurrentSafe();
            }
            this.go();
        }
        if (this.isCharSimple('\'') && isAposMode) {
            this.saveCurrentSafe();
            this.go();
        } else if (this.isCharSimple('\"') && isQuoteMode) {
            this.saveCurrentSafe();
            this.go();
        }
        return this.commonStr.toString();
    }

    private boolean content() throws IOException {
        while (!this.isAllRead()) {
            if (this.isValidXmlCharSafe()) {
                this.saveCurrentSafe();
            }
            this.go();
            if (!this.isCharSimple('<')) continue;
            break;
        }
        return this.addSavedAsContent();
    }

    private void ignoreUntil(char ch) throws IOException {
        while (!this.isAllRead()) {
            this.go();
            if (!this.isChar(ch)) continue;
            break;
        }
    }

    private void comment() throws IOException {
        this.go(4);
        while (!this.isAllRead() && !this.startsWithSimple("-->")) {
            if (this.isValidXmlCharSafe()) {
                this.saveCurrentSafe();
            }
            this.go();
        }
        if (this.startsWithSimple("-->")) {
            this.go(3);
        }
        if (this._savedLen > 0) {
            if (!this.isOmitComments) {
                int len;
                String hyphenRepl = this.props.getHyphenReplacementInComment();
                String comment = new String(this._saved, 0, this._savedLen).replaceAll("--", hyphenRepl + hyphenRepl);
                if (comment.length() > 0 && comment.charAt(0) == '-') {
                    comment = hyphenRepl + comment.substring(1);
                }
                if ((len = comment.length()) > 0 && comment.charAt(len - 1) == '-') {
                    comment = comment.substring(0, len - 1) + hyphenRepl;
                }
                this.addToken(new CommentNode(comment));
            }
            this._savedLen = 0;
        }
    }

    private void doctype() throws IOException {
        this.go(9);
        this.skipWhitespaces();
        String part1 = this.identifier();
        this.skipWhitespaces();
        String part2 = this.identifier();
        this.skipWhitespaces();
        String part3 = this.attributeValue();
        this.skipWhitespaces();
        String part4 = this.attributeValue();
        this.ignoreUntil('<');
        this._docType = new DoctypeToken(part1, part2, part3, part4);
    }

    public DoctypeToken getDocType() {
        return this._docType;
    }
}

