<?php

/*
 * This example takes a source image and outputs an image with four
 * scaled copies of the image.  The original, and the image flipped
 * using the three flip functions: horizontal, vertical, and diagonal.
 *
 * The images are labeled using the ImlibText class, and a background
 * is filled behind them using a filled rectangle from the ImlibDraw class.
 */

require './class.ImlibImage.php';
require './class.ImlibColor.php';
require './class.ImlibCliprect.php';
require './class.ImlibDraw.php';
require './class.ImlibText.php';

$padding = 20;
$thumbw = 170;
$thumbh = '';	// If this is left blank, the height will be calculated
$bgarray = Array(220,115,115,255);
$textarray = Array(255,255,255,255);
$srcname = './lain-closetheworld.png';

// $mode can be 'horizontal', 'vertical', or 'diagonal'
function flipCreate($obj,$mode)
{
   $cb = "flip_$mode";
   $obj->$cb();
   $new = $obj->create_clone();
   $obj->$cb();
   return $new;
}

$im = new ImlibImage();
$im->load($srcname);
$orig = $im->create_scaled($thumbw,$thumbh);
$im->free();
$imw = $orig->get_width();
$imh = $orig->get_height();

// Create the image large enough to fit four scaled copies of $srcname
$dst = new ImlibImage();
$dst->create(2*$imw + 3*$padding, 2*$imh + 5*$padding);

// Load in a font and set the color and image to draw on
$txt = new ImlibText();
$txt->set_color_array($textarray);
$txt->set_image($dst->get_id());
$txt->load('','./Vera',16);

// Get a drawing object and set its color and image to draw on
$box = new ImlibDraw();
$box->set_color_array($bgarray);
$box->set_image($dst->get_id());

$orig_alpha = $orig->has_alpha();
$box->fill_rectangle($padding-3,$padding-3, $imw+6,$imh+6);
$txt->draw($padding,$padding+$imh,'Original');
$orig->blend_onto_image($dst->get_id(),0,0,$orig_alpha,$imw,$imh,
                        $padding,$padding, $imw,$imh,0,$orig_alpha,0);

$horiz = flipCreate($orig,'horizontal');
$horiz_alpha = $horiz->has_alpha();
$box->fill_rectangle(2*$padding-3+$imw,$padding-3, $imw+6,$imh+6);
$txt->draw(2*$padding+$imw,$padding+$imh,'Horizontal');
$horiz->blend_onto_image($dst->get_id(),0,0,$horiz_alpha,$imw,$imh,
                         2*$padding+$imw,$padding, $imw,$imh,0,$horiz_alpha,0);

$vert = flipCreate($orig,'vertical');
$vert_alpha = $vert->has_alpha();
$box->fill_rectangle($padding-3,3*$padding-3+$imh, $imw+6,$imh+6);
$txt->draw($padding,3*$padding+2*$imh,'Vertical');
$vert->blend_onto_image($dst->get_id(),0,0,$vert_alpha,$imw,$imh,$padding,
                        3*$padding+$imh,$imw,$imh,0,$vert_alpha,0);

// In order to keep things simple, this image will be cropped off if it's
// not square.  This is done to keep things simple.  To show the whole
// diagonally cropped image, the dimensions for $dst would need to be
// calculated from the resulting height of the diagonal version of the image
$diag = flipCreate($orig,'diagonal');
$diag_alpha = $diag->has_alpha();
$box->fill_rectangle(2*$padding-3+$imw,3*$padding-3+$imh, $imw+6,$imh+6);
$txt->draw(2*$padding+$imw,3*$padding+2*$imh,'Diagonal');
$diag->blend_onto_image($dst->get_id(),0,0,$diag_alpha,$imw,$imh,2*$padding+$imw,
                        3*$padding+$imh,$imw,$imh,0,$diag_alpha,0);

$dst->save('./flip.png');
$dst->free();

?>
