# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum, EnumMeta
from six import with_metaclass

class _CaseInsensitiveEnumMeta(EnumMeta):
    def __getitem__(self, name):
        return super().__getitem__(name.upper())

    def __getattr__(cls, name):
        """Return the enum member matching `name`
        We use __getattr__ instead of descriptors or inserting into the enum
        class' __dict__ in order to support `name` and `value` being both
        properties for enum members (which live in the class' __dict__) and
        enum members themselves.
        """
        try:
            return cls._member_map_[name.upper()]
        except KeyError:
            raise AttributeError(name)


class DeploymentState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Deployment state.
    """

    #: The deployment can be sent to devices targeted in the deployment.
    ACTIVE = "Active"
    #: A newer deployment with the same targeting exists and no devices will receive this deployment.
    SUPERSEDED = "Superseded"
    #: The deployment has been canceled and no devices will receive it.
    CANCELED = "Canceled"

class DeploymentType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Supported deployment types.
    """

    #: A complete deployment including download, install, and apply actions.
    COMPLETE = "Complete"
    #: A download-only deployment that does not include any install or apply actions. Not currently
    #: supported.
    DOWNLOAD = "Download"
    #: An install-only rollout that does not include any download actions, only install and complete.
    #: Not currently supported.
    INSTALL = "Install"

class DeviceDeploymentState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Deployment state.
    """

    #: Deployment has completed with success.
    SUCCEEDED = "Succeeded"
    #: Deployment is in progress.
    IN_PROGRESS = "InProgress"
    #: Deployment has completed with failure.
    FAILED = "Failed"
    #: Deployment was canceled.
    CANCELED = "Canceled"
    #: Deployment is not compatible with the device.
    INCOMPATIBLE = "Incompatible"

class DeviceGroupType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Supported deployment group types.
    """

    #: The deployment should be sent to all devices in the device class.
    ALL = "All"
    #: The deployment should be sent to the list of devices in the device group definition.
    DEVICES = "Devices"
    #: The deployment should be sent to the list of devices returned by the union of all the device
    #: group definition queries.
    DEVICE_GROUP_DEFINITIONS = "DeviceGroupDefinitions"

class DeviceState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The deployment device state.
    """

    #: Not started (or uninitialized).
    NOT_STARTED = "NotStarted"
    #: Deployment incompatible for this device.
    INCOMPATIBLE = "Incompatible"
    #: Another Deployment is underway for this device.
    ALREADY_IN_DEPLOYMENT = "AlreadyInDeployment"
    #: Deployment has been canceled for this device.
    CANCELED = "Canceled"
    #: Deployment underway.
    IN_PROGRESS = "InProgress"
    #: Deployment failed.
    FAILED = "Failed"
    #: Deployment completed successfully.
    SUCCEEDED = "Succeeded"

class GroupType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Supported group types.
    """

    #: IoT Hub tag based group.
    IO_T_HUB_TAG = "IoTHubTag"

class OperationFilterStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Operation status filter.
    """

    RUNNING = "Running"
    NOT_STARTED = "NotStarted"

class OperationStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Operation status.
    """

    #: Undefined operation status.
    UNDEFINED = "Undefined"
    #: Background operation created but not started yet.
    NOT_STARTED = "NotStarted"
    #: Background operation is currently running.
    RUNNING = "Running"
    #: Background operation finished with success.
    SUCCEEDED = "Succeeded"
    #: Background operation finished with failure.
    FAILED = "Failed"
