# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class DataSetKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Kind of data set."""

    BLOB = "Blob"
    CONTAINER = "Container"
    BLOB_FOLDER = "BlobFolder"
    ADLS_GEN2_FILE_SYSTEM = "AdlsGen2FileSystem"
    ADLS_GEN2_FOLDER = "AdlsGen2Folder"
    ADLS_GEN2_FILE = "AdlsGen2File"
    ADLS_GEN1_FOLDER = "AdlsGen1Folder"
    ADLS_GEN1_FILE = "AdlsGen1File"
    KUSTO_CLUSTER = "KustoCluster"
    KUSTO_DATABASE = "KustoDatabase"
    SQL_DB_TABLE = "SqlDBTable"
    SQL_DW_TABLE = "SqlDWTable"
    SYNAPSE_WORKSPACE_SQL_POOL_TABLE = "SynapseWorkspaceSqlPoolTable"


class DataSetMappingKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Kind of data set mapping."""

    BLOB = "Blob"
    CONTAINER = "Container"
    BLOB_FOLDER = "BlobFolder"
    ADLS_GEN2_FILE_SYSTEM = "AdlsGen2FileSystem"
    ADLS_GEN2_FOLDER = "AdlsGen2Folder"
    ADLS_GEN2_FILE = "AdlsGen2File"
    KUSTO_CLUSTER = "KustoCluster"
    KUSTO_DATABASE = "KustoDatabase"
    SQL_DB_TABLE = "SqlDBTable"
    SQL_DW_TABLE = "SqlDWTable"
    SYNAPSE_WORKSPACE_SQL_POOL_TABLE = "SynapseWorkspaceSqlPoolTable"


class DataSetMappingStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Gets the status of the data set mapping."""

    OK = "Ok"
    BROKEN = "Broken"


class DataSetType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of data set."""

    BLOB = "Blob"
    CONTAINER = "Container"
    BLOB_FOLDER = "BlobFolder"
    ADLS_GEN2_FILE_SYSTEM = "AdlsGen2FileSystem"
    ADLS_GEN2_FOLDER = "AdlsGen2Folder"
    ADLS_GEN2_FILE = "AdlsGen2File"
    ADLS_GEN1_FOLDER = "AdlsGen1Folder"
    ADLS_GEN1_FILE = "AdlsGen1File"
    KUSTO_CLUSTER = "KustoCluster"
    KUSTO_DATABASE = "KustoDatabase"
    SQL_DB_TABLE = "SqlDBTable"
    SQL_DW_TABLE = "SqlDWTable"
    SYNAPSE_WORKSPACE_SQL_POOL_TABLE = "SynapseWorkspaceSqlPoolTable"


class InvitationStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of the invitation."""

    PENDING = "Pending"
    ACCEPTED = "Accepted"
    REJECTED = "Rejected"
    WITHDRAWN = "Withdrawn"


class LastModifiedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that last modified the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class OutputType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of output file."""

    CSV = "Csv"
    PARQUET = "Parquet"


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning state of the Account."""

    SUCCEEDED = "Succeeded"
    CREATING = "Creating"
    DELETING = "Deleting"
    MOVING = "Moving"
    FAILED = "Failed"


class RecurrenceInterval(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Recurrence Interval."""

    HOUR = "Hour"
    DAY = "Day"


class RegistrationStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Registration status."""

    ACTIVATION_PENDING = "ActivationPending"
    ACTIVATED = "Activated"
    ACTIVATION_ATTEMPTS_EXHAUSTED = "ActivationAttemptsExhausted"


class ShareKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Share kind."""

    COPY_BASED = "CopyBased"
    IN_PLACE = "InPlace"


class ShareSubscriptionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Gets the status of share subscription."""

    ACTIVE = "Active"
    REVOKED = "Revoked"
    SOURCE_DELETED = "SourceDeleted"
    REVOKING = "Revoking"


class SourceShareSynchronizationSettingKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Kind of synchronization setting on share."""

    SCHEDULE_BASED = "ScheduleBased"


class Status(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Operation state of the long running operation."""

    ACCEPTED = "Accepted"
    IN_PROGRESS = "InProgress"
    TRANSIENT_FAILURE = "TransientFailure"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"


class SynchronizationMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Synchronization mode."""

    INCREMENTAL = "Incremental"
    FULL_SYNC = "FullSync"


class SynchronizationSettingKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Kind of synchronization setting."""

    SCHEDULE_BASED = "ScheduleBased"


class TriggerKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Kind of synchronization on trigger."""

    SCHEDULE_BASED = "ScheduleBased"


class TriggerStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Gets the trigger state."""

    ACTIVE = "Active"
    INACTIVE = "Inactive"
    SOURCE_SYNCHRONIZATION_SETTING_DELETED = "SourceSynchronizationSettingDeleted"


class Type(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Identity Type."""

    SYSTEM_ASSIGNED = "SystemAssigned"
