from datetime import datetime
from icalendar.parser_tools import to_unicode
from icalendar.prop import vDatetime
from icalendar.prop import vText
from string import ascii_letters
from string import digits

import random


class UIDGenerator:
    """If you are too lazy to create real uid's.

    """
    chars = list(ascii_letters + digits)

    @staticmethod
    def rnd_string(length=16):
        """Generates a string with random characters of length.
        """
        return ''.join([random.choice(UIDGenerator.chars) for _ in range(length)])

    @staticmethod
    def uid(host_name='example.com', unique=''):
        """Generates a unique id consisting of:
            datetime-uniquevalue@host.
        Like:
            20050105T225746Z-HKtJMqUgdO0jDUwm@example.com
        """
        host_name = to_unicode(host_name)
        unique = unique or UIDGenerator.rnd_string()
        today = to_unicode(vDatetime(datetime.today()).to_ical())
        return vText(f'{today}-{unique}@{host_name}')

__all__ = ["UIDGenerator"]
