#pragma once
// DO NOT EDIT. File generated by script update_inlinedoc.py.

#define automaton___reduce___doc \
	"__reduce__()\n" \
	"\n" \
	"Return pickle-able data for this automaton instance."

#define automaton___sizeof___doc \
	"Return the approximate size in bytes occupied by the\n" \
	"Automaton instance in memory excluding the size of\n" \
	"associated objects when the Automaton is created with\n" \
	"Automaton() or Automaton(ahocorasick.STORE_ANY)."

#define automaton_add_word_doc \
	"add_word(key, [value]) -> boolean\n" \
	"\n" \
	"Add a key string to the dict-like trie and associate this\n" \
	"key with a value. value is optional or mandatory depending\n" \
	"how the Automaton instance was created. Return True if the\n" \
	"word key is inserted and did not exists in the trie or False\n" \
	"otherwise. The value associated with an existing word is\n" \
	"replaced.\n" \
	"\n" \
	"The value is either mandatory or optional:\n" \
	"- If the Automaton was created without argument (the\n" \
	"  default) as Automaton() or with\n" \
	"  Automaton(ahocorasik.STORE_ANY) then the value is required\n" \
	"  and can be any Python object.\n" \
	"- If the Automaton was created with\n" \
	"  Automaton(ahocorasik.STORE_INTS) then the value is\n" \
	"  optional. If provided it must be an integer, otherwise it\n" \
	"  defaults to len(automaton) which is therefore the order\n" \
	"  index in which keys are added to the trie.\n" \
	"- If the Automaton was created with\n" \
	"  Automaton(ahocorasik.STORE_LENGTH) then associating a\n" \
	"  value is not allowed - len(word) is saved automatically as\n" \
	"  a value instead.\n" \
	"\n" \
	"Calling add_word() invalidates all iterators only if the new\n" \
	"key did not exist in the trie so far (i.e. the method\n" \
	"returned True)."

#define automaton_clear_doc \
	"clear()\n" \
	"\n" \
	"Remove all keys from the trie. This method invalidates all\n" \
	"iterators."

#define automaton_constructor_doc \
	"Automaton(value_type=ahocorasick.STORE_ANY, [key_type])\n" \
	"\n" \
	"Create a new empty Automaton. Both value_type and key_type\n" \
	"are optional.\n" \
	"\n" \
	"value_type is one of these constants:\n" \
	"- ahocorasick.STORE_ANY [default] : The associated value can\n" \
	"  be any Python object.\n" \
	"- ahocorasick.STORE_LENGTH : The length of an added string\n" \
	"  key is automatically used as the associated value stored\n" \
	"  in the trie for that key.\n" \
	"- ahocorasick.STORE_INTS : The associated value must be a\n" \
	"  32-bit integer.\n" \
	"\n" \
	"key_type defines the type of data that can be stored in an\n" \
	"automaton; it is one of these constants and defines type of\n" \
	"data might be stored:\n" \
	"- ahocorasick.KEY_STRING [default] : string\n" \
	"- ahocorasick.KEY_SEQUENCE : sequences of integers; The size\n" \
	"  of integer depends the version and platform Python, but\n" \
	"  for versions of Python >= 3.3, it is guaranteed to be\n" \
	"  32-bits."

#define automaton_dump_doc \
	"dump()\n" \
	"\n" \
	"Return a three-tuple of lists describing the Automaton as a\n" \
	"graph of nodes, edges, failure links.\n" \
	"- nodes: each item is a pair (node id, end of word marker)\n" \
	"- edges: each item is a triple (node id, label char, child\n" \
	"  node id)\n" \
	"- failure links: each item is a pair (source node id, node\n" \
	"  if connected by fail node)\n" \
	"\n" \
	"For each of these, the node id is a unique number and a\n" \
	"label is a number."

#define automaton_exists_doc \
	"exists(key) -> boolean\n" \
	"\n" \
	"Return True if the key is present in the trie. Same as using\n" \
	"the 'in' keyword."

#define automaton_find_all_doc \
	"find_all(string, callback, [start, [end]])\n" \
	"\n" \
	"Perform the Aho-Corasick search procedure using the provided\n" \
	"input string and iterate over the matching tuples\n" \
	"(end_index, value) for keys found in string. Invoke the\n" \
	"callback callable for each matching tuple.\n" \
	"\n" \
	"The callback callable must accept two positional arguments:\n" \
	"- end_index is the end index in the input string where a\n" \
	"trie key string was found. - value is the value associated\n" \
	"with the found key string.\n" \
	"\n" \
	"The start and end optional arguments can be used to limit\n" \
	"the search to an input string slice as in string[start:end].\n" \
	"\n" \
	"Equivalent to a loop on iter() calling a callable at each\n" \
	"iteration."

#define automaton_get_doc \
	"get(key[, default])\n" \
	"\n" \
	"Return the value associated with the key string.\n" \
	"\n" \
	"Raise a KeyError exception if the key is not in the trie and\n" \
	"no default is provided.\n" \
	"\n" \
	"Return the optional default value if provided and the key is\n" \
	"not in the trie."

#define automaton_get_stats_doc \
	"get_stats() -> dict\n" \
	"\n" \
	"Return a dictionary containing Automaton statistics.\n" \
	"- nodes_count - total number of nodes\n" \
	"- words_count - number of distinct words (same as\n" \
	"  len(automaton))\n" \
	"- longest_word - length of the longest word\n" \
	"- links_count - number of edges\n" \
	"- sizeof_node - size of single node in bytes\n" \
	"- total_size - total size of trie in bytes (about\n" \
	"  nodes_count * size_of node + links_count * size of\n" \
	"  pointer)."

#define automaton_items_doc \
	"items([prefix, [wildcard, [how]]])\n" \
	"\n" \
	"Return an iterator on tuples of (key, value). Keys are\n" \
	"matched optionally to the prefix using the same logic and\n" \
	"arguments as in the keys() method."

#define automaton_iter_doc \
	"iter(string, [start, [end]], ignore_white_space=False)\n" \
	"\n" \
	"Perform the Aho-Corasick search procedure using the provided\n" \
	"input string.\n" \
	"\n" \
	"Return an iterator of tuples (end_index, value) for keys\n" \
	"found in string where:\n" \
	"- end_index is the end index in the input string where a\n" \
	"  trie key string was found.\n" \
	"- value is the value associated with the found key string.\n" \
	"\n" \
	"The start and end optional arguments can be used to limit\n" \
	"the search to an input string slice as in string[start:end].\n" \
	"\n" \
	"The ignore_white_space optional arguments can be used to\n" \
	"ignore white spaces from input string."

#define automaton_iter_long_doc \
	"iter_long(string, [start, [end]])\n" \
	"\n" \
	"Perform the modified Aho-Corasick search procedure which\n" \
	"matches the longest words from set.\n" \
	"\n" \
	"Return an iterator of tuples (end_index, value) for keys\n" \
	"found in string where:\n" \
	"- end_index is the end index in the input string where a\n" \
	"  trie key string was found.\n" \
	"- value is the value associated with the found key string.\n" \
	"\n" \
	"The start and end optional arguments can be used to limit\n" \
	"the search to an input string slice as in string[start:end]."

#define automaton_keys_doc \
	"keys([prefix, [wildcard, [how]]])\n" \
	"\n" \
	"Return an iterator on keys. If the optional prefix string is\n" \
	"provided, only yield keys starting with this prefix.\n" \
	"\n" \
	"If the optional wildcard is provided as a single character\n" \
	"string, then the prefix is treated as a simple pattern using\n" \
	"this character as a wildcard.\n" \
	"\n" \
	"The optional how argument is used to control how strings are\n" \
	"matched using one of these possible values:\n" \
	"- ahocorasick.MATCH_EXACT_LENGTH (default) Yield matches\n" \
	"  that have the same exact length as the prefix length.\n" \
	"- ahocorasick.MATCH_AT_LEAST_PREFIX Yield matches that have\n" \
	"  a length greater or equal to the prefix length.\n" \
	"- ahocorasick.MATCH_AT_MOST_PREFIX Yield matches that have a\n" \
	"  length lesser or equal to the prefix length."

#define automaton_len_doc \
	"len() -> integer\n" \
	"\n" \
	"Return the number of distinct keys added to the trie."

#define automaton_longest_prefix_doc \
	"longest_prefix(string) => integer\n" \
	"\n" \
	"Return the length of the longest prefix of string that\n" \
	"exists in the trie."

#define automaton_make_automaton_doc \
	"make_automaton()\n" \
	"\n" \
	"Finalize and create the Aho-Corasick automaton based on the\n" \
	"keys already added to the trie. This does not require\n" \
	"additional memory. After successful creation the\n" \
	"Automaton.kind attribute is set to ahocorasick.AHOCORASICK."

#define automaton_match_doc \
	"match(key) -> bool\n" \
	"\n" \
	"Return True if there is a prefix (or key) equal to key\n" \
	"present in the trie.\n" \
	"\n" \
	"For example if the key 'example' has been added to the trie,\n" \
	"then calls to match('e'), match('ex'), ..., match('exampl')\n" \
	"or match('example') all return True. But exists() is True\n" \
	"only when calling exists('example')."

#define automaton_pop_doc \
	"pop(word)\n" \
	"\n" \
	"Remove given word from a trie and return associated values.\n" \
	"Raise a KeyError if the word was not found."

#define automaton_remove_word_doc \
	"remove_word(word) -> bool\n" \
	"\n" \
	"Remove given word from a trie. Return True if words was\n" \
	"found, False otherwise."

#define automaton_save_doc \
	"save(path, serializer)\n" \
	"\n" \
	"Save content of automaton in an on-disc file.\n" \
	"\n" \
	"Serializer is a callable object that is used when automaton\n" \
	"store type is STORE_ANY. This method converts a python\n" \
	"object into bytes; it can be pickle.dumps."

#define automaton_search_iter_doc \
	"This class is not available directly but instances of\n" \
	"AutomatonSearchIter are returned by the iter() method of an\n" \
	"Automaton. This iterator can be manipulated through its\n" \
	"set() method."

#define automaton_search_iter_set_doc \
	"set(string, reset=False)\n" \
	"\n" \
	"Set a new string to search. When the reset argument is False\n" \
	"(default) then the Aho-Corasick procedure is continued and\n" \
	"the internal state of the Automaton and end index of the\n" \
	"string being searched are not reset. This allow to search\n" \
	"for large strings in multiple smaller chunks."

#define automaton_values_doc \
	"values([prefix, [wildcard, [how]]])\n" \
	"\n" \
	"Return an iterator on values associated with each keys. Keys\n" \
	"are matched optionally to the prefix using the same logic\n" \
	"and arguments as in the keys() method."

#define module_doc \
	"pyahocorasick is a fast and memory efficient library for\n" \
	"exact or approximate multi-pattern string search meaning\n" \
	"that you can find multiple key strings occurrences at once\n" \
	"in some input text."

#define module_load_doc \
	"load(path, deserializer) => Automaton\n" \
	"\n" \
	"Load automaton previously stored on disc using save method.\n" \
	"\n" \
	"Deserializer is a callable object which converts bytes back\n" \
	"into python object; it can be pickle.loads."
