/*---------------------------------------------------------------------------
 
    python-unac
    
    Copyright (C) Robert Kaye 2005
    
    This file is part of python-unac.
 
    python-unac is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
 
    libtunepimp is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
 
    You should have received a copy of the GNU General Public License
    along with libtunepimp; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 
----------------------------------------------------------------------------*/
#include <Python.h>
#include <unac.h>

static PyObject *_wrap_unac_string(PyObject *self, PyObject *args);
static PyObject *_wrap_unac_string_utf16(PyObject *self, PyObject *args);

static PyMethodDef unacMethods[] = {
     {"_unac_string",  _wrap_unac_string, METH_VARARGS, "unaccent a string"},
     {"_unac_string_utf16",  _wrap_unac_string_utf16, METH_VARARGS, "unaccent a utf16 string"},
     {NULL, NULL, 0, NULL}        /* Sentinel */
};

PyMODINIT_FUNC init_unac(void)
{
    (void) Py_InitModule("_unac", unacMethods);
}

static PyObject *_wrap_unac_string(PyObject *self, PyObject *args)
{
    PyObject   *ret;
    int         status, out_size;
    char       *out = NULL;
    const char *in, *charset;

    if (!PyArg_ParseTuple(args, "ss", &charset, &in))
        return NULL;

    status = unac_string(charset, in, strlen(in), &out, &out_size);
    if (status < 0)
        return Py_BuildValue("s", "");

    ret = Py_BuildValue("s", out);
    free(out);

    return ret;
}

static PyObject *_wrap_unac_string_utf16(PyObject *self, PyObject *args)
{
    PyObject   *ret;
    int         status, out_size;
    char       *out = NULL;
    char       *in;
    int         in_len;

    if (!PyArg_ParseTuple(args, "s#", &in, &in_len))
        return NULL;

    status = unac_string_utf16((char *)in, in_len, &out, &out_size);
    if (status < 0)
        return Py_BuildValue("s", "");

    ret = Py_BuildValue("s#", out, out_size);
    free(out);

    return ret;
}
