/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.style.StandardNames;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.Facet;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.XPathException;

public class AtomicType
extends SimpleType
implements ItemType {
    private boolean builtIn = false;

    public void setIsBuiltIn(boolean yesOrNo) {
        this.builtIn = yesOrNo;
    }

    public boolean isBuiltIn() {
        return this.builtIn;
    }

    public boolean matchesItem(Item item) {
        if (item instanceof AtomicValue) {
            AtomicValue value = (AtomicValue)item;
            AtomicType type = (AtomicType)value.getItemType();
            if (type.getFingerprint() == this.getFingerprint()) {
                return true;
            }
            return Type.isSubType(type, this);
        }
        return false;
    }

    public void validateContent(CharSequence value, NamespaceResolver namespaceResolver) throws ValidationException {
        int f = this.getFingerprint();
        if (f == 513 || f == 593 || f == 642) {
            return;
        }
        if (this.isNamespaceSensitive()) {
            if (namespaceResolver == null) {
                throw new ValidationException("Cannot validate a QName without a namespace context");
            }
            try {
                new StringValue(value).convert(this, namespaceResolver);
            }
            catch (XPathException err) {
                throw new ValidationException(err.getMessage());
            }
        }
        try {
            new StringValue(value).convert(this);
        }
        catch (XPathException err) {
            throw new ValidationException(err.getMessage());
        }
    }

    public SequenceIterator getTypedValue(CharSequence value) throws ValidationException {
        try {
            return SingletonIterator.makeIterator(new StringValue(value).convert(this));
        }
        catch (XPathException err) {
            throw new ValidationException(err.getMessage());
        }
    }

    public ItemType getSuperType() {
        if (this == Type.ATOMIC_TYPE) {
            return AnyItemType.getInstance();
        }
        return (ItemType)((Object)this.getBaseType());
    }

    public int getPrimitiveType() {
        int x = this.getFingerprint();
        if (Type.isPrimitiveType(x)) {
            return x;
        }
        ItemType s = this.getSuperType();
        if (s instanceof AtomicType) {
            return s.getPrimitiveType();
        }
        return this.getFingerprint();
    }

    public String toString() {
        int f = this.getFingerprint();
        if (f < 0) {
            throw new IllegalArgumentException("fingerprint < 0");
        }
        if (f < 1023) {
            return StandardNames.getDisplayName(f);
        }
        return this.getNamePool().getDisplayName(f);
    }

    public String getPattern() {
        Facet patternFacet = this.getFacet("pattern");
        if (patternFacet == null) {
            return null;
        }
        return patternFacet.getValue();
    }

    public boolean isMinInclusive() {
        return this.getFacet("minInclusive") != null;
    }

    public boolean isMaxInclusive() {
        return this.getFacet("maxInclusive") != null;
    }

    public Facet getMin() {
        Facet minInclusiveFacet = this.getFacet("minInclusive");
        if (minInclusiveFacet != null) {
            return minInclusiveFacet;
        }
        Facet minExclusiveFacet = this.getFacet("minExclusive");
        if (minExclusiveFacet != null) {
            return minExclusiveFacet;
        }
        return null;
    }

    public Facet getMax() {
        Facet maxInclusiveFacet = this.getFacet("maxInclusive");
        if (maxInclusiveFacet != null) {
            return maxInclusiveFacet;
        }
        Facet maxExclusiveFacet = this.getFacet("maxExclusive");
        if (maxExclusiveFacet != null) {
            return maxExclusiveFacet;
        }
        return null;
    }

    public boolean isSameType(ItemType other) {
        return other instanceof AtomicType && ((AtomicType)other).getFingerprint() == this.getFingerprint();
    }
}

